/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileLoadingTracker;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.impl.PsiCachedValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualDirectoryImpl
extends VirtualFileSystemEntry {
    private static final Logger LOG = Logger.getInstance(VirtualDirectoryImpl.class);
    private static final boolean CHECK = ApplicationManager.getApplication().isUnitTestMode();
    final VfsData.DirectoryData myData;
    private final NewVirtualFileSystem myFs;

    VirtualDirectoryImpl(int id2, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data2, @Nullable VirtualDirectoryImpl parent, @NotNull NewVirtualFileSystem fs) {
        super(id2, segment, parent);
        this.myData = data2;
        this.myFs = fs;
        if (parent != null) {
            this.registerLink((VirtualFileSystem)fs);
        }
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        return this.myFs;
    }

    @Nullable
    private VirtualFileSystemEntry findChild(@NotNull String name, boolean doRefresh, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate) {
        boolean caseSensitive = delegate.isCaseSensitive();
        VirtualFileSystemEntry result2 = this.doFindChild(name, ensureCanonicalName, delegate, caseSensitive);
        if (result2 == NULL_VIRTUAL_FILE) {
            result2 = doRefresh ? this.createAndFindChildWithEventFire(name, delegate) : null;
        } else if (result2 != null && doRefresh && delegate.isDirectory((VirtualFile)result2) != result2.isDirectory()) {
            RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{result2});
            result2 = this.findChild(name, false, ensureCanonicalName, delegate);
        }
        return result2;
    }

    @Nullable
    private VirtualFileSystemEntry doFindChildInArray(@NotNull String name, boolean caseSensitive) {
        if (this.myData.isAdoptedName(name)) {
            return NULL_VIRTUAL_FILE;
        }
        int[] array2 = this.myData.myChildrenIds;
        int indexInReal = this.findIndex(array2, name, caseSensitive);
        if (indexInReal >= 0) {
            return this.mySegment.vfsData.getFileById(array2[indexInReal], this, true);
        }
        return null;
    }

    @Nullable
    private VirtualFileSystemEntry doFindChild(@NotNull String name, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate, boolean caseSensitive) {
        if (name.isEmpty()) {
            return null;
        }
        if (!this.isValid()) {
            return this.handleInvalidDirectory(null);
        }
        VirtualFileSystemEntry found = this.doFindChildInArray(name, caseSensitive);
        if (found != null) {
            return found;
        }
        if (ensureCanonicalName) {
            String trimmedName = VirtualDirectoryImpl.deSlash(name);
            if (trimmedName == null) {
                return null;
            }
            if (!trimmedName.equals(name)) {
                found = this.doFindChildInArray(trimmedName, caseSensitive);
                if (found != null) {
                    return found;
                }
                name = trimmedName;
            }
        }
        if (this.allChildrenLoaded()) {
            return NULL_VIRTUAL_FILE;
        }
        return this.findInPersistence(name, ensureCanonicalName, delegate, caseSensitive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry findInPersistence(@NotNull String name, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate, boolean caseSensitive) {
        VirtualFileSystemEntry child2;
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            CharSequence persistedName;
            child2 = this.doFindChildInArray(name, caseSensitive);
            if (child2 != null) {
                return child2;
            }
            if (this.allChildrenLoaded()) {
                return null;
            }
            ChildInfo childInfo = ourPersistence.findChildInfo((VirtualFile)this, name, delegate);
            if (childInfo == null) {
                this.myData.addAdoptedName(name, caseSensitive);
                return null;
            }
            if (ensureCanonicalName && !Comparing.equal((CharSequence)name, (CharSequence)(persistedName = childInfo.getName())) && (child2 = this.doFindChildInArray(name = persistedName.toString(), caseSensitive)) != null) {
                return child2;
            }
            int nameId = childInfo.getNameId();
            int id2 = childInfo.getId();
            FileAttributes attributes = PersistentFS.toFileAttributes(ourPersistence.getFileAttributes(id2));
            boolean isEmptyDirectory = attributes.isDirectory() && !ourPersistence.mayHaveChildren(id2);
            child2 = this.createChild(id2, nameId, delegate, attributes, isEmptyDirectory);
            this.addChild(child2);
        }
        if (!child2.isDirectory()) {
            VfsRootAccess.assertAccessInTests(child2, this.getFileSystem());
        }
        return child2;
    }

    private <T> T handleInvalidDirectory(T empty) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return empty;
        }
        throw new InvalidVirtualFileAccessException((VirtualFile)this);
    }

    private static String deSlash(@NotNull String name) {
        int startTrimmed = -1;
        int endTrimmed = -1;
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c = name.charAt(i2);
            if (startTrimmed == -1) {
                if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
                startTrimmed = i2;
                continue;
            }
            if (endTrimmed == -1) {
                if (!VirtualDirectoryImpl.isFileSeparator(c)) continue;
                endTrimmed = i2;
                continue;
            }
            if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
            return null;
        }
        if (startTrimmed == -1) {
            return null;
        }
        if (endTrimmed == -1) {
            return name.substring(startTrimmed);
        }
        if (startTrimmed == endTrimmed) {
            return null;
        }
        return name.substring(startTrimmed, endTrimmed);
    }

    private static boolean isFileSeparator(char c) {
        return c == '/' || c == File.separatorChar;
    }

    private VirtualFileSystemEntry @NotNull [] getArraySafely(boolean putToMemoryCache) {
        return this.myData.getFileChildren(this, putToMemoryCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VirtualFileSystemEntry createChild(@NotNull String name, int id2, @NotNull NewVirtualFileSystem delegate, @NotNull FileAttributes attributes, boolean isEmptyDirectory) {
        int nameId = FileNameCache.storeName(name);
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            return this.createChild(id2, nameId, delegate, attributes, isEmptyDirectory);
        }
    }

    @NotNull
    private VirtualFileSystemEntry createChild(int id2, int nameId, @NotNull NewVirtualFileSystem delegate, @NotNull FileAttributes attributes, boolean isEmptyDirectory) {
        FileLoadingTracker.fileLoaded(this, nameId);
        VfsData.Segment segment = this.mySegment.vfsData.getSegment(id2, true);
        VfsData.initFile(id2, segment, nameId, attributes.isDirectory() ? new VfsData.DirectoryData() : KeyFMap.EMPTY_MAP);
        LOG.assertTrue(!(this.getFileSystem() instanceof Win32LocalFileSystem));
        VirtualFileSystemEntry child2 = this.mySegment.vfsData.getFileById(id2, this, true);
        assert (child2 != null);
        segment.setFlag(id2, 0x20000000, attributes.isSymLink());
        segment.setFlag(id2, Integer.MIN_VALUE, attributes.isSpecial());
        segment.setFlag(id2, 0x1000000, attributes.isWritable());
        segment.setFlag(id2, 0x2000000, attributes.isHidden());
        child2.updateLinkStatus();
        if (delegate.markNewFilesAsDirty()) {
            child2.markDirty();
        }
        if (attributes.isDirectory() && child2 instanceof VirtualDirectoryImpl && isEmptyDirectory) {
            ((VirtualDirectoryImpl)child2).setChildrenLoaded();
        }
        return child2;
    }

    @Nullable
    private VirtualFileSystemEntry createAndFindChildWithEventFire(@NotNull String name, @NotNull NewVirtualFileSystem delegate) {
        FakeVirtualFile fake = new FakeVirtualFile((VirtualFile)this, name);
        FileAttributes attributes = delegate.getAttributes((VirtualFile)fake);
        if (attributes == null) {
            return null;
        }
        String realName = delegate.getCanonicallyCasedName((VirtualFile)fake);
        boolean isDirectory = attributes.isDirectory();
        boolean isEmptyDirectory = isDirectory && !delegate.hasChildren((VirtualFile)fake);
        String symlinkTarget = attributes.isSymLink() ? delegate.resolveSymLink((VirtualFile)fake) : null;
        ChildInfo[] children2 = isEmptyDirectory ? ChildInfo.EMPTY_ARRAY : null;
        VFileCreateEvent event = new VFileCreateEvent(null, (VirtualFile)this, realName, isDirectory, attributes, symlinkTarget, true, children2);
        RefreshQueue.getInstance().processSingleEvent((VFileEvent)event);
        return this.findChild(realName);
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        return this.findChild(name, true, true, this.getFileSystem());
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VirtualFileSystemEntry found = this.doFindChildInArray(name, caseSensitive);
        return found == NULL_VIRTUAL_FILE ? null : found;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            return Collections.emptyList();
        }
        if (ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            return Arrays.asList(this.getChildren());
        }
        this.loadPersistedChildren();
        return this.getCachedChildren();
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildrenWithoutLoadingVfsFromOtherProjects() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            return Collections.emptyList();
        }
        if (!ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            this.loadPersistedChildren();
        }
        return this.getCachedChildren();
    }

    private void loadPersistedChildren() {
        String[] names2 = ourPersistence.listPersisted((VirtualFile)this);
        NewVirtualFileSystem delegate = PersistentFS.replaceWithNativeFS(this.getFileSystem());
        for (String name : names2) {
            this.findChild(name, false, false, delegate);
        }
    }

    public VirtualFile @NotNull [] getChildren() {
        if (!this.isValid()) {
            return (VirtualFile[])this.handleInvalidDirectory(EMPTY_ARRAY);
        }
        if (this.allChildrenLoaded()) {
            return this.getArraySafely(true);
        }
        return this.loadAllChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualFile @NotNull [] loadAllChildren() {
        NewVirtualFileSystem delegate = this.getFileSystem();
        boolean caseSensitive = delegate.isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            VirtualFile[] files2;
            boolean wasChildrenLoaded = ourPersistence.areChildrenLoaded((VirtualFile)this);
            List<? extends ChildInfo> children2 = ourPersistence.listAll((VirtualFile)this);
            int[] result2 = ArrayUtil.newIntArray((int)children2.size());
            if (children2.isEmpty()) {
                files2 = VirtualFile.EMPTY_ARRAY;
            } else {
                files2 = new VirtualFile[children2.size()];
                int[] errorsCount = new int[]{0};
                children2.sort((o1, o2) -> {
                    CharSequence name2;
                    CharSequence name1 = o1.getName();
                    int cmp = VirtualDirectoryImpl.compareNames(name1, name2 = o2.getName(), caseSensitive);
                    if (cmp == 0 && name1 != name2 && errorsCount[0] < 10) {
                        LOG.error((Object)((Object)ourPersistence) + " returned duplicate file names(" + name1 + "," + name2 + ") caseSensitive: " + caseSensitive + " SystemInfo.isFileSystemCaseSensitive: " + SystemInfo.isFileSystemCaseSensitive + " SystemInfo.OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " wasChildrenLoaded: " + wasChildrenLoaded + " in the dir: " + (Object)((Object)this) + "; children: " + StringUtil.first((String)children2.toString(), (int)300, (boolean)true));
                        errorsCount[0] = errorsCount[0] + 1;
                        if (!caseSensitive) {
                            cmp = VirtualDirectoryImpl.compareNames(name1, name2, true);
                        }
                    }
                    return cmp;
                });
                TIntHashSet prevChildren = new TIntHashSet(this.myData.myChildrenIds);
                for (int i2 = 0; i2 < children2.size(); ++i2) {
                    ChildInfo child2 = children2.get(i2);
                    int id2 = child2.getId();
                    assert (id2 > 0) : child2;
                    result2[i2] = id2;
                    prevChildren.remove(id2);
                    VirtualFileSystemEntry file2 = this.mySegment.vfsData.getFileById(id2, this, true);
                    if (file2 == null) {
                        FileAttributes attributes = PersistentFS.toFileAttributes(ourPersistence.getFileAttributes(id2));
                        boolean isEmptyDirectory = attributes.isDirectory() && !ourPersistence.mayHaveChildren(id2);
                        file2 = this.createChild(id2, child2.getNameId(), delegate, attributes, isEmptyDirectory);
                    }
                    files2[i2] = file2;
                }
                if (!prevChildren.isEmpty()) {
                    LOG.error("Loaded child disappeared: parent=" + VirtualDirectoryImpl.verboseToString(this) + "; child=" + VirtualDirectoryImpl.verboseToString(this.mySegment.vfsData.getFileById(prevChildren.toArray()[0], this, true)));
                }
            }
            this.myData.clearAdoptedNames();
            this.myData.myChildrenIds = result2;
            this.setChildrenLoaded();
            if (CHECK) {
                this.assertConsistency(caseSensitive, children2);
            }
            return files2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertConsistency(boolean caseSensitive, @NotNull Object details) {
        if (!CHECK || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        int[] childrenIds = this.myData.myChildrenIds;
        if (childrenIds.length == 0) {
            return;
        }
        CharSequence prevName = this.mySegment.vfsData.getNameByFileId(childrenIds[0]);
        for (int i2 = 1; i2 < childrenIds.length; ++i2) {
            int id2 = childrenIds[i2];
            int prev = childrenIds[i2 - 1];
            CharSequence name = this.mySegment.vfsData.getNameByFileId(id2);
            int cmp = VirtualDirectoryImpl.compareNames(name, prevName, caseSensitive);
            prevName = name;
            if (cmp <= 0) {
                VirtualDirectoryImpl.error(VirtualDirectoryImpl.verboseToString(this.mySegment.vfsData.getFileById(prev, this, true)) + " is wrongly placed before " + VirtualDirectoryImpl.verboseToString(this.mySegment.vfsData.getFileById(id2, this, true)), this.getArraySafely(true), details);
            }
            VfsData.DirectoryData directoryData = this.myData;
            synchronized (directoryData) {
                if (this.myData.isAdoptedName(name)) {
                    try {
                        VirtualDirectoryImpl.error("In " + VirtualDirectoryImpl.verboseToString(this) + " file '" + name + "' is both child and adopted", this.getArraySafely(true), "Adopted: " + this.myData.getAdoptedNames() + ";\n " + details);
                    }
                    finally {
                        this.myData.removeAdoptedName(name);
                    }
                }
                continue;
            }
        }
    }

    @NotNull
    private static String verboseToString(VirtualFileSystemEntry file2) {
        if (file2 == null) {
            return "null";
        }
        return (Object)((Object)file2) + " (name: '" + file2.getName() + "', " + ((Object)((Object)file2)).getClass() + ", parent: " + (Object)((Object)file2.getParent()) + "; id: " + file2.getId() + "; FS: " + file2.getFileSystem() + "; delegate.attrs: " + file2.getFileSystem().getAttributes((VirtualFile)file2) + "; caseSensitive: " + file2.getFileSystem().isCaseSensitive() + "; canonical: " + file2.getFileSystem().getCanonicallyCasedName((VirtualFile)file2) + ") ";
    }

    private static void error(@NonNls String message, VirtualFileSystemEntry[] array2, Object ... details) {
        String children2 = StringUtil.join((Object[])array2, VirtualDirectoryImpl::verboseToString, (String)"\n");
        String detailsStr = StringUtil.join((Iterable)ContainerUtil.map((Object[])details, o -> o instanceof Object[] ? Arrays.toString((Object[])o) : o), (String)"\n");
        throw new AssertionError((Object)(message + "; children: " + children2 + "\nDetails: " + detailsStr));
    }

    @Nullable
    public VirtualFileSystemEntry findChild(@NotNull String name) {
        return this.findChild(name, false, true, this.getFileSystem());
    }

    public VirtualFileSystemEntry doFindChildById(int id2) {
        int i2 = ArrayUtil.indexOf((int[])this.myData.myChildrenIds, (int)id2);
        if (i2 >= 0) {
            return this.mySegment.vfsData.getFileById(id2, this, true);
        }
        String name = ourPersistence.getName(id2);
        return this.findChild(name, false, false, this.getFileSystem());
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of directory: " + (Object)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndAddChildren(@NotNull List<? extends ChildInfo> added, boolean markAllChildrenLoaded, @NotNull PairConsumer<? super VirtualFile, ? super ChildInfo> fileCreated) {
        if (added.size() <= 1) {
            for (int i2 = 0; i2 < added.size(); ++i2) {
                ChildInfo info = added.get(i2);
                assert (info.getId() > 0) : info;
                FileAttributes attributes = info.getFileAttributes();
                boolean isEmptyDirectory = info.getChildren() != null && info.getChildren().length == 0;
                VfsData.DirectoryData directoryData = this.myData;
                synchronized (directoryData) {
                    int[] oldIds = this.myData.myChildrenIds;
                    if (ArrayUtil.indexOf((int[])oldIds, (int)info.getId()) < 0) {
                        VirtualFileSystemEntry file2 = this.createChild(info.getId(), info.getNameId(), this.getFileSystem(), attributes, isEmptyDirectory);
                        this.addChild(file2);
                        fileCreated.consume((Object)file2, (Object)info);
                    }
                    continue;
                }
            }
            if (markAllChildrenLoaded) {
                this.setChildrenLoaded();
            }
            return;
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        Comparator pairComparator = (p1, p2) -> VirtualDirectoryImpl.compareNames(p1.getName(), p2.getName(), caseSensitive);
        added.sort(pairComparator);
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            final int[] oldIds = this.myData.myChildrenIds;
            TIntArrayList mergedIds = new TIntArrayList(oldIds.length + added.size());
            for (int i3 = 0; i3 < added.size(); ++i3) {
                ChildInfo info = added.get(i3);
                assert (info.getId() > 0) : info;
                FileAttributes attributes = info.getFileAttributes();
                boolean isEmptyDirectory = info.getChildren() != null && info.getChildren().length == 0;
                this.myData.removeAdoptedName(info.getName());
                VirtualFileSystemEntry file3 = this.createChild(info.getId(), info.getNameId(), this.getFileSystem(), attributes, isEmptyDirectory);
                fileCreated.consume((Object)file3, (Object)info);
            }
            AbstractList<ChildInfo> existingChildren = new AbstractList<ChildInfo>(){

                @Override
                public ChildInfo get(int index) {
                    int id2 = oldIds[index];
                    assert (id2 > 0) : id2;
                    int nameId = VirtualDirectoryImpl.this.mySegment.vfsData.getNameId(id2);
                    return new ChildInfoImpl(id2, nameId, null, null, null);
                }

                @Override
                public int size() {
                    return oldIds.length;
                }
            };
            ContainerUtil.processSortedListsInOrder(added, (List)existingChildren, (Comparator)pairComparator, (boolean)true, (nextInfo, __) -> mergedIds.add(nextInfo.getId()));
            this.myData.myChildrenIds = mergedIds.toNativeArray();
            if (markAllChildrenLoaded) {
                this.setChildrenLoaded();
            }
            this.assertConsistency(caseSensitive, added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull VirtualFileSystemEntry child2) {
        CharSequence childName = child2.getNameSequence();
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            this.myData.removeAdoptedName(childName);
            int indexInReal = this.findIndex(this.myData.myChildrenIds, childName, caseSensitive);
            if (indexInReal < 0) {
                this.insertChildAt(child2, indexInReal);
            }
            this.assertConsistency(caseSensitive, (Object)child2);
        }
    }

    private void insertChildAt(@NotNull VirtualFileSystemEntry file2, int negativeIndex) {
        int i2 = -negativeIndex - 1;
        int id2 = file2.getId();
        assert (id2 > 0) : (Object)((Object)file2) + ": " + id2;
        this.myData.myChildrenIds = ArrayUtil.insert((int[])this.myData.myChildrenIds, (int)i2, (int)id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull VirtualFile file2) {
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        String name = file2.getName();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int indexInReal = this.findIndex(this.myData.myChildrenIds, name, caseSensitive);
            if (indexInReal >= 0) {
                this.myData.myChildrenIds = ArrayUtil.remove((int[])this.myData.myChildrenIds, (int)indexInReal);
            }
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedName(name, caseSensitive);
            }
            this.assertConsistency(caseSensitive, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren(@NotNull IntSet idsToRemove, @NotNull List<? extends CharSequence> namesToRemove) {
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int[] newIds = new int[this.myData.myChildrenIds.length];
            int[] oldIds = this.myData.myChildrenIds;
            int o = 0;
            for (int oldId : oldIds) {
                if (idsToRemove.contains(oldId)) continue;
                assert (oldId > 0) : Arrays.toString(oldIds);
                newIds[o++] = oldId;
            }
            if (o != newIds.length) {
                newIds = o == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : Arrays.copyOf(newIds, o);
            }
            this.myData.myChildrenIds = newIds;
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedNames(namesToRemove, caseSensitive);
            }
            this.assertConsistency(caseSensitive, namesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateChildrenToCreate(@NotNull List<? extends VFileCreateEvent> childrenToCreate) {
        if (childrenToCreate.size() <= 1) {
            for (int i2 = childrenToCreate.size() - 1; i2 >= 0; --i2) {
                VFileCreateEvent event = childrenToCreate.get(i2);
                if (event.isValid()) continue;
                childrenToCreate.remove(i2);
            }
            return;
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        CharSequenceHashingStrategy strategy = caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE;
        THashSet existingNames = new THashSet(this.myData.myChildrenIds.length, (TObjectHashingStrategy)strategy);
        for (int id2 : this.myData.myChildrenIds) {
            existingNames.add(this.mySegment.vfsData.getNameByFileId(id2));
        }
        int id3 = this.getId();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            existingNames.addAll(FSRecords.listNames(id3));
            this.validateAgainst(childrenToCreate, (Set<CharSequence>)existingNames);
            if (!childrenToCreate.isEmpty() && !this.allChildrenLoaded()) {
                int beforeSize = existingNames.size();
                String[] names2 = this.getFileSystem().list((VirtualFile)this);
                existingNames.addAll(Arrays.asList(names2));
                if (beforeSize != existingNames.size()) {
                    this.validateAgainst(childrenToCreate, (Set<CharSequence>)existingNames);
                }
            }
        }
    }

    private void validateAgainst(@NotNull List<? extends VFileCreateEvent> childrenToCreate, @NotNull Set<CharSequence> existingNames) {
        for (int i2 = childrenToCreate.size() - 1; i2 >= 0; --i2) {
            boolean childExists;
            VFileCreateEvent event = childrenToCreate.get(i2);
            String childName = event.getChildName();
            boolean bl = childExists = !this.myData.isAdoptedName(childName) && existingNames.contains(childName);
            if (!childExists) continue;
            childrenToCreate.remove(i2);
        }
    }

    public boolean allChildrenLoaded() {
        return this.getFlagInt(0x8000000);
    }

    private void setChildrenLoaded() {
        this.setFlagInt(0x8000000, true);
    }

    @NotNull
    public List<String> getSuspiciousNames() {
        return this.myData.getAdoptedNames();
    }

    private int findIndex(int @NotNull [] ids, @NotNull CharSequence name, boolean caseSensitive) {
        return ObjectUtils.binarySearch((int)0, (int)ids.length, mid -> VirtualDirectoryImpl.compareNames(this.mySegment.vfsData.getNameByFileId(ids[mid]), name, caseSensitive));
    }

    private static int compareNames(@NotNull CharSequence name1, @NotNull CharSequence name2, boolean caseSensitive) {
        int d = name1.length() - name2.length();
        if (d != 0) {
            return d;
        }
        for (int i2 = 0; i2 < name1.length(); ++i2) {
            d = StringUtil.compare((char)name1.charAt(i2), (char)name2.charAt(i2), (!caseSensitive ? 1 : 0) != 0);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public List<VirtualFile> getCachedChildren() {
        return Arrays.asList(this.getArraySafely(false));
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException("getInputStream() must not be called against a directory: " + this.getUrl());
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException("getOutputStream() must not be called against a directory: " + this.getUrl());
    }

    @Override
    public void markDirtyRecursively() {
        this.markDirty();
        this.markDirtyRecursivelyInternal();
    }

    private void markDirtyRecursivelyInternal() {
        for (VirtualFileSystemEntry child2 : this.getArraySafely(true)) {
            child2.markDirtyInternal();
            if (!(child2 instanceof VirtualDirectoryImpl)) continue;
            ((VirtualDirectoryImpl)child2).markDirtyRecursivelyInternal();
        }
    }

    protected void setUserMap(@NotNull KeyFMap map2) {
        this.myData.myUserMap = map2;
    }

    @NotNull
    protected KeyFMap getUserMap() {
        return this.myData.myUserMap;
    }

    protected boolean changeUserMap(@NotNull KeyFMap oldMap, @NotNull KeyFMap newMap) {
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.myData.changeUserMap(oldMap, UserDataInterner.internUserData(newMap));
    }

    static void checkLeaks(@NotNull KeyFMap newMap) {
        for (Key key : newMap.getKeys()) {
            if (key != null && newMap.get(key) instanceof PsiCachedValue) {
                throw new AssertionError((Object)"Don't store CachedValue in VFS user data, since it leads to memory leaks");
            }
        }
    }
}

