/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.util.containers.WeakInterner;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FilePathInterner
extends WeakInterner<CharSequence> {
    @NotNull
    public CharSequence intern(@NotNull CharSequence path) {
        List names2 = StringUtil.split((String)path.toString(), (String)"/");
        int[] nameIds = names2.stream().mapToInt(name -> FileNameCache.storeName(name)).toArray();
        return nameIds.length == 0 ? "" : (CharSequence)super.intern((Object)new FileSeparatedCharSequence(nameIds));
    }

    private static class FileSeparatedCharSequence
    implements CharSequenceWithStringHash {
        private final int[] nameIds;
        private transient int hash;

        private FileSeparatedCharSequence(int @NotNull [] nameIds) {
            this.nameIds = nameIds;
        }

        public int length() {
            int length = 0;
            for (int nameId : this.nameIds) {
                CharSequence name = FileNameCache.getVFileName(nameId);
                length += name.length();
            }
            return length + this.nameIds.length - 1;
        }

        public char charAt(int index) {
            for (int n = 0; n < this.nameIds.length; ++n) {
                int nameId;
                CharSequence name;
                if (n > 0) {
                    if (index == 0) {
                        return '/';
                    }
                    --index;
                }
                if (index < (name = FileNameCache.getVFileName(nameId = this.nameIds[n])).length()) {
                    return name.charAt(index);
                }
                index -= name.length();
            }
            throw new IndexOutOfBoundsException();
        }

        public CharSequence subSequence(int start2, int end) {
            return this.toString().substring(start2, end);
        }

        @NotNull
        public String toString() {
            StringBuilder b = new StringBuilder(this.length() + this.nameIds.length - 1);
            for (int n = 0; n < this.nameIds.length; ++n) {
                if (n > 0 || !SystemInfo.isWindows) {
                    b.append('/');
                }
                int nameId = this.nameIds[n];
                CharSequence name = FileNameCache.getVFileName(nameId);
                b.append(name);
            }
            return b.toString();
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                for (int n = 0; n < this.nameIds.length; ++n) {
                    if (n > 0 || !SystemInfo.isWindows) {
                        h = h * 31 + 47;
                    }
                    int nameId = this.nameIds[n];
                    CharSequence name = FileNameCache.getVFileName(nameId);
                    for (int i2 = 0; i2 < name.length(); ++i2) {
                        char c = name.charAt(i2);
                        h = h * 31 + c;
                    }
                }
                this.hash = h;
                return h;
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FileSeparatedCharSequence)) {
                return false;
            }
            FileSeparatedCharSequence other = (FileSeparatedCharSequence)obj;
            return Arrays.equals(this.nameIds, other.nameIds);
        }
    }
}

