/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.IntSLRUCache;
import com.intellij.util.containers.IntObjectLinkedMap;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class FileNameCache {
    private static final IntSLRUCache<CharSequence>[] ourNameCache = new IntSLRUCache[16];
    private static final String FS_SEPARATORS;
    private static final boolean ourTrackStats = false;
    private static final int ourLOneSize = 1024;
    private static final IntObjectLinkedMap.MapEntry<CharSequence>[] ourArrayCache;
    private static final AtomicInteger ourQueries;
    private static final AtomicInteger ourMisses;

    public static int storeName(@NotNull String name) {
        FileNameCache.assertShortFileName(name);
        int idx = FSRecords.getNameId(name);
        FileNameCache.cacheData(name, idx, FileNameCache.calcStripeIdFromNameId(idx));
        return idx;
    }

    private static void assertShortFileName(@NotNull String name) {
        if (name.length() <= 1) {
            return;
        }
        int start2 = 0;
        if (SystemInfo.isWindows && name.startsWith("//")) {
            int idx = name.indexOf(47, 2);
            int n = start2 = idx == -1 ? 2 : idx + 1;
        }
        if (StringUtil.containsAnyChar((String)name, (String)FS_SEPARATORS, (int)start2, (int)name.length())) {
            throw new IllegalArgumentException("Must not intern long path: '" + name + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static IntObjectLinkedMap.MapEntry<CharSequence> cacheData(String name, int id2, int stripe) {
        IntSLRUCache<CharSequence> cache;
        if (name == null) {
            FSRecords.handleError(new RuntimeException("VFS name enumerator corrupted"));
        }
        CharSequence rawName = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)name);
        IntSLRUCache<CharSequence> intSLRUCache = cache = ourNameCache[stripe];
        synchronized (intSLRUCache) {
            return cache.cacheEntry(id2, rawName);
        }
    }

    private static int calcStripeIdFromNameId(int id2) {
        int h = id2;
        h -= h << 6;
        h ^= h >> 17;
        h -= h << 9;
        h ^= h << 4;
        h -= h << 3;
        h ^= h << 10;
        h ^= h >> 15;
        return h % ourNameCache.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static CharSequence getVFileName(int nameId, @NotNull NameComputer computeName) throws IOException {
        IntSLRUCache<CharSequence> cache;
        assert (nameId > 0) : nameId;
        int l1 = nameId % 1024;
        IntObjectLinkedMap.MapEntry<CharSequence> entry = ourArrayCache[l1];
        if (entry != null && entry.key == nameId) {
            return (CharSequence)entry.value;
        }
        int stripe = FileNameCache.calcStripeIdFromNameId(nameId);
        IntSLRUCache<CharSequence> intSLRUCache = cache = ourNameCache[stripe];
        synchronized (intSLRUCache) {
            entry = cache.getCachedEntry(nameId);
        }
        if (entry == null) {
            entry = FileNameCache.cacheData(computeName.compute(nameId), nameId, stripe);
        }
        FileNameCache.ourArrayCache[l1] = entry;
        return (CharSequence)entry.value;
    }

    @NotNull
    public static CharSequence getVFileName(int nameId) {
        try {
            return FileNameCache.getVFileName(nameId, FSRecords::getNameByNameId);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        int protectedSize = 40000 / ourNameCache.length;
        int probationalSize = 20000 / ourNameCache.length;
        for (int i2 = 0; i2 < ourNameCache.length; ++i2) {
            FileNameCache.ourNameCache[i2] = new IntSLRUCache(protectedSize, probationalSize);
        }
        FS_SEPARATORS = "/" + (File.separatorChar == '/' ? "" : Character.valueOf(File.separatorChar));
        ourArrayCache = new IntObjectLinkedMap.MapEntry[1024];
        ourQueries = new AtomicInteger();
        ourMisses = new AtomicInteger();
    }

    @FunctionalInterface
    public static interface NameComputer {
        public String compute(int var1) throws IOException;
    }
}

