/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class FileLoadingTracker {
    private static final Logger LOG = Logger.getInstance(FileLoadingTracker.class);
    private static final Set<String> ourPaths = new THashSet(FileLoadingTracker.getPathsToTrack(), FilePathHashingStrategy.create());
    private static final TIntHashSet ourLeafNameIds = new TIntHashSet(ourPaths.stream().mapToInt(path -> FileNameCache.storeName(StringUtil.getShortName((String)path, (char)'/'))).toArray());

    FileLoadingTracker() {
    }

    @NotNull
    private static List<String> getPathsToTrack() {
        try {
            return StringUtil.split((String)Registry.stringValue((String)"file.system.trace.loading"), (String)";");
        }
        catch (MissingResourceException e) {
            return Collections.emptyList();
        }
    }

    static void fileLoaded(@NotNull VirtualDirectoryImpl parent, int nameId) {
        String path;
        if (ourLeafNameIds.contains(nameId) && ourPaths.contains(path = parent.getPath() + "/" + FileNameCache.getVFileName(nameId).toString())) {
            LOG.info("Loading " + path, new Throwable());
        }
    }
}

