/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;

final class RefreshProgress
extends ProgressIndicatorBase {
    private final String myMessage;
    private long myStartedTime;

    @NotNull
    public static ProgressIndicator create(@NotNull String message) {
        Application app = LoadingState.COMPONENTS_LOADED.isOccurred() ? ApplicationManager.getApplication() : null;
        return app == null || app.isUnitTestMode() ? new EmptyProgressIndicator() : new RefreshProgress(message);
    }

    private RefreshProgress(@NotNull String message) {
        super(true);
        this.myMessage = message;
    }

    @Override
    public void start() {
        super.start();
        this.scheduleUiUpdate();
        this.myStartedTime = System.currentTimeMillis();
    }

    @Override
    public void stop() {
        super.stop();
        this.scheduleUiUpdate();
        long finishedTime = System.currentTimeMillis();
        long duration = finishedTime - this.myStartedTime;
        if (duration > 1000L) {
            Application application = ApplicationManager.getApplication();
            application.runReadAction(() -> {
                if (application.isDisposed()) {
                    return;
                }
                FUCounterUsageLogger.getInstance().logEvent("vfs", "refreshed", new FeatureUsageData().addData("start_time_ms", this.myStartedTime).addData("finish_time_ms", finishedTime).addData("duration_ms", duration));
            });
        }
    }

    private void scheduleUiUpdate() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (ApplicationManager.getApplication().isDisposed()) {
                return;
            }
            Project[] projects = ProjectUtil.getOpenProjects();
            if (projects.length == 0) {
                return;
            }
            WindowManager windowManager = WindowManager.getInstance();
            if (windowManager == null) {
                return;
            }
            for (Project project : projects) {
                StatusBarEx statusBar = (StatusBarEx)windowManager.getStatusBar(project);
                if (statusBar == null) continue;
                if (this.isRunning()) {
                    statusBar.startRefreshIndication(this.myMessage);
                    continue;
                }
                statusBar.stopRefreshIndication();
            }
        });
    }
}

