/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AsyncEventSupport {
    private static final Logger LOG = Logger.getInstance(AsyncEventSupport.class);
    @ApiStatus.Internal
    public static final ExtensionPointName<AsyncFileListener> EP_NAME = ExtensionPointName.create((String)"com.intellij.vfs.asyncListener");
    private static boolean ourSuppressAppliers;

    public static void startListening() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            Pair<List<? extends VFileEvent>, List<AsyncFileListener.ChangeApplier>> appliersFromBefore;

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (ourSuppressAppliers) {
                    return;
                }
                List<AsyncFileListener.ChangeApplier> appliers = AsyncEventSupport.runAsyncListeners(events);
                this.appliersFromBefore = Pair.create(events, appliers);
                AsyncEventSupport.beforeVfsChange(appliers);
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (ourSuppressAppliers) {
                    return;
                }
                List appliers = this.appliersFromBefore != null && ((List)this.appliersFromBefore.first).equals(events) ? (List)this.appliersFromBefore.second : AsyncEventSupport.runAsyncListeners(events);
                this.appliersFromBefore = null;
                AsyncEventSupport.afterVfsChange(appliers);
            }
        });
    }

    /*
     * Exception decompiling
     */
    @NotNull
    static List<AsyncFileListener.ChangeApplier> runAsyncListeners(@NotNull List<? extends VFileEvent> events) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void beforeVfsChange(List<? extends AsyncFileListener.ChangeApplier> appliers) {
        for (AsyncFileListener.ChangeApplier changeApplier : appliers) {
            PingProgress.interactWithEdtProgress();
            try {
                changeApplier.beforeVfsChange();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private static void afterVfsChange(@NotNull List<? extends AsyncFileListener.ChangeApplier> appliers) {
        for (AsyncFileListener.ChangeApplier changeApplier : appliers) {
            PingProgress.interactWithEdtProgress();
            try {
                changeApplier.afterVfsChange();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    static void processEventsFromRefresh(@NotNull List<? extends VFileEvent> events, @Nullable List<? extends AsyncFileListener.ChangeApplier> appliers) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (appliers != null) {
            AsyncEventSupport.beforeVfsChange(appliers);
            ourSuppressAppliers = true;
        }
        try {
            PersistentFS.getInstance().processEvents(events);
        }
        finally {
            ourSuppressAppliers = false;
        }
        if (appliers != null) {
            AsyncEventSupport.afterVfsChange(appliers);
        }
    }

    private static /* synthetic */ void lambda$runAsyncListeners$0(List appliers, AsyncFileListener listener2, List events) throws RuntimeException {
        ContainerUtil.addIfNotNull((Collection)appliers, (Object)listener2.prepareChange(events));
    }
}

