/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.core.CoreBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.local.DirectoryAccessChecker;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PreemptiveSafeFileOutputStream;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystemBase
extends LocalFileSystem {
    protected static final Logger LOG = Logger.getInstance(LocalFileSystemBase.class);
    private static final FileAttributes FAKE_ROOT_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, 0L, false);
    private final List<LocalFileOperationsHandler> myHandlers = new ArrayList<LocalFileOperationsHandler>();
    private static final String[] ourRootPaths;
    private final DiskQueryRelay<String, FileAttributes> myAttrGetter = new DiskQueryRelay<String, FileAttributes>(FileSystemUtil::getAttributes);
    private final DiskQueryRelay<File, String[]> myChildrenGetter = new DiskQueryRelay<File, String[]>(dir -> dir.list(DirectoryAccessChecker.getFileFilter(dir)));

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByIoFile(@NotNull File file2) {
        return this.findFileByPath(FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()));
    }

    public VirtualFile refreshAndFindFileByIoFile(@NotNull File file2) {
        return this.refreshAndFindFileByPath(file2.getAbsolutePath().replace(File.separatorChar, '/'));
    }

    @NotNull
    private static String toIoPath(@NotNull VirtualFile file2) {
        String path = file2.getPath();
        if (StringUtil.endsWithChar((CharSequence)path, (char)':') && path.length() == 2 && SystemInfo.isWindows) {
            path = path + '/';
        }
        return path;
    }

    @NotNull
    private static File convertToIOFile(@NotNull VirtualFile file2) {
        return new File(LocalFileSystemBase.toIoPath(file2));
    }

    @Nullable
    public Path getNioPath(@NotNull VirtualFile file2) {
        return file2.getFileSystem() == this ? Paths.get(LocalFileSystemBase.toIoPath(file2), new String[0]) : null;
    }

    @NotNull
    private static File convertToIOFileAndCheck(@NotNull VirtualFile file2) throws FileNotFoundException {
        FileAttributes attributes;
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (SystemInfo.isUnix && (attributes = FileSystemUtil.getAttributes((File)ioFile)) != null && !attributes.isFile()) {
            throw new FileNotFoundException("Not a file: " + ioFile + " (type=" + attributes.type + ')');
        }
        return ioFile;
    }

    public boolean exists(@NotNull VirtualFile file2) {
        return this.getAttributes(file2) != null;
    }

    public long getLength(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null ? attributes.length : 0L;
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null ? attributes.lastModified : 0L;
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null && attributes.isDirectory();
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null && attributes.isWritable();
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        FileAttributes attributes = this.getAttributes(file2);
        return attributes != null && attributes.isSymLink();
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        String result2 = FileSystemUtil.resolveSymLink((String)file2.getPath());
        return result2 != null ? FileUtil.toSystemIndependentName((String)result2) : null;
    }

    public String @NotNull [] list(@NotNull VirtualFile file2) {
        String[] names2 = this.myChildrenGetter.accessDiskWithCheckCanceled(LocalFileSystemBase.convertToIOFile(file2));
        return names2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : names2;
    }

    @NotNull
    public String getProtocol() {
        return "file";
    }

    public boolean isReadOnly() {
        return false;
    }

    @Nullable
    protected String normalize(@NotNull String path) {
        if (SystemInfo.isWindows) {
            if (path.length() > 1 && path.charAt(0) == '/' && path.charAt(1) != '/') {
                path = path.substring(1);
            }
            try {
                path = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException e) {
                return null;
            }
        }
        try {
            Path file2 = Paths.get(path, new String[0]);
            if (!(file2.isAbsolute() || SystemInfo.isWindows && path.length() == 2 && path.charAt(1) == ':')) {
                path = file2.toAbsolutePath().toString();
            }
        }
        catch (IOError | InvalidPathException e) {
            Logger.getInstance(((Object)((Object)this)).getClass()).trace(e);
            return null;
        }
        return FileUtil.normalize((String)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIoFiles(@NotNull Iterable<? extends File> files2, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        boolean fireCommonRefreshSession;
        VirtualFileManagerEx manager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        Application app = ApplicationManager.getApplication();
        boolean bl = fireCommonRefreshSession = app.isDispatchThread() || app.isWriteAccessAllowed();
        if (fireCommonRefreshSession) {
            manager.fireBeforeRefreshStart(false);
        }
        try {
            ArrayList<VirtualFile> filesToRefresh = new ArrayList<VirtualFile>();
            for (File file2 : files2) {
                VirtualFile virtualFile = this.refreshAndFindFileByIoFile(file2);
                if (virtualFile == null) continue;
                filesToRefresh.add(virtualFile);
            }
            RefreshQueue.getInstance().refresh(async, recursive, onFinish, filesToRefresh);
        }
        finally {
            if (fireCommonRefreshSession) {
                manager.fireAfterRefreshFinish(false);
            }
        }
    }

    public void refreshFiles(@NotNull Iterable<? extends VirtualFile> files2, boolean async, boolean recursive, @Nullable Runnable onFinish) {
        RefreshQueue.getInstance().refresh(async, recursive, onFinish, ContainerUtil.toCollection(files2));
    }

    public void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (this.myHandlers.contains(handler2)) {
            LOG.error("Handler " + handler2 + " already registered.");
        }
        this.myHandlers.add(handler2);
    }

    public void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler handler2) {
        if (!this.myHandlers.remove(handler2)) {
            LOG.error("Handler " + handler2 + " haven't been registered or already unregistered.");
        }
    }

    private boolean auxDelete(@NotNull VirtualFile file2) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.delete(file2)) continue;
            return true;
        }
        return false;
    }

    private boolean auxMove(@NotNull VirtualFile file2, @NotNull VirtualFile toDir) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.move(file2, toDir)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCopy(@NotNull VirtualFile file2, @NotNull VirtualFile toDir, @NotNull String copyName) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            File copy2 = handler2.copy(file2, toDir, copyName);
            if (copy2 == null) continue;
            return true;
        }
        return false;
    }

    private boolean auxRename(@NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.rename(file2, newName)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateFile(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createFile(dir, name)) continue;
            return true;
        }
        return false;
    }

    private boolean auxCreateDirectory(@NotNull VirtualFile dir, @NotNull String name) throws IOException {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            if (!handler2.createDirectory(dir, name)) continue;
            return true;
        }
        return false;
    }

    private void auxNotifyCompleted(@NotNull ThrowableConsumer<LocalFileOperationsHandler, IOException> consumer) {
        for (LocalFileOperationsHandler handler2 : this.myHandlers) {
            handler2.afterDone(consumer);
        }
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        File ioDir;
        if (!this.isValidName(dir)) {
            throw new IOException(CoreBundle.message((String)"directory.invalid.name.error", (Object[])new Object[]{dir}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(IdeBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(dir) != null) {
            throw new IOException(IdeBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + dir}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(IdeBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!(this.auxCreateDirectory(parent, dir) || (ioDir = new File(ioParent, dir)).mkdirs() || ioDir.isDirectory())) {
            throw new IOException(IdeBundle.message((String)"new.directory.failed.error", (Object[])new Object[]{ioDir.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.createDirectory(parent, dir)));
        return new FakeVirtualFile(parent, dir);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        File ioFile;
        if (!this.isValidName(file2)) {
            throw new IOException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{file2}));
        }
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IOException(IdeBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{parent.getPath()}));
        }
        if (parent.findChild(file2) != null) {
            throw new IOException(IdeBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + file2}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(parent);
        if (!ioParent.isDirectory()) {
            throw new IOException(IdeBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        if (!this.auxCreateFile(parent, file2) && !FileUtil.createIfDoesntExist((File)(ioFile = new File(ioParent, file2)))) {
            throw new IOException(IdeBundle.message((String)"new.file.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.createFile(parent, file2)));
        return new FakeVirtualFile(parent, file2);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        File ioFile;
        if (file2.getParent() == null) {
            throw new IOException(IdeBundle.message((String)"cannot.delete.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!this.auxDelete(file2) && !FileUtil.delete((File)(ioFile = LocalFileSystemBase.convertToIOFile(file2)))) {
            throw new IOException(IdeBundle.message((String)"delete.failed.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.delete(file2)));
    }

    public boolean isCaseSensitive() {
        return SystemInfo.isFileSystemCaseSensitive;
    }

    public boolean isValidName(@NotNull String name) {
        return PathUtilRt.isValidFileName((String)name, (boolean)false);
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        return new BufferedInputStream(new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2)));
    }

    public byte @NotNull [] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        try (FileInputStream stream = new FileInputStream(LocalFileSystemBase.convertToIOFileAndCheck(file2));){
            long l = file2.getLength();
            if (l >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                throw new FileTooBigException(file2.getPath());
            }
            int length = (int)l;
            if (length < 0) {
                throw new IOException("Invalid file length: " + length + ", " + file2);
            }
            byte[] byArray = LocalFileSystemBase.loadBytes(length <= 8192 ? stream : new BufferedInputStream(stream), length);
            return byArray;
        }
    }

    private static byte @NotNull [] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int count;
        int n;
        byte[] bytes = new byte[length];
        for (count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (count < length) {
            return Arrays.copyOf(bytes, count);
        }
        return bytes;
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file2, Object requestor, long modStamp, final long timeStamp) throws IOException {
        final File ioFile = LocalFileSystemBase.convertToIOFileAndCheck(file2);
        FileOutputStream stream = !SafeWriteRequestor.shouldUseSafeWrite((Object)requestor) ? new FileOutputStream(ioFile) : (Registry.is((String)"ide.io.preemptive.safe.write") ? new PreemptiveSafeFileOutputStream(ioFile.toPath()) : new SafeFileOutputStream(ioFile));
        return new BufferedOutputStream(stream){

            @Override
            public void close() throws IOException {
                super.close();
                if (timeStamp > 0L && ioFile.exists() && !ioFile.setLastModified(timeStamp)) {
                    LOG.warn("Failed: " + ioFile.getPath() + ", new:" + timeStamp + ", old:" + ioFile.lastModified());
                }
            }
        };
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        String name = file2.getName();
        if (!file2.exists()) {
            throw new IOException(IdeBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (file2.getParent() == null) {
            throw new IOException(CoreBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(IdeBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(name) != null) {
            throw new IOException(IdeBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + name}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (FileSystemUtil.getAttributes((File)ioFile) == null) {
            throw new FileNotFoundException(IdeBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(IdeBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, name);
        if (ioTarget.exists()) {
            throw new IOException(IdeBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxMove(file2, newParent) && !ioFile.renameTo(ioTarget)) {
            throw new IOException(IdeBundle.message((String)"move.failed.error", (Object[])new Object[]{ioFile.getPath(), ioParent.getPath()}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.move(file2, newParent)));
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        boolean sameName;
        if (!this.isValidName(newName)) {
            throw new IOException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        boolean bl = sameName = !this.isCaseSensitive() && newName.equalsIgnoreCase(file2.getName());
        if (!file2.exists()) {
            throw new IOException(IdeBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        VirtualFile parent = file2.getParent();
        if (parent == null) {
            throw new IOException(CoreBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[]{file2.getPath()}));
        }
        if (!sameName && parent.findChild(newName) != null) {
            throw new IOException(IdeBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{parent.getPath() + "/" + newName}));
        }
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (!ioFile.exists()) {
            throw new FileNotFoundException(IdeBundle.message((String)"file.not.exist.error", (Object[])new Object[]{ioFile.getPath()}));
        }
        File ioTarget = new File(LocalFileSystemBase.convertToIOFile(parent), newName);
        if (!sameName && ioTarget.exists()) {
            throw new IOException(IdeBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxRename(file2, newName) && !FileUtil.rename((File)ioFile, (String)newName)) {
            throw new IOException(IdeBundle.message((String)"rename.failed.error", (Object[])new Object[]{ioFile.getPath(), newName}));
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.rename(file2, newName)));
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (!this.isValidName(copyName)) {
            throw new IOException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{copyName}));
        }
        if (!file2.exists()) {
            throw new IOException(IdeBundle.message((String)"vfs.file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (!newParent.exists() || !newParent.isDirectory()) {
            throw new IOException(IdeBundle.message((String)"vfs.target.not.directory.error", (Object[])new Object[]{newParent.getPath()}));
        }
        if (newParent.findChild(copyName) != null) {
            throw new IOException(IdeBundle.message((String)"vfs.target.already.exists.error", (Object[])new Object[]{newParent.getPath() + "/" + copyName}));
        }
        FileAttributes attributes = this.getAttributes(file2);
        if (attributes == null) {
            throw new FileNotFoundException(IdeBundle.message((String)"file.not.exist.error", (Object[])new Object[]{file2.getPath()}));
        }
        if (attributes.isSpecial()) {
            throw new FileNotFoundException("Not a file: " + file2);
        }
        File ioParent = LocalFileSystemBase.convertToIOFile(newParent);
        if (!ioParent.isDirectory()) {
            throw new IOException(IdeBundle.message((String)"target.not.directory.error", (Object[])new Object[]{ioParent.getPath()}));
        }
        File ioTarget = new File(ioParent, copyName);
        if (ioTarget.exists()) {
            throw new IOException(IdeBundle.message((String)"target.already.exists.error", (Object[])new Object[]{ioTarget.getPath()}));
        }
        if (!this.auxCopy(file2, newParent, copyName)) {
            try {
                File ioFile = LocalFileSystemBase.convertToIOFile(file2);
                FileUtil.copyFileOrDir((File)ioFile, (File)ioTarget, (boolean)attributes.isDirectory());
            }
            catch (IOException e) {
                FileUtil.delete((File)ioTarget);
                throw e;
            }
        }
        this.auxNotifyCompleted((ThrowableConsumer<LocalFileOperationsHandler, IOException>)((ThrowableConsumer)handler2 -> handler2.copy(file2, newParent, copyName)));
        return new FakeVirtualFile(newParent, copyName);
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) {
        File ioFile = LocalFileSystemBase.convertToIOFile(file2);
        if (ioFile.exists() && !ioFile.setLastModified(timeStamp)) {
            LOG.warn("Failed: " + file2.getPath() + ", new:" + timeStamp + ", old:" + ioFile.lastModified());
        }
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        String path = FileUtil.toSystemDependentName((String)file2.getPath());
        FileUtil.setReadOnlyAttribute((String)path, (!writableFlag ? 1 : 0) != 0);
        if (FileUtil.canWrite((String)path) != writableFlag) {
            throw new IOException("Failed to change read-only flag for " + path);
        }
    }

    @NotNull
    protected String extractRootPath(@NotNull String normalizedPath) {
        for (String customRootPath : ourRootPaths) {
            if (!normalizedPath.startsWith(customRootPath)) continue;
            return customRootPath;
        }
        String rootPath = FileUtil.extractRootPath((String)normalizedPath);
        return StringUtil.notNullize((String)rootPath);
    }

    public int getRank() {
        return 1;
    }

    public boolean markNewFilesAsDirty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getCanonicallyCasedName(@NotNull VirtualFile file2) {
        if (this.isCaseSensitive()) {
            return super.getCanonicallyCasedName(file2);
        }
        String originalFileName = file2.getName();
        long t = LOG.isTraceEnabled() ? System.nanoTime() : 0L;
        try {
            String[] canonicalFileNames;
            File ioFile = LocalFileSystemBase.convertToIOFile(file2);
            File canonicalFile = ioFile.getCanonicalFile();
            String canonicalFileName = canonicalFile.getName();
            if (!SystemInfo.isUnix) {
                String string = canonicalFileName;
                return string;
            }
            if (canonicalFileName.compareToIgnoreCase(originalFileName) == 0) {
                String string = canonicalFileName;
                return string;
            }
            File parentFile = ioFile.getParentFile();
            if (parentFile != null && (canonicalFileNames = parentFile.list()) != null) {
                for (String name : canonicalFileNames) {
                    if (name.compareToIgnoreCase(originalFileName) != 0) continue;
                    String string = name;
                    return string;
                }
            }
            String string = canonicalFileName;
            return string;
        }
        catch (IOException | InvalidPathException e) {
            String string = originalFileName;
            return string;
        }
        finally {
            if (t != 0L) {
                t = (System.nanoTime() - t) / 1000L;
                LOG.trace("getCanonicallyCasedName(" + file2 + "): " + t + " mks");
            }
        }
    }

    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        String path = file2.getPath();
        if (SystemInfo.isWindows && file2.getParent() == null && path.startsWith("//")) {
            return FAKE_ROOT_ATTRIBUTES;
        }
        return this.myAttrGetter.accessDiskWithCheckCanceled(FileUtil.toSystemDependentName((String)path));
    }

    public void refresh(boolean asynchronous) {
        RefreshQueue.getInstance().refresh(asynchronous, true, null, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(@NotNull VirtualFile file2) {
        if (file2.getParent() == null) {
            return true;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(file2.getPath(), new String[0]));){
            boolean bl = stream.iterator().hasNext();
            return bl;
        }
        catch (DirectoryIteratorException e) {
            return false;
        }
        catch (IOException | SecurityException | InvalidPathException e) {
            return true;
        }
    }

    static {
        List roots = StringUtil.split((String)System.getProperty("idea.persistentfs.roots", ""), (String)File.pathSeparator);
        roots.sort((o1, o2) -> o2.length() - o1.length());
        ourRootPaths = ArrayUtilRt.toStringArray((Collection)roots);
    }
}

