/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public class DefaultRemoteContentProvider
extends RemoteContentProvider {
    private static final Logger LOG = Logger.getInstance(DefaultRemoteContentProvider.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;

    @NotNull
    public static RequestBuilder addRequestTuner(@NotNull Url url, @NotNull RequestBuilder requestBuilder) {
        BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
        if (builtInServerManager.isOnBuiltInWebServer(url)) {
            requestBuilder.tuner(arg_0 -> ((BuiltInServerManager)builtInServerManager).configureRequestToWebServer(arg_0));
        }
        return requestBuilder;
    }

    @Override
    public boolean canProvideContent(@NotNull Url url) {
        return true;
    }

    @Override
    public void saveContent(@NotNull Url url, @NotNull File file2, @NotNull RemoteContentProvider.DownloadingCallback callback2) {
        Throwable startTrace = ApplicationManager.getApplication().isUnitTestMode() ? new Throwable() : null;
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.downloadContent(url, file2, callback2, startTrace));
    }

    private void downloadContent(@NotNull Url url, @NotNull File file2, final @NotNull RemoteContentProvider.DownloadingCallback callback2, @Nullable Throwable startTrace) {
        LOG.debug("Downloading started: " + url);
        String presentableUrl = StringUtil.trimMiddle((String)url.trimParameters().toDecodedForm(), (int)40);
        callback2.setProgressText(IdeBundle.message((String)"download.progress.connecting", (Object[])new Object[]{presentableUrl}), true);
        try {
            this.connect(url, HttpRequests.request((String)url.toExternalForm()), request2 -> {
                FileType fileTypeByFileName;
                int size = request2.getConnection().getContentLength();
                callback2.setProgressText(IdeBundle.message((String)"download.progress.downloading", (Object[])new Object[]{presentableUrl}), size == -1);
                request2.saveToFile(file2, (ProgressIndicator)new AbstractProgressIndicatorExBase(){

                    @Override
                    public void setFraction(double fraction) {
                        callback2.setProgressFraction(0.0);
                    }
                });
                this.saveAdditionalData(request2, file2);
                FileType fileType = RemoteFileUtil.getFileType(request2.getConnection().getContentType());
                if (fileType == FileTypes.PLAIN_TEXT && (fileTypeByFileName = FileTypeRegistry.getInstance().getFileTypeByFileName(PathUtilRt.getFileName((String)url.getPath()))) != FileTypes.UNKNOWN) {
                    fileType = fileTypeByFileName;
                }
                fileType = this.adjustFileType(fileType, url);
                LOG.debug("Downloading from " + url + " finished, " + size + " bytes downloaded");
                if (startTrace != null) {
                    LOG.debug("Start trace:", startTrace);
                }
                callback2.finished(fileType);
                return null;
            });
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            callback2.errorOccurred(IdeBundle.message((String)"cannot.load.remote.file", (Object[])new Object[]{url, e.getMessage()}), false);
        }
    }

    protected <T> T connect(@NotNull Url url, @NotNull RequestBuilder requestBuilder, @NotNull HttpRequests.RequestProcessor<T> processor2) throws IOException {
        return (T)DefaultRemoteContentProvider.addRequestTuner(url, requestBuilder).connectTimeout(this.getDefaultConnectionTimeout()).productNameAsUserAgent().connect(processor2);
    }

    protected int getDefaultConnectionTimeout() {
        return 60000;
    }

    @Nullable
    protected FileType adjustFileType(@Nullable FileType type, @NotNull Url url) {
        return type;
    }

    protected void saveAdditionalData(@NotNull HttpRequests.Request request2, @NotNull File file2) throws IOException {
    }

    @Override
    public boolean isUpToDate(@NotNull Url url, @NotNull VirtualFile local) {
        return false;
    }
}

