/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.FilePartNode;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import org.jetbrains.annotations.NotNull;

class UrlPartNode
extends FilePartNode {
    @NotNull
    private final String name;

    UrlPartNode(@NotNull String name, @NotNull String parentUrl, @NotNull NewVirtualFileSystem fs) {
        super(fs);
        this.name = name;
        this.myFileOrUrl = UrlPartNode.childUrl(parentUrl, name, fs);
        if (SystemInfo.isUnix ? name.isEmpty() : StringUtil.isEmptyOrSpaces((String)name)) {
            throw new IllegalArgumentException('\'' + name + '\'');
        }
    }

    @Override
    @NotNull
    CharSequence getName() {
        return this.name;
    }

    @Override
    boolean nameEqualTo(int nameId) {
        return FileUtil.PATH_CHAR_SEQUENCE_HASHING_STRATEGY.equals((Object)this.getName(), (Object)UrlPartNode.fromNameId(nameId));
    }

    @Override
    public String toString() {
        return "UrlPartNode: '" + this.getName() + "' -> " + this.children.length;
    }
}

