/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.FilePartNode;
import com.intellij.openapi.vfs.impl.UrlPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilePartNodeRoot
extends FilePartNode {
    private FilePartNodeRoot(@NotNull NewVirtualFileSystem fs) {
        super(fs);
    }

    @Override
    public String toString() {
        return "root -> " + this.children.length;
    }

    @Override
    @NotNull
    CharSequence getName() {
        return "";
    }

    @NotNull
    VirtualFilePointerManagerImpl.NodeToUpdate findOrCreateByFile(@NotNull VirtualFile file2) {
        int nameId = FilePartNodeRoot.getNameId(file2);
        NewVirtualFileSystem fs = (NewVirtualFileSystem)file2.getFileSystem();
        VirtualFile parent = FilePartNodeRoot.getParentThroughJar(file2, fs);
        return this.matchById(parent, file2, nameId, (MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl>)new MultiMap(), true, fs);
    }

    void addRelevantPointersFrom(@NotNull VirtualFileSystemEntry parent, @Nullable VirtualFile file2, int childNameId, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers, @NotNull List<? super VirtualFilePointerManagerImpl.NodeToUpdate> toUpdateNodes, boolean addSubdirectoryPointers, @NotNull NewVirtualFileSystem fs) {
        VirtualFilePointerManagerImpl.NodeToUpdate toUpdate = this.matchById((VirtualFile)parent, file2, childNameId, toFirePointers, false, fs);
        if (toUpdate != null) {
            toUpdateNodes.add(toUpdate);
            toUpdate.node.processPointers(pointer -> toFirePointers.putValue((Object)pointer.myListener, (Object)pointer));
            if (addSubdirectoryPointers) {
                FilePartNodeRoot.addAllPointersStrictlyUnder(toUpdate.node, toFirePointers);
            }
        }
    }

    private static void addAllPointersStrictlyUnder(@NotNull FilePartNode node, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers) {
        for (FilePartNode child2 : node.children) {
            child2.processPointers(pointer -> toFirePointers.putValue((Object)pointer.myListener, (Object)pointer));
            FilePartNodeRoot.addAllPointersStrictlyUnder(child2, toFirePointers);
        }
    }

    @Contract(value="_, _, _, _, true, _ -> !null")
    private VirtualFilePointerManagerImpl.NodeToUpdate matchById(@Nullable VirtualFile parent, @Nullable VirtualFile file2, int childNameId, @NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers, boolean createIfNotFound, @NotNull NewVirtualFileSystem fs) {
        if (childNameId <= 0 && childNameId != -2) {
            throw new IllegalArgumentException("invalid argument childNameId: " + childNameId);
        }
        List parts = parent == null ? Collections.emptyList() : FilePartNodeRoot.getHierarchy(parent, fs);
        FilePartNode node = this;
        for (int i2 = parts.size() - 1; i2 >= 0; --i2) {
            int nameId;
            VirtualFile part = (VirtualFile)parts.get(i2);
            if ((node = node.findChildByNameId(part, nameId = FilePartNodeRoot.getNameId(part), createIfNotFound, (NewVirtualFileSystem)part.getFileSystem())) == null) {
                return null;
            }
            node.addRecursiveDirectoryPtrTo(toFirePointers);
        }
        FilePartNode child2 = node.findChildByNameId(file2, childNameId, createIfNotFound, fs);
        return child2 == null ? null : new VirtualFilePointerManagerImpl.NodeToUpdate(node, child2);
    }

    @NotNull
    private static List<VirtualFile> getHierarchy(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem fs) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        while (true) {
            result2.add(file2);
            file2 = FilePartNodeRoot.getParentThroughJar(file2, fs);
            if (file2 == null) break;
            fs = (NewVirtualFileSystem)file2.getFileSystem();
        }
        return result2;
    }

    @NotNull
    VirtualFilePointerManagerImpl.NodeToUpdate findOrCreateByPath(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        NullVirtualFile NEVER_TRIED_TO_FIND;
        List<String> names2 = FilePartNodeRoot.splitNames(path);
        NewVirtualFile fsRoot = null;
        NullVirtualFile currentFile = NEVER_TRIED_TO_FIND = NullVirtualFile.INSTANCE;
        FilePartNode currentNode = this;
        FilePartNodeRoot parentNode = this;
        LocalFileSystem currentFS = fs instanceof ArchiveFileSystem ? LocalFileSystem.getInstance() : fs;
        for (int i2 = names2.size() - 1; i2 >= 0; --i2) {
            int index;
            String name = names2.get(i2);
            if (name.equals("!/") && currentFS instanceof LocalFileSystem) {
                currentFS = fs;
            }
            if ((index = currentNode.binarySearchChildByName(name)) >= 0) {
                parentNode = currentNode;
                currentNode = currentNode.children[index];
                currentFile = currentFile == NEVER_TRIED_TO_FIND || currentFile == null ? currentFile : currentFile.findChild(name);
                continue;
            }
            if (currentFile == NEVER_TRIED_TO_FIND) {
                if (fsRoot == null) {
                    String rootPath = (String)ContainerUtil.getLastItem(names2);
                    fsRoot = ManagingFS.getInstance().findRoot(rootPath, (NewVirtualFileSystem)(fs instanceof ArchiveFileSystem ? LocalFileSystem.getInstance() : fs));
                    if (fsRoot != null && !FileUtil.namesEqual((String)fsRoot.getName(), (String)rootPath)) {
                        fsRoot = null;
                    }
                }
                currentFile = fsRoot == null ? null : FilePartNodeRoot.findFileFromRoot(fsRoot, (NewVirtualFileSystem)currentFS, names2, i2);
            } else {
                VirtualFile virtualFile = currentFile = currentFile == null ? null : FilePartNodeRoot.findChildThroughJar((VirtualFile)currentFile, name, (NewVirtualFileSystem)currentFS);
            }
            FilePartNode child2 = currentFile == null ? new UrlPartNode(name, FilePartNodeRoot.myUrl(currentNode.myFileOrUrl), (NewVirtualFileSystem)currentFS) : new FilePartNode(name.equals("!/") ? -2 : FilePartNodeRoot.getNameId((VirtualFile)currentFile), currentFile, (NewVirtualFileSystem)currentFS);
            currentNode.children = (FilePartNode[])ArrayUtil.insert((Object[])currentNode.children, (int)(-index - 1), (Object)child2);
            parentNode = currentNode;
            currentNode = child2;
        }
        return new VirtualFilePointerManagerImpl.NodeToUpdate(parentNode, currentNode);
    }

    @NotNull
    static List<String> splitNames(@NotNull String path) {
        ArrayList<String> names2 = new ArrayList<String>(20);
        int end = path.length();
        if (end == 0) {
            return names2;
        }
        while (true) {
            boolean isJarSeparator;
            boolean bl = isJarSeparator = StringUtil.endsWith((CharSequence)path, (int)0, (int)end, (CharSequence)"!/") && end > 2 && path.charAt(end - 3) != '/';
            if (isJarSeparator) {
                names2.add("!/");
                end -= 2;
                continue;
            }
            if (path.charAt(end - 1) == '/') {
                --end;
            }
            if (end == 0 && path.charAt(0) == '/') {
                end = 1;
            }
            int startIndex = FilePartNodeRoot.extractName(path, end);
            assert (startIndex != end) : "startIndex: " + startIndex + "; end: " + end + "; path:'" + path + "'; toExtract: '" + path.substring(0, end) + "'";
            names2.add(path.substring(startIndex, end));
            if (startIndex == 0) break;
            end = startIndex;
        }
        return names2;
    }

    private static VirtualFile findFileFromRoot(@NotNull NewVirtualFile root, @NotNull NewVirtualFileSystem fs, @NotNull List<String> names2, int startIndex) {
        String name;
        NewVirtualFile file2 = root;
        for (int i2 = names2.size() - 2; i2 >= startIndex && (file2 = FilePartNodeRoot.findChildThroughJar((VirtualFile)file2, name = names2.get(i2), fs)) != null; --i2) {
        }
        return file2;
    }

    private static int extractName(@NotNull CharSequence path, int length) {
        if (length == 1 && path.charAt(0) == '/') {
            return 0;
        }
        int i2 = StringUtil.lastIndexOf((CharSequence)path, (char)'/', (int)0, (int)length);
        if (i2 != -1 && PathUtilRt.isWindowsUNCRoot((CharSequence)path, (int)i2)) {
            return 0;
        }
        return i2 + 1;
    }

    void removePointer(@NotNull VirtualFilePointerImpl pointer) {
        FilePartNode node = pointer.myNode;
        int remainingLeaves = node.removeLeaf(pointer);
        if (remainingLeaves == 0) {
            VirtualFile file2 = FilePartNodeRoot.myFile(node.myFileOrUrl);
            if (file2 == null) {
                List<String> parts = FilePartNodeRoot.splitNames(VfsUtilCore.urlToPath((String)FilePartNodeRoot.myUrl(node.myFileOrUrl)));
                this.removeEmptyNodesByPath(parts);
            } else {
                List<VirtualFile> parts = FilePartNodeRoot.getHierarchy(file2, (NewVirtualFileSystem)file2.getFileSystem());
                this.removeEmptyNodesByFile(parts);
            }
        }
    }

    void checkConsistency() {
        if (VirtualFilePointerManagerImpl.IS_UNDER_UNIT_TEST && !ApplicationInfoImpl.isInStressTest()) {
            this.doCheckConsistency(null, "", this.myFS.getProtocol() + "://");
        }
    }

    @NotNull
    static FilePartNodeRoot createFakeRoot(@NotNull NewVirtualFileSystem fs) {
        return new FilePartNodeRoot(fs);
    }
}

