/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DummyCachingFileSystem<T extends VirtualFile>
extends DummyFileSystem {
    private final String myProtocol;
    private final ConcurrentMap<String, T> myCachedFiles = ConcurrentFactoryMap.create(this::findFileByPathInner, ContainerUtil::createConcurrentWeakValueMap);
    private static final Key<Boolean> DISPOSE_CALLBACK = Key.create((String)"DISPOSE_CALLBACK");

    public DummyCachingFileSystem(String protocol) {
        this.myProtocol = protocol;
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                DummyCachingFileSystem.this.onProjectOpened(project);
            }

            public void projectClosed(@NotNull Project project) {
                DummyCachingFileSystem.this.registerDisposeCallback(project);
            }
        });
        this.initProjectMap();
    }

    @Override
    @NotNull
    public final String getProtocol() {
        return this.myProtocol;
    }

    @Override
    @Nullable
    public final VirtualFile createRoot(String name) {
        return null;
    }

    public final T findFileByPath(@NotNull String path) {
        return (T)((VirtualFile)this.myCachedFiles.get(path));
    }

    @Override
    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        T file2 = this.findFileByPath(path);
        return file2 != null ? this.getPresentableUrl((VirtualFile)file2) : super.extractPresentableUrl(path);
    }

    protected String getPresentableUrl(@NotNull VirtualFile file2) {
        return file2.getPresentableName();
    }

    protected abstract T findFileByPathInner(@NotNull String var1);

    protected void doRenameFile(VirtualFile vFile, String newName) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Nullable
    public Project getProject(@Nullable String projectId) {
        Project project = ProjectManagerEx.getInstanceEx().findOpenProjectByHash(projectId);
        if (ApplicationManager.getApplication().isUnitTestMode() && project != null) {
            this.registerDisposeCallback(project);
            DISPOSE_CALLBACK.set((UserDataHolder)project, (Object)Boolean.TRUE);
        }
        return project;
    }

    @NotNull
    public Collection<T> getCachedFiles() {
        return this.myCachedFiles.values().stream().filter(Objects::nonNull).filter(VirtualFile::isValid).collect(Collectors.toList());
    }

    public void onProjectClosed() {
        this.clearCache();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.cleanup();
        }
    }

    public void onProjectOpened(Project project) {
        this.clearCache();
    }

    private void registerDisposeCallback(Project project) {
        if (Boolean.TRUE.equals(DISPOSE_CALLBACK.get((UserDataHolder)project))) {
            return;
        }
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                DummyCachingFileSystem.this.onProjectClosed();
            }
        });
    }

    private void initProjectMap() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!project.isOpen()) continue;
            this.onProjectOpened(project);
        }
    }

    protected void clearCache() {
        this.retainFiles((Condition<VirtualFile>)((Condition)VirtualFile::isValid));
    }

    protected void retainFiles(@NotNull Condition<? super VirtualFile> c) {
        for (Map.Entry entry : this.myCachedFiles.entrySet()) {
            VirtualFile t = (VirtualFile)entry.getValue();
            if (t != null && c.value((Object)t)) continue;
            this.myCachedFiles.remove(entry.getKey());
        }
    }

    private void cleanup() {
        this.myCachedFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        String oldName = vFile.getName();
        this.beforeFileRename(vFile, requestor, oldName, newName);
        try {
            this.doRenameFile(vFile, newName);
        }
        finally {
            this.fileRenamed(vFile, requestor, oldName, newName);
        }
    }

    protected void beforeFileRename(@NotNull VirtualFile file2, Object requestor, @NotNull String oldName, @NotNull String newName) {
        this.fireBeforePropertyChange(requestor, file2, "name", oldName, newName);
        this.myCachedFiles.remove(file2.getPath());
    }

    protected void fileRenamed(@NotNull VirtualFile file2, Object requestor, String oldName, String newName) {
        this.myCachedFiles.put(file2.getPath(), file2);
        this.firePropertyChanged(requestor, file2, "name", oldName, newName);
    }

    protected static String escapeSlash(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String)"/", (String)"&slash;");
    }

    protected static String unescapeSlash(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String)"&slash;", (String)"/");
    }
}

