/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformVirtualFileManager
extends VirtualFileManagerImpl {
    @NotNull
    private final ManagingFS myManagingFS = ManagingFS.getInstance();

    public PlatformVirtualFileManager() {
        super(Collections.emptyList());
    }

    @Override
    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsWriteThread();
        }
        RefreshSession session2 = RefreshQueue.getInstance().createSession(asynchronous, true, postAction);
        session2.addAllFiles(this.myManagingFS.getRoots());
        session2.launch();
        super.doRefresh(asynchronous, postAction);
        return session2.getId();
    }

    @Override
    public long getModificationCount() {
        return this.myManagingFS.getModificationCount();
    }

    @Override
    public long getStructureModificationCount() {
        return this.myManagingFS.getStructureModificationCount();
    }

    public VirtualFile findFileById(int id2) {
        return this.myManagingFS.findFileById(id2);
    }

    @Override
    @NotNull
    public CharSequence getVFileName(int nameId) {
        return FileNameCache.getVFileName(nameId);
    }

    @Override
    public int storeName(@NotNull String name) {
        return FileNameCache.storeName(name);
    }
}

