/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DiskQueryRelay<Param, Result> {
    @NotNull
    private final Function<? super Param, ? extends Result> myFunction;
    private final Map<Param, Future<Result>> myTasks = new ConcurrentHashMap<Param, Future<Result>>();

    public DiskQueryRelay(@NotNull Function<? super Param, ? extends Result> function) {
        this.myFunction = function;
    }

    public Result accessDiskWithCheckCanceled(@NotNull Param arg) {
        if (ProgressIndicatorProvider.getGlobalProgressIndicator() == null) {
            return this.myFunction.apply(arg);
        }
        Future future2 = this.myTasks.computeIfAbsent(arg, eachArg -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Result Result2 = this.myFunction.apply(eachArg);
                return Result2;
            }
            finally {
                this.myTasks.remove(eachArg);
            }
        }));
        if (future2.isDone()) {
            this.myTasks.remove(arg, future2);
        }
        return (Result)ProgressIndicatorUtils.awaitWithCheckCanceled(future2);
    }
}

