/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ReadonlyStatusHandler", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ReadonlyStatusHandlerImpl
extends ReadonlyStatusHandler
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(ReadonlyStatusHandlerImpl.class);
    private final Project myProject;
    private boolean myClearReadOnlyInTests;
    private State myState = new State();

    public ReadonlyStatusHandlerImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles) {
        OperationStatusImpl operationStatusImpl;
        if (originalFiles.isEmpty()) {
            return new OperationStatusImpl(VirtualFile.EMPTY_ARRAY);
        }
        ReadonlyStatusHandlerImpl.checkThreading();
        HashSet<void> realFiles = new HashSet<void>(originalFiles.size());
        for (VirtualFile virtualFile : originalFiles) {
            void var4_4;
            void var4_7;
            VirtualFile originalFile;
            if (virtualFile instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)virtualFile).getOriginalFile()) != null) {
                VirtualFile virtualFile2 = originalFile;
            }
            if (var4_7 instanceof VirtualFileWindow) {
                VirtualFile virtualFile3 = ((VirtualFileWindow)var4_7).getDelegate();
            }
            if (var4_4 == null) continue;
            realFiles.add(var4_4);
        }
        ArrayList files2 = new ArrayList(realFiles);
        if (!this.myProject.isDefault() && (operationStatusImpl = (OperationStatusImpl)((Object)WritingAccessProvider.EP.computeSafeIfAny((AreaInstance)this.myProject, provider -> {
            Collection denied = ContainerUtil.filter((Collection)files2, virtualFile -> !provider.isPotentiallyWritable(virtualFile));
            if (denied.isEmpty()) {
                denied = provider.requestWriting(files2);
            }
            if (!denied.isEmpty()) {
                return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray((Collection)denied), provider.getReadOnlyMessage());
            }
            return null;
        }))) != null) {
            return operationStatusImpl;
        }
        List<FileInfo> list2 = this.createFileInfos(files2);
        if (list2.isEmpty()) {
            return ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myClearReadOnlyInTests) {
                ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(list2), null);
            }
            return ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
        }
        int savedEventCount = IdeEventQueue.getInstance().getEventCount();
        if (this.myState.SHOW_DIALOG) {
            new ReadOnlyStatusDialog(this.myProject, list2).show();
        } else {
            ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(list2), null);
        }
        IdeEventQueue.getInstance().setEventCount(savedEventCount);
        return ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
    }

    private static void checkThreading() {
        Application app = ApplicationManager.getApplication();
        app.assertIsWriteThread();
        if (!app.isWriteAccessAllowed()) {
            return;
        }
        if (app.isUnitTestMode() && Registry.is((String)"tests.assert.clear.read.only.status.outside.write.action")) {
            LOG.error("ensureFilesWritable should be called outside write action");
        }
    }

    private static ReadonlyStatusHandler.OperationStatus createResultStatus(@NotNull Collection<? extends VirtualFile> originalFiles, @NotNull Collection<? extends VirtualFile> files2) {
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            if (!virtualFile.exists() || virtualFile.isWritable()) continue;
            readOnlyFiles.add(virtualFile);
        }
        assert (!readOnlyFiles.isEmpty() || originalFiles.stream().allMatch(file2 -> file2 == null || file2.isWritable())) : "Original files: " + originalFiles + ", files: " + files2;
        return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(readOnlyFiles));
    }

    @NotNull
    private List<FileInfo> createFileInfos(@NotNull Collection<? extends VirtualFile> files2) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (VirtualFile virtualFile : files2) {
            if (virtualFile == null || virtualFile.isWritable() || !virtualFile.isInLocalFileSystem()) continue;
            fileInfos.add(new FileInfo(virtualFile, this.myProject));
        }
        return fileInfos;
    }

    public static void processFiles(@NotNull List<FileInfo> fileInfos, @Nullable String changelist) {
        FileInfo[] copy2 = fileInfos.toArray(new FileInfo[0]);
        MultiMap handleTypeToFile = new MultiMap();
        for (FileInfo fileInfo : copy2) {
            handleTypeToFile.putValue((Object)fileInfo.getSelectedHandleType(), (Object)fileInfo.getFile());
        }
        for (HandleType handleType : handleTypeToFile.keySet()) {
            handleType.processFiles(handleTypeToFile.get((Object)handleType), changelist);
        }
        for (FileInfo fileInfo : copy2) {
            if (fileInfo.getFile().exists() && !fileInfo.getFile().isWritable()) continue;
            fileInfos.remove(fileInfo);
        }
    }

    public void setClearReadOnlyInTests(boolean clearReadOnlyInTests) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myClearReadOnlyInTests = clearReadOnlyInTests;
    }

    private static final class OperationStatusImpl
    extends ReadonlyStatusHandler.OperationStatus {
        private final VirtualFile[] myReadonlyFiles;
        @NotNull
        private final String myReadOnlyReason;

        OperationStatusImpl(VirtualFile @NotNull [] readonlyFiles) {
            this(readonlyFiles, "");
        }

        private OperationStatusImpl(VirtualFile[] readonlyFiles, @NotNull String readOnlyReason) {
            this.myReadonlyFiles = readonlyFiles;
            this.myReadOnlyReason = readOnlyReason;
        }

        public VirtualFile @NotNull [] getReadonlyFiles() {
            return this.myReadonlyFiles;
        }

        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        @NotNull
        public String getReadonlyFilesMessage() {
            if (this.hasReadonlyFiles()) {
                if (!Strings.isEmpty((String)this.myReadOnlyReason)) {
                    return this.myReadOnlyReason;
                }
                if (this.myReadonlyFiles.length > 1) {
                    StringBuilder buf = new StringBuilder();
                    for (VirtualFile file2 : this.myReadonlyFiles) {
                        buf.append('\n');
                        buf.append(file2.getPresentableUrl());
                    }
                    return IdeBundle.message((String)"failed.to.make.the.following.files.writable.error.message", (Object[])new Object[]{buf.toString()});
                }
                return IdeBundle.message((String)"failed.to.make.file.writable.error.message", (Object[])new Object[]{this.myReadonlyFiles[0].getPresentableUrl()});
            }
            throw new RuntimeException("No readonly files");
        }
    }

    public static final class State {
        public boolean SHOW_DIALOG = true;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.SHOW_DIALOG == state.SHOW_DIALOG;
        }

        public int hashCode() {
            return this.SHOW_DIALOG ? 1 : 0;
        }
    }
}

