/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\"\u001a\u00020#R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/vcs/ex/BulkRangeChangeHandler;", "", "handler", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "blocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "side", "Lcom/intellij/diff/util/Side;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;Ljava/util/List;Lcom/intellij/diff/util/Side;)V", "blockShift", "", "changeShift", "dirtyBlockShift", "dirtyBlocks", "", "dirtyBlocksModified", "", "dirtyChangeShift", "dirtyEnd", "dirtyStart", "newBlocks", "flush", "", "nextLine", "handleBlock", "block", "handleChange", "range", "Lcom/intellij/diff/util/Range;", "markDirtyRange", "start", "end", "run", "iterable", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "intellij.platform.diff.impl"})
final class BulkRangeChangeHandler {
    private final List<DocumentTracker.Block> newBlocks;
    private int dirtyStart;
    private int dirtyEnd;
    private final List<DocumentTracker.Block> dirtyBlocks;
    private boolean dirtyBlocksModified;
    private int blockShift;
    private int changeShift;
    private int dirtyBlockShift;
    private int dirtyChangeShift;
    private final DocumentTracker.Handler handler;
    private final List<DocumentTracker.Block> blocks;
    private final Side side;

    @NotNull
    public final List<DocumentTracker.Block> run(@NotNull DiffIterable iterable) {
        PeekableIteratorWrapper it1 = new PeekableIteratorWrapper(this.blocks.iterator());
        PeekableIteratorWrapper it2 = new PeekableIteratorWrapper(iterable.changes());
        while (it1.hasNext() || it2.hasNext()) {
            if (!it2.hasNext()) {
                this.handleBlock((DocumentTracker.Block)it1.next());
                continue;
            }
            if (!it1.hasNext()) {
                this.handleChange((Range)it2.next());
                continue;
            }
            DocumentTracker.Block block = (DocumentTracker.Block)it1.peek();
            Range range1 = block.getRange();
            Range range2 = (Range)it2.peek();
            if (RangesBuilder.start(range1, this.side) <= range2.start1) {
                this.handleBlock((DocumentTracker.Block)it1.next());
                continue;
            }
            this.handleChange((Range)it2.next());
        }
        this.flush(Integer.MAX_VALUE);
        return this.newBlocks;
    }

    private final void handleBlock(DocumentTracker.Block block) {
        Range range2 = block.getRange();
        this.flush(RangesBuilder.start(range2, this.side));
        this.dirtyBlockShift += DocumentTrackerKt.access$getRangeDelta(range2, this.side);
        this.markDirtyRange(RangesBuilder.start(range2, this.side), RangesBuilder.end(range2, this.side));
        this.dirtyBlocks.add(block);
    }

    private final void handleChange(Range range2) {
        this.flush(range2.start1);
        this.dirtyChangeShift += DocumentTrackerKt.access$getRangeDelta(range2, Side.LEFT);
        this.markDirtyRange(range2.start1, range2.end1);
        this.dirtyBlocksModified = true;
    }

    private final void markDirtyRange(int start2, int end) {
        if (this.dirtyEnd == -1) {
            this.dirtyStart = start2;
            this.dirtyEnd = end;
        } else {
            int n = this.dirtyEnd;
            boolean bl = false;
            this.dirtyEnd = Math.max(n, end);
        }
    }

    private final void flush(int nextLine) {
        if (this.dirtyEnd != -1 && this.dirtyEnd < nextLine) {
            if (this.dirtyBlocksModified) {
                boolean bl;
                block10: {
                    Iterable $this$any$iv = this.dirtyBlocks;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DocumentTracker.Block it = (DocumentTracker.Block)element$iv;
                            boolean bl2 = false;
                            if (!it.isTooBig$intellij_platform_diff_impl()) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                boolean isTooBig = bl;
                boolean isDirty = true;
                Range range2 = DocumentTrackerKt.access$createRange(this.side, this.dirtyStart + this.changeShift, this.dirtyEnd + this.changeShift + this.dirtyChangeShift, this.dirtyStart + this.blockShift, this.dirtyEnd + this.blockShift + this.dirtyBlockShift);
                DocumentTracker.Block newBlock = new DocumentTracker.Block(range2, isDirty, isTooBig);
                this.handler.onRangesChanged(this.dirtyBlocks, newBlock);
                this.newBlocks.add(newBlock);
            } else {
                boolean isTooBig = this.dirtyBlocks.size() == 1;
                boolean bl = false;
                boolean range2 = false;
                if (_Assertions.ENABLED && !isTooBig) {
                    boolean bl3 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (this.changeShift != 0) {
                    for (DocumentTracker.Block oldBlock : this.dirtyBlocks) {
                        DocumentTracker.Block newBlock = DocumentTrackerKt.access$shift(oldBlock, this.side, this.changeShift);
                        this.handler.onRangeShifted(oldBlock, newBlock);
                        this.newBlocks.add(newBlock);
                    }
                } else {
                    this.newBlocks.addAll((Collection<DocumentTracker.Block>)this.dirtyBlocks);
                }
            }
            this.dirtyStart = -1;
            this.dirtyEnd = -1;
            this.dirtyBlocks.clear();
            this.dirtyBlocksModified = false;
            this.blockShift += this.dirtyBlockShift;
            this.changeShift += this.dirtyChangeShift;
            this.dirtyBlockShift = 0;
            this.dirtyChangeShift = 0;
        }
    }

    public BulkRangeChangeHandler(@NotNull DocumentTracker.Handler handler2, @NotNull List<DocumentTracker.Block> blocks, @NotNull Side side) {
        this.handler = handler2;
        this.blocks = blocks;
        this.side = side;
        boolean bl = false;
        this.newBlocks = new ArrayList();
        this.dirtyStart = -1;
        this.dirtyEnd = -1;
        bl = false;
        this.dirtyBlocks = new ArrayList();
    }
}

