/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.migrate;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diff.FileContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MigrateToNewDiffUtil {
    @NotNull
    public static DiffRequest convertRequest(@NotNull com.intellij.openapi.diff.DiffRequest oldRequest) {
        com.intellij.openapi.diff.DiffContent[] contents = oldRequest.getContents();
        String[] titles = oldRequest.getContentTitles();
        ArrayList<DiffContent> newContents = new ArrayList<DiffContent>(contents.length);
        for (com.intellij.openapi.diff.DiffContent content2 : contents) {
            newContents.add(MigrateToNewDiffUtil.convertContent(oldRequest.getProject(), content2));
        }
        return new SimpleDiffRequest(oldRequest.getWindowTitle(), newContents, Arrays.asList(titles));
    }

    @NotNull
    private static DiffContent convertContent(@Nullable Project project, @NotNull com.intellij.openapi.diff.DiffContent oldContent) {
        DiffContentFactory factory2 = DiffContentFactory.getInstance();
        if (oldContent.isEmpty()) {
            return factory2.createEmpty();
        }
        if (oldContent instanceof FileContent) {
            VirtualFile file2 = Objects.requireNonNull(oldContent.getFile());
            return factory2.create(project, file2);
        }
        if (oldContent instanceof SimpleContent) {
            return factory2.create(project, ((SimpleContent)oldContent).getText(), oldContent.getContentType());
        }
        Document document = Objects.requireNonNull(oldContent.getDocument());
        return factory2.create(project, document, oldContent.getContentType());
    }

    @NotNull
    public static MergeRequest convertMergeRequest(@NotNull MergeRequestImpl request2) throws InvalidDiffRequestException {
        MergeRequestImpl.MergeContent mergeContent = Objects.requireNonNull(request2.getMergeContent());
        MergeVersion.MergeDocumentVersion mergeVersion = (MergeVersion.MergeDocumentVersion)mergeContent.getMergeVersion();
        SimpleContent leftContent = (SimpleContent)request2.getContents()[0];
        SimpleContent rightContent = (SimpleContent)request2.getContents()[2];
        List<String> contents = Arrays.asList(leftContent.getText(), mergeVersion.getOriginalText(), rightContent.getText());
        Document document = mergeContent.getDocument();
        String windowTitle = request2.getWindowTitle();
        List<String> titles = Arrays.asList(request2.getContentTitles());
        Consumer callback2 = result2 -> request2.setResult(result2 == MergeResult.CANCEL ? 1 : 0);
        return DiffRequestFactory.getInstance().createMergeRequest(request2.getProject(), mergeContent.getContentType(), document, contents, windowTitle, titles, callback2);
    }
}

