/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.WindowState;
import com.intellij.openapi.util.WindowStateAdapter;
import com.intellij.openapi.util.WindowStateBean;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class WindowStateServiceImpl
extends WindowStateService
implements ModificationTracker,
PersistentStateComponent<Element> {
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String STATE = "state";
    @NonNls
    private static final String MAXIMIZED = "maximized";
    @NonNls
    private static final String FULL_SCREEN = "full-screen";
    @NonNls
    private static final String TIMESTAMP = "timestamp";
    @NonNls
    private static final String SCREEN = "screen";
    private static final Logger LOG = Logger.getInstance(WindowStateService.class);
    private final AtomicLong myModificationCount = new AtomicLong();
    private final Map<String, Runnable> myRunnableMap = new TreeMap<String, Runnable>();
    private final Map<String, CachedState> myStateMap = new TreeMap<String, CachedState>();

    protected WindowStateServiceImpl(@Nullable Project project) {
        super(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModificationCount() {
        Map<String, Runnable> map2 = this.myRunnableMap;
        synchronized (map2) {
            this.myRunnableMap.values().forEach(Runnable::run);
        }
        return this.myModificationCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element getState() {
        Element element2 = new Element(STATE);
        Map<String, CachedState> map2 = this.myStateMap;
        synchronized (map2) {
            for (Map.Entry<String, CachedState> entry : this.myStateMap.entrySet()) {
                String key = entry.getKey();
                if (key == null) continue;
                CachedState state = entry.getValue();
                Element child2 = new Element(STATE);
                if (state.myLocation != null) {
                    JDOMUtil.setLocation((Element)child2, (Point)state.myLocation);
                }
                if (state.mySize != null) {
                    JDOMUtil.setSize((Element)child2, (Dimension)state.mySize);
                }
                if (state.myMaximized) {
                    child2.setAttribute(MAXIMIZED, Boolean.toString(true));
                }
                if (state.myFullScreen) {
                    child2.setAttribute(FULL_SCREEN, Boolean.toString(true));
                }
                if (state.myScreen != null) {
                    child2.addContent(JDOMUtil.setBounds((Element)new Element(SCREEN), (Rectangle)state.myScreen));
                }
                child2.setAttribute(KEY, key);
                child2.setAttribute(TIMESTAMP, Long.toString(state.myTimeStamp));
                element2.addContent(child2);
            }
        }
        return element2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadState(@NotNull Element element2) {
        Map<String, CachedState> map2 = this.myStateMap;
        synchronized (map2) {
            this.myStateMap.clear();
            for (Element child2 : element2.getChildren()) {
                String key;
                if (!STATE.equals(child2.getName())) continue;
                long current2 = System.currentTimeMillis();
                long timestamp = StringUtilRt.parseLong((String)child2.getAttributeValue(TIMESTAMP), (long)current2);
                if (TimeUnit.DAYS.toMillis(100L) <= current2 - timestamp || StringUtilRt.isEmpty((CharSequence)(key = child2.getAttributeValue(KEY)))) continue;
                Point location = JDOMUtil.getLocation((Element)child2);
                Dimension size = JDOMUtil.getSize((Element)child2);
                if (location == null && size == null) continue;
                CachedState state = new CachedState();
                state.myLocation = location;
                state.mySize = size;
                state.myMaximized = Boolean.parseBoolean(child2.getAttributeValue(MAXIMIZED));
                state.myFullScreen = Boolean.parseBoolean(child2.getAttributeValue(FULL_SCREEN));
                state.myScreen = WindowStateServiceImpl.apply(JDOMUtil::getBounds, child2.getChild(SCREEN));
                state.myTimeStamp = timestamp;
                this.myStateMap.put(key, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowState getStateFor(final @Nullable Project project, final @NotNull String key, @NotNull Window window) {
        Map<String, Runnable> map2 = this.myRunnableMap;
        synchronized (map2) {
            final WindowStateBean state = WindowStateAdapter.getState(window);
            Runnable runnable2 = this.myRunnableMap.put(key, new Runnable(){
                private long myModificationCount;
                {
                    this.myModificationCount = state.getModificationCount();
                }

                @Override
                public void run() {
                    long newModificationCount = state.getModificationCount();
                    if (this.myModificationCount != newModificationCount) {
                        this.myModificationCount = newModificationCount;
                        Point location = state.getLocation();
                        Dimension size = state.getSize();
                        WindowStateServiceImpl.this.putFor(project, key, location, location != null, size, size != null, 6 == state.getExtendedState(), true, state.isFullScreen(), true);
                    }
                }
            });
            if (runnable2 != null) {
                runnable2.run();
            }
        }
        return this.getFor(project, key, WindowState.class);
    }

    public Point getLocationFor(Object object, @NotNull String key) {
        return this.getFor(object, key, Point.class);
    }

    public void putLocationFor(Object object, @NotNull String key, Point location) {
        this.putFor(object, key, location, true, null, false, false, false, false, false);
    }

    public Dimension getSizeFor(Object object, @NotNull String key) {
        return this.getFor(object, key, Dimension.class);
    }

    public void putSizeFor(Object object, @NotNull String key, Dimension size) {
        this.putFor(object, key, null, false, size, true, false, false, false, false);
    }

    public Rectangle getBoundsFor(Object object, @NotNull String key) {
        return this.getFor(object, key, Rectangle.class);
    }

    public void putBoundsFor(Object object, @NotNull String key, Rectangle bounds2) {
        Point location = WindowStateServiceImpl.apply(Rectangle::getLocation, bounds2);
        Dimension size = WindowStateServiceImpl.apply(Rectangle::getSize, bounds2);
        this.putFor(object, key, location, true, size, true, false, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getFor(Object object, @NotNull String key, @NotNull Class<T> type) {
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            return null;
        }
        if (Registry.is((String)"ui.disable.dimension.service.keys")) {
            return null;
        }
        if (UISettings.getInstance().getPresentationMode()) {
            key = key + ".inPresentationMode";
        }
        GraphicsConfiguration configuration = WindowStateServiceImpl.getConfiguration(object);
        Map<String, CachedState> map2 = this.myStateMap;
        synchronized (map2) {
            CachedState state = this.myStateMap.get(WindowStateServiceImpl.getAbsoluteKey(configuration, key));
            if (WindowStateServiceImpl.isVisible(state)) {
                return state.get(type, null);
            }
            state = this.myStateMap.get(key);
            T t = state == null ? null : (T)state.get(type, state.myScreen == null ? null : WindowStateServiceImpl.getScreenRectangle(configuration));
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFor(Object object, @NotNull String key, Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            return;
        }
        if (UISettings.getInstance().getPresentationMode()) {
            key = key + ".inPresentationMode";
        }
        GraphicsConfiguration configuration = WindowStateServiceImpl.getConfiguration(object);
        Map<String, CachedState> map2 = this.myStateMap;
        synchronized (map2) {
            this.put(WindowStateServiceImpl.getAbsoluteKey(configuration, key), location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet);
            CachedState state = this.put(key, location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet);
            if (state != null) {
                state.updateScreenRectangle(configuration);
            }
        }
        this.myModificationCount.getAndIncrement();
    }

    @Nullable
    private CachedState put(@NotNull String key, @Nullable Point location, boolean locationSet, @Nullable Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
        CachedState state = this.myStateMap.get(key);
        if (state == null) {
            state = new CachedState();
            if (!state.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
                return null;
            }
            this.myStateMap.put(key, state);
            return state;
        }
        if (state.set(location, locationSet, size, sizeSet, maximized, maximizedSet, fullScreen, fullScreenSet)) {
            return state;
        }
        this.myStateMap.remove(key);
        return null;
    }

    @NotNull
    private static String getAbsoluteKey(@Nullable GraphicsConfiguration configuration, @NotNull String key) {
        StringBuilder sb = new StringBuilder(key);
        for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle bounds2 = ScreenUtil.getScreenRectangle((GraphicsConfiguration)device.getDefaultConfiguration());
            sb.append('/').append(bounds2.x);
            sb.append('.').append(bounds2.y);
            sb.append('.').append(bounds2.width);
            sb.append('.').append(bounds2.height);
        }
        if (configuration != null) {
            Rectangle bounds3 = ScreenUtil.getScreenRectangle((GraphicsConfiguration)configuration);
            sb.append('@').append(bounds3.x);
            sb.append('.').append(bounds3.y);
            sb.append('.').append(bounds3.width);
            sb.append('.').append(bounds3.height);
        }
        return sb.toString();
    }

    @Nullable
    private static GraphicsConfiguration getConfiguration(@Nullable Object object) {
        GraphicsDevice device;
        if (object instanceof Project) {
            Project project = (Project)object;
            object = WindowManager.getInstance().getFrame(project);
            if (object == null) {
                LOG.warn("cannot find a project frame for " + project);
            }
        }
        if (object instanceof Window) {
            Window window = (Window)object;
            GraphicsConfiguration configuration = window.getGraphicsConfiguration();
            if (configuration != null) {
                return configuration;
            }
            object = ScreenUtil.getScreenDevice((Rectangle)window.getBounds());
            if (object == null) {
                LOG.warn("cannot find a device for " + window);
            }
        }
        if (object instanceof GraphicsDevice && (object = (device = (GraphicsDevice)object).getDefaultConfiguration()) == null) {
            LOG.warn("cannot find a configuration for " + device);
        }
        if (object instanceof GraphicsConfiguration) {
            return (GraphicsConfiguration)object;
        }
        if (object != null) {
            LOG.warn("unexpected object " + object.getClass());
        }
        return null;
    }

    @NotNull
    private static Rectangle getScreenRectangle(@Nullable GraphicsConfiguration configuration) {
        return configuration != null ? ScreenUtil.getScreenRectangle((GraphicsConfiguration)configuration) : ScreenUtil.getMainScreenBounds();
    }

    private static boolean isVisible(CachedState state) {
        return state != null && WindowStateServiceImpl.isVisible(state.myLocation, state.mySize);
    }

    private static boolean isVisible(Point location, Dimension size) {
        if (location == null) {
            return size != null;
        }
        if (ScreenUtil.isVisible((Point)location)) {
            return true;
        }
        if (size == null) {
            return false;
        }
        return ScreenUtil.isVisible((Rectangle)new Rectangle(location, size));
    }

    @Nullable
    private static <T, R> R apply(@NotNull Function<T, R> function, @Nullable T value2) {
        return value2 == null ? null : (R)function.apply(value2);
    }

    private static final class CachedState {
        private Rectangle myScreen;
        private Point myLocation;
        private Dimension mySize;
        private boolean myMaximized;
        private boolean myFullScreen;
        private long myTimeStamp;

        private CachedState() {
        }

        <T> T get(@NotNull Class<T> type, @Nullable Rectangle screen) {
            Point location = (Point)WindowStateServiceImpl.apply(Point::new, this.myLocation);
            Dimension size = (Dimension)WindowStateServiceImpl.apply(Dimension::new, this.mySize);
            if (this.myScreen != null && screen != null && !screen.isEmpty()) {
                double w = this.myScreen.getWidth() / screen.getWidth();
                double h = this.myScreen.getHeight() / screen.getHeight();
                if (location != null) {
                    location.setLocation((double)screen.x + (double)(location.x - this.myScreen.x) / w, (double)screen.y + (double)(location.y - this.myScreen.y) / h);
                }
                if (size != null) {
                    size.setSize((double)size.width / w, (double)size.height / h);
                }
                if (!WindowStateServiceImpl.isVisible(location, size)) {
                    return null;
                }
            }
            if (type == Point.class) {
                return (T)location;
            }
            if (type == Dimension.class) {
                return (T)size;
            }
            if (type == Rectangle.class) {
                return (T)(location == null || size == null ? null : new Rectangle(location, size));
            }
            if (type != WindowState.class) {
                throw new IllegalArgumentException();
            }
            WindowStateBean state = new WindowStateBean();
            state.setLocation(location);
            state.setSize(size);
            state.setExtendedState(this.myMaximized ? 6 : 0);
            state.setFullScreen(this.myFullScreen);
            return (T)state;
        }

        private boolean set(Point location, boolean locationSet, Dimension size, boolean sizeSet, boolean maximized, boolean maximizedSet, boolean fullScreen, boolean fullScreenSet) {
            if (locationSet) {
                this.myLocation = (Point)WindowStateServiceImpl.apply(Point::new, location);
            }
            if (sizeSet) {
                this.mySize = (Dimension)WindowStateServiceImpl.apply(Dimension::new, size);
            }
            if (maximizedSet) {
                this.myMaximized = maximized;
            }
            if (fullScreenSet) {
                this.myFullScreen = fullScreen;
            }
            if (this.myLocation == null && this.mySize == null) {
                return false;
            }
            this.myTimeStamp = System.currentTimeMillis();
            return true;
        }

        void updateScreenRectangle(@Nullable GraphicsConfiguration configuration) {
            this.myScreen = this.myLocation == null ? WindowStateServiceImpl.getScreenRectangle(configuration) : (this.mySize == null ? ScreenUtil.getScreenRectangle((Point)this.myLocation) : ScreenUtil.getScreenRectangle((int)(this.myLocation.x + this.mySize.width / 2), (int)(this.myLocation.y + this.mySize.height / 2)));
        }
    }
}

