/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateResult;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0002J(\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u001e\u0010\"\u001a\u00020!2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J#\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010&J)\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateInstaller;", "", "()V", "PATCH_FILE_NAME", "", "UPDATER_ENTRY", "UPDATER_MAIN_CLASS", "patchesUrl", "Ljava/net/URL;", "getPatchesUrl", "()Ljava/net/URL;", "cleanupPatch", "", "downloadPatchChain", "", "Ljava/io/File;", "chain", "Lcom/intellij/openapi/util/BuildNumber;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "downloadPluginUpdates", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "downloaders", "", "findLib", "libName", "getJdkSuffix", "getTempDir", "installDownloadedPluginUpdates", "Lcom/intellij/openapi/updateSettings/impl/PluginUpdateResult;", "ownerComponent", "Ljavax/swing/JComponent;", "allowInstallWithoutRestart", "", "installPluginUpdates", "preparePatchCommand", "", "patchFile", "(Ljava/io/File;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "patchFiles", "(Ljava/util/List;Lcom/intellij/openapi/progress/ProgressIndicator;)[Ljava/lang/String;", "intellij.platform.ide.impl"})
public final class UpdateInstaller {
    @NotNull
    public static final String UPDATER_MAIN_CLASS = "com.intellij.updater.Runner";
    private static final String PATCH_FILE_NAME = "patch-file.zip";
    private static final String UPDATER_ENTRY = "com/intellij/updater/Runner.class";
    public static final UpdateInstaller INSTANCE;

    private final URL getPatchesUrl() {
        String string = System.getProperty("idea.patches.url");
        if (string == null) {
            ApplicationInfoEx.UpdateUrls updateUrls = ApplicationInfoEx.getInstanceEx().getUpdateUrls();
            if (updateUrls == null) {
                Intrinsics.throwNpe();
            }
            string = updateUrls.getPatchesUrl();
        }
        return new URL(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<File> downloadPatchChain(@NotNull List<BuildNumber> chain, @NotNull ProgressIndicator indicator) throws IOException {
        indicator.setText(IdeBundle.message((String)"update.downloading.patch.progress", (Object[])new Object[0]));
        boolean bl = false;
        List files2 = new ArrayList();
        String product = ApplicationInfo.getInstance().getBuild().getProductCode();
        String jdk = INSTANCE.getJdkSuffix();
        double share = 1.0 / (double)(chain.size() - 1);
        int n = 1;
        int n2 = chain.size();
        while (n < n2) {
            void i2;
            String from = chain.get((int)(i2 - true)).withoutProductCode().asString();
            String to = chain.get((int)i2).withoutProductCode().asString();
            String patchName = product + '-' + from + '-' + to + "-patch-" + PatchInfo.Companion.getOS_SUFFIX() + ".jar";
            File patchFile = new File(INSTANCE.getTempDir(), patchName);
            String url = new URL(INSTANCE.getPatchesUrl(), patchName).toString();
            DelegatingProgressIndicator partIndicator2 = new DelegatingProgressIndicator((int)i2, share, indicator, indicator){
                final /* synthetic */ int $i;
                final /* synthetic */ double $share;
                final /* synthetic */ ProgressIndicator $indicator;

                public void setFraction(double fraction) {
                    super.setFraction((double)(this.$i - 1) * this.$share + fraction / this.$share);
                }
                {
                    this.$i = $captured_local_variable$0;
                    this.$share = $captured_local_variable$1;
                    this.$indicator = $captured_local_variable$2;
                    super($super_call_param$3);
                }
            };
            HttpRequests.request((String)url).gzip(false).saveToFile(patchFile, (ProgressIndicator)partIndicator2);
            Object object = new ZipFile(patchFile);
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                ZipFile it = (ZipFile)object;
                boolean bl4 = false;
                if (it.getEntry(PATCH_FILE_NAME) == null || it.getEntry(UPDATER_ENTRY) == null) {
                    throw (Throwable)new IOException("Corrupted patch file: " + patchFile.getName());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = files2;
            bl2 = false;
            object.add(patchFile);
            ++i2;
        }
        return files2;
    }

    @JvmStatic
    @NotNull
    public static final List<PluginDownloader> downloadPluginUpdates(@NotNull Collection<PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        indicator.setText(IdeBundle.message((String)"update.downloading.plugins.progress", (Object[])new Object[0]));
        UpdateChecker.saveDisabledToUpdatePlugins();
        Set<PluginId> disabledToUpdate = UpdateChecker.getDisabledToUpdate();
        boolean bl = false;
        List readyToInstall = new ArrayList();
        for (PluginDownloader downloader : downloaders) {
            try {
                if (!disabledToUpdate.contains(downloader.getId()) && downloader.prepareToInstall(indicator)) {
                    Collection collection = readyToInstall;
                    boolean bl2 = false;
                    collection.add(downloader);
                }
                indicator.checkCanceled();
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                Logger.getInstance(UpdateChecker.class).info((Throwable)e);
            }
        }
        return readyToInstall;
    }

    @JvmStatic
    @NotNull
    public static final PluginUpdateResult installDownloadedPluginUpdates(@NotNull Collection<PluginDownloader> downloaders, @Nullable JComponent ownerComponent, boolean allowInstallWithoutRestart) {
        boolean bl = false;
        List pluginsInstalled = new ArrayList();
        boolean restartRequired = false;
        for (PluginDownloader downloader : downloaders) {
            try {
                if (!allowInstallWithoutRestart || !downloader.tryInstallWithoutRestart(ownerComponent)) {
                    downloader.install();
                    restartRequired = true;
                }
                pluginsInstalled.add(downloader.getDescriptor());
            }
            catch (Exception e) {
                Logger.getInstance(UpdateChecker.class).info((Throwable)e);
            }
        }
        return new PluginUpdateResult(pluginsInstalled, restartRequired);
    }

    @JvmStatic
    public static final boolean installPluginUpdates(@NotNull Collection<PluginDownloader> downloaders, @NotNull ProgressIndicator indicator) {
        List<PluginDownloader> downloadedPluginUpdates = UpdateInstaller.downloadPluginUpdates(downloaders, indicator);
        PluginUpdateResult result2 = (PluginUpdateResult)ProgressManager.getInstance().computeInNonCancelableSection((ThrowableComputable)new ThrowableComputable<PluginUpdateResult, RuntimeException>(downloadedPluginUpdates){
            final /* synthetic */ List $downloadedPluginUpdates;

            public final PluginUpdateResult compute() {
                return UpdateInstaller.installDownloadedPluginUpdates(this.$downloadedPluginUpdates, null, false);
            }
            {
                this.$downloadedPluginUpdates = list2;
            }
        });
        Collection collection = result2.getPluginsInstalled();
        boolean bl = false;
        return !collection.isEmpty();
    }

    @JvmStatic
    public static final void cleanupPatch() {
        File tempDir = INSTANCE.getTempDir();
        if (tempDir.exists()) {
            FileUtil.delete((File)tempDir);
        }
    }

    @JvmStatic
    @NotNull
    public static final String[] preparePatchCommand(@NotNull File patchFile, @NotNull ProgressIndicator indicator) throws IOException {
        return UpdateInstaller.preparePatchCommand(CollectionsKt.listOf((Object)patchFile), indicator);
    }

    @JvmStatic
    @NotNull
    public static final String[] preparePatchCommand(@NotNull List<? extends File> patchFiles, @NotNull ProgressIndicator indicator) throws IOException {
        Number number;
        Object object;
        Path idePath;
        indicator.setText(IdeBundle.message((String)"update.preparing.patch.progress", (Object[])new Object[0]));
        File log4j = INSTANCE.findLib("log4j.jar");
        File jna = INSTANCE.findLib("jna.jar");
        File jnaUtils = INSTANCE.findLib("jna-platform.jar");
        File tempDir = INSTANCE.getTempDir();
        if (FileUtil.isAncestor((String)PathManager.getHomePath(), (String)tempDir.getPath(), (boolean)true)) {
            throw (Throwable)new IOException("Temp directory inside installation: " + tempDir);
        }
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw (Throwable)new IOException("Cannot create temp directory: " + tempDir);
        }
        File log4jCopy = FilesKt.copyTo$default((File)log4j, (File)new File(tempDir, log4j.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaCopy = FilesKt.copyTo$default((File)jna, (File)new File(tempDir, jna.getName()), (boolean)true, (int)0, (int)4, null);
        File jnaUtilsCopy = FilesKt.copyTo$default((File)jnaUtils, (File)new File(tempDir, jnaUtils.getName()), (boolean)true, (int)0, (int)4, null);
        String java = System.getProperty("java.home");
        Path jrePath = Paths.get(java, new String[0]);
        if (jrePath.startsWith(idePath = Paths.get(PathManager.getHomePath(), new String[0]).toRealPath(new LinkOption[0]))) {
            File javaCopy = new File(tempDir, "jre");
            if (javaCopy.exists()) {
                FileUtil.delete((File)javaCopy);
            }
            FileUtil.copyDir((File)new File(java), (File)javaCopy);
            java = javaCopy.getPath();
        }
        boolean bl = false;
        List args = new ArrayList();
        if (SystemInfo.isWindows && !Files.isWritable(Paths.get(PathManager.getHomePath(), new String[0]))) {
            Path launcher = PathManager.findBinFile((String)"launcher.exe");
            Path elevator = PathManager.findBinFile((String)"elevator.exe");
            if (launcher != null && elevator != null && Files.isExecutable(launcher) && Files.isExecutable(elevator)) {
                args.add(((Object)PathKt.copy((Path)launcher, (Path)tempDir.toPath().resolve(launcher.getFileName()))).toString());
                PathKt.copy((Path)elevator, (Path)tempDir.toPath().resolve(elevator.getFileName()));
            }
        }
        String string = System.getProperty("idea.updater.heap");
        if (string != null) {
            object = string;
            boolean bl2 = false;
            number = Integer.parseInt((String)object);
        } else {
            number = SystemInfo.is32Bit ? Runtime.getRuntime().maxMemory() >> 20 : 2000L;
        }
        Number mx = number;
        object = args;
        String string2 = new File(java, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java").getPath();
        boolean bl3 = false;
        object.add(string2);
        object = args;
        string2 = "-Xmx" + mx + 'm';
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = "-cp";
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = ArraysKt.joinToString$default((Object[])new String[]{((File)CollectionsKt.last(patchFiles)).getPath(), log4jCopy.getPath(), jnaCopy.getPath(), jnaUtilsCopy.getPath()}, (CharSequence)File.pathSeparator, null, null, (int)0, null, null, (int)62, null);
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = "-Djna.nosys=true";
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = "-Djna.boot.library.path=";
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = "-Djna.debug_load=true";
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = "-Djna.debug_load.jna=true";
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = "-Djava.io.tmpdir=" + tempDir.getPath();
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = "-Didea.updater.log=" + PathManager.getLogPath();
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = "-Dswing.defaultlaf=" + UIManager.getSystemLookAndFeelClassName();
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = UPDATER_MAIN_CLASS;
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = patchFiles.size() == 1 ? "install" : "batch-install";
        bl3 = false;
        object.add(string2);
        object = args;
        string2 = PathManager.getHomePath();
        bl3 = false;
        object.add(string2);
        if (patchFiles.size() > 1) {
            object = args;
            string2 = CollectionsKt.joinToString$default((Iterable)patchFiles, (CharSequence)File.pathSeparator, null, null, (int)0, null, null, (int)62, null);
            bl3 = false;
            object.add(string2);
        }
        return ArrayUtil.toStringArray((Collection)args);
    }

    private final File findLib(String libName) {
        File libFile = new File(PathManager.getLibPath(), libName);
        if (!libFile.exists()) {
            throw (Throwable)new IOException("Missing: " + libFile);
        }
        return libFile;
    }

    private final File getTempDir() {
        return new File(PathManager.getTempPath(), "patch-update");
    }

    private final String getJdkSuffix() {
        return !SystemInfo.isMac && Files.isDirectory(Paths.get(PathManager.getHomePath(), "jbr-x86"), new LinkOption[0]) ? "-jbr11-x86" : (Files.isDirectory(Paths.get(PathManager.getHomePath(), "jbr"), new LinkOption[0]) ? "-jbr11" : "-no-jbr");
    }

    private UpdateInstaller() {
    }

    static {
        UpdateInstaller updateInstaller;
        INSTANCE = updateInstaller = new UpdateInstaller();
    }
}

