/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PathMacro;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.StageInfo;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.ui.playback.commands.AssertFocused;
import com.intellij.openapi.ui.playback.commands.CallCommand;
import com.intellij.openapi.ui.playback.commands.CdCommand;
import com.intellij.openapi.ui.playback.commands.DelayCommand;
import com.intellij.openapi.ui.playback.commands.EmptyCommand;
import com.intellij.openapi.ui.playback.commands.ErrorCommand;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.openapi.ui.playback.commands.KeyShortcutCommand;
import com.intellij.openapi.ui.playback.commands.PopStage;
import com.intellij.openapi.ui.playback.commands.PrintCommand;
import com.intellij.openapi.ui.playback.commands.PushStage;
import com.intellij.openapi.ui.playback.commands.RegistryValueCommand;
import com.intellij.openapi.ui.playback.commands.StopCommand;
import com.intellij.openapi.ui.playback.commands.ToggleActionCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.StringTokenizer;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class PlaybackRunner {
    private static final Logger LOG = Logger.getInstance(PlaybackRunner.class);
    private Robot myRobot;
    private final String myScript;
    private final StatusCallback myCallback;
    private final ArrayList<PlaybackCommand> myCommands = new ArrayList();
    private ActionCallback myActionCallback;
    private boolean myStopRequested;
    private final boolean myUseDirectActionCall;
    private final boolean myUseTypingTargets;
    private File myScriptDir;
    private final boolean myStopOnAppDeactivation;
    private final ApplicationActivationListener myAppListener;
    private final HashSet<Class<?>> myFacadeClasses = new HashSet();
    private final ArrayList<StageInfo> myCurrentStageDepth = new ArrayList();
    private final ArrayList<StageInfo> myPassedStages = new ArrayList();
    private long myContextTimestamp;
    private final Map<String, String> myRegistryValues = new HashMap<String, String>();
    protected final Disposable myOnStop = Disposer.newDisposable();

    public PlaybackRunner(String script, StatusCallback callback2, boolean useDirectActionCall, boolean stopOnAppDeactivation, boolean useTypingTargets) {
        this.myScript = script;
        this.myCallback = callback2;
        this.myUseDirectActionCall = useDirectActionCall;
        this.myUseTypingTargets = useTypingTargets;
        this.myStopOnAppDeactivation = stopOnAppDeactivation;
        this.myAppListener = new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (PlaybackRunner.this.myStopOnAppDeactivation) {
                    PlaybackRunner.this.myCallback.message(null, "App lost focus, stopping...", StatusCallback.Type.message);
                    PlaybackRunner.this.stop();
                }
            }
        };
    }

    public ActionCallback run() {
        this.myStopRequested = false;
        this.myRegistryValues.clear();
        UiActivityMonitor activityMonitor = UiActivityMonitor.getInstance();
        activityMonitor.clear();
        activityMonitor.setActive(true);
        this.myCurrentStageDepth.clear();
        this.myPassedStages.clear();
        ++this.myContextTimestamp;
        this.subscribeListeners(ApplicationManager.getApplication().getMessageBus().connect(this.myOnStop));
        Disposer.register((Disposable)this.myOnStop, () -> this.onStop());
        try {
            this.myActionCallback = new ActionCallback();
            this.myActionCallback.doWhenProcessed(() -> {
                Disposer.dispose((Disposable)this.myOnStop);
                SwingUtilities.invokeLater(() -> {
                    activityMonitor.setActive(false);
                    this.restoreRegistryValues();
                });
            });
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                this.myRobot = new Robot();
            }
            this.parse();
            new Thread("playback runner"){

                @Override
                public void run() {
                    if (PlaybackRunner.this.myUseDirectActionCall) {
                        PlaybackRunner.this.executeFrom(0, PlaybackRunner.this.getScriptDir());
                    } else {
                        IdeEventQueue.getInstance().doWhenReady(() -> PlaybackRunner.this.executeFrom(0, PlaybackRunner.this.getScriptDir()));
                    }
                }
            }.start();
        }
        catch (AWTException e) {
            LOG.error((Throwable)e);
        }
        return this.myActionCallback;
    }

    private void restoreRegistryValues() {
        Set<String> storedKeys = this.myRegistryValues.keySet();
        for (String each : storedKeys) {
            Registry.get((String)each).setValue(this.myRegistryValues.get(each));
        }
    }

    private void executeFrom(int cmdIndex, File baseDir) {
        if (cmdIndex < this.myCommands.size()) {
            PlaybackCommand cmd = this.myCommands.get(cmdIndex);
            if (this.myStopRequested) {
                this.myCallback.message(null, "Stopped", StatusCallback.Type.message);
                this.myActionCallback.setRejected();
                return;
            }
            Set facadeClassesClone = (Set)this.myFacadeClasses.clone();
            PlaybackContext context = new PlaybackContext(this, this.myCallback, cmdIndex, this.myRobot, this.myUseDirectActionCall, this.myUseTypingTargets, cmd, baseDir, facadeClassesClone){
                private final long myTimeStamp;
                {
                    this.myTimeStamp = PlaybackRunner.this.myContextTimestamp;
                }

                @Override
                public void pushStage(StageInfo info) {
                    PlaybackRunner.this.myCurrentStageDepth.add(info);
                }

                @Override
                public StageInfo popStage() {
                    if (PlaybackRunner.this.myCurrentStageDepth.size() > 0) {
                        return (StageInfo)PlaybackRunner.this.myCurrentStageDepth.remove(PlaybackRunner.this.myCurrentStageDepth.size() - 1);
                    }
                    return null;
                }

                @Override
                public int getCurrentStageDepth() {
                    return PlaybackRunner.this.myCurrentStageDepth.size();
                }

                @Override
                public void addPassed(StageInfo stage) {
                    PlaybackRunner.this.myPassedStages.add(stage);
                }

                @Override
                public boolean isDisposed() {
                    return this.myTimeStamp != PlaybackRunner.this.myContextTimestamp;
                }

                @Override
                public void storeRegistryValue(String key) {
                    if (!PlaybackRunner.this.myRegistryValues.containsKey(key)) {
                        PlaybackRunner.this.myRegistryValues.put(key, Registry.stringValue((String)key));
                    }
                }
            };
            Promise<Object> cmdCallback = cmd.execute(context);
            cmdCallback.onSuccess(it -> {
                if (cmd.canGoFurther()) {
                    this.executeFrom(cmdIndex + 1, context.getBaseDir());
                } else {
                    this.myCallback.message(null, "Stopped: cannot go further", StatusCallback.Type.message);
                    this.myActionCallback.setDone();
                }
            }).onError(error -> {
                this.myCallback.message(null, "Stopped: " + error, StatusCallback.Type.message);
                LOG.warn("Callback step stopped with error: " + error, error);
                this.myActionCallback.setRejected();
            });
        } else {
            this.myCallback.message(null, "Finished OK " + this.myPassedStages.size() + " tests", StatusCallback.Type.message);
            this.myActionCallback.setDone();
        }
    }

    protected void subscribeListeners(MessageBusConnection connection) {
        connection.subscribe(ApplicationActivationListener.TOPIC, (Object)this.myAppListener);
    }

    protected void onStop() {
        this.myCommands.clear();
    }

    private void parse() {
        this.includeScript(this.myScript, this.getScriptDir(), this.myCommands, 0);
    }

    private void includeScript(String scriptText, File scriptDir, ArrayList<? super PlaybackCommand> commandList, int line) {
        StringTokenizer tokens = new StringTokenizer(scriptText, "\n");
        while (tokens.hasMoreTokens()) {
            String eachLine = tokens.nextToken();
            String includeCmd = "%include";
            String importCallCmd = "%importCall";
            if (eachLine.startsWith(includeCmd)) {
                File file2 = new PathMacro().setScriptDir(scriptDir).resolveFile(eachLine.substring(includeCmd.length()).trim(), scriptDir);
                if (!file2.exists()) {
                    commandList.add(new ErrorCommand("Cannot find file to include: " + file2.getAbsolutePath(), line));
                    return;
                }
                try {
                    String include = FileUtil.loadFile((File)file2);
                    this.myCommands.add(new PrintCommand(eachLine, line));
                    this.includeScript(include, file2.getParentFile(), commandList, 0);
                    continue;
                }
                catch (IOException e) {
                    commandList.add(new ErrorCommand("Error reading file: " + file2.getAbsolutePath(), line));
                    return;
                }
            }
            if (eachLine.startsWith(importCallCmd)) {
                String className = eachLine.substring(importCallCmd.length()).trim();
                try {
                    Class<?> facadeClass = Class.forName(className);
                    this.myFacadeClasses.add(facadeClass);
                    this.myCommands.add(new PrintCommand(eachLine, line++));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    commandList.add(new ErrorCommand("Cannot find class: " + className, line));
                    return;
                }
            }
            PlaybackCommand cmd = this.createCommand(eachLine, line++, scriptDir);
            commandList.add(cmd);
        }
    }

    protected PlaybackCommand createCommand(String string, int line, File scriptDir) {
        AbstractCommand cmd;
        if (string.startsWith("%set")) {
            cmd = new RegistryValueCommand(string, line);
        } else if (string.startsWith("%%")) {
            cmd = new EmptyCommand(line);
        } else if (string.startsWith("%type")) {
            cmd = new KeyCodeTypeCommand(string, line);
        } else if (string.startsWith("%delay")) {
            cmd = new DelayCommand(string, line);
        } else if (string.startsWith("%[")) {
            cmd = new KeyShortcutCommand(string, line);
        } else if (string.startsWith("%action")) {
            cmd = new ActionCommand(string, line);
        } else if (string.startsWith("%toggle")) {
            cmd = new ToggleActionCommand(string, line);
        } else if (string.startsWith("%stop")) {
            cmd = new StopCommand(string, line);
        } else {
            if (string.startsWith("%assert focused")) {
                return new AssertFocused(string, line);
            }
            cmd = string.startsWith("%call") ? new CallCommand(string, line) : (string.startsWith("%cd") ? new CdCommand(string, line) : (string.startsWith("%startTest") ? new PushStage(string, line) : (string.startsWith("%endTest") ? new PopStage(string, line) : new AlphaNumericTypeCommand(string, line))));
        }
        cmd.setScriptDir(scriptDir);
        return cmd;
    }

    public void stop() {
        this.myStopRequested = true;
    }

    public File getScriptDir() {
        return this.myScriptDir != null ? this.myScriptDir : new File(System.getProperty("user.dir"));
    }

    public void setScriptDir(File baseDir) {
        this.myScriptDir = baseDir;
    }

    public static interface StatusCallback {
        public void message(@Nullable PlaybackContext var1, String var2, Type var3);

        public static abstract class Edt
        implements StatusCallback {
            @Override
            public final void message(PlaybackContext context, String text, Type type) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.messageEdt(context, text, type);
                } else {
                    SwingUtilities.invokeLater(() -> this.messageEdt(context, text, type));
                }
            }

            public abstract void messageEdt(@Nullable PlaybackContext var1, String var2, Type var3);
        }

        public static enum Type {
            message,
            error,
            code,
            test;

        }
    }
}

