/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowWrapperBuilder {
    @NotNull
    private final WindowWrapper.Mode myMode;
    @NotNull
    private final JComponent myComponent;
    @Nullable
    private Project myProject;
    @Nullable
    private Component myParent;
    @Nullable
    private String title;
    @Nullable
    private Computable<JComponent> myPreferredFocusedComponent;
    @Nullable
    private String myDimensionServiceKey;
    @Nullable
    private Runnable myOnShowCallback;
    @Nullable
    private BooleanGetter myOnCloseHandler;

    public WindowWrapperBuilder(@NotNull WindowWrapper.Mode mode, @NotNull JComponent component2) {
        this.myMode = mode;
        this.myComponent = component2;
    }

    @NotNull
    public WindowWrapperBuilder setProject(@Nullable Project project) {
        this.myProject = project;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setParent(@Nullable Component parent) {
        this.myParent = parent;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setPreferredFocusedComponent(@Nullable JComponent preferredFocusedComponent) {
        this.myPreferredFocusedComponent = new Computable.PredefinedValueComputable((Object)preferredFocusedComponent);
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setPreferredFocusedComponent(@Nullable Computable<JComponent> computable) {
        this.myPreferredFocusedComponent = computable;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setDimensionServiceKey(@Nullable @NonNls String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setOnShowCallback(@NotNull Runnable callback2) {
        this.myOnShowCallback = callback2;
        return this;
    }

    @NotNull
    public WindowWrapperBuilder setOnCloseHandler(@NotNull BooleanGetter handler2) {
        this.myOnCloseHandler = handler2;
        return this;
    }

    @NotNull
    public WindowWrapper build() {
        switch (this.myMode) {
            case FRAME: {
                return new FrameWindowWrapper(this);
            }
            case MODAL: 
            case NON_MODAL: {
                return new DialogWindowWrapper(this);
            }
        }
        throw new IllegalArgumentException(this.myMode.toString());
    }

    private static void installOnShowCallback(@Nullable Window window, @Nullable Runnable onShowCallback) {
        if (window == null || onShowCallback == null) {
            return;
        }
        UIUtil.runWhenWindowOpened((Window)window, (Runnable)onShowCallback);
    }

    private static class FrameWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @Nullable
        private final Runnable myOnShowCallback;
        @NotNull
        private final MyFrameWrapper myFrame;

        FrameWindowWrapper(@NotNull WindowWrapperBuilder builder2) {
            assert (builder2.myMode == WindowWrapper.Mode.FRAME);
            this.myProject = builder2.myProject;
            this.myComponent = builder2.myComponent;
            this.myMode = builder2.myMode;
            this.myFrame = new MyFrameWrapper(builder2.myProject, builder2.myDimensionServiceKey);
            this.myFrame.setParameters((Computable<? extends JComponent>)builder2.myPreferredFocusedComponent);
            this.myFrame.setOnCloseHandler(builder2.myOnCloseHandler);
            this.myOnShowCallback = builder2.myOnShowCallback;
            this.myFrame.setComponent(builder2.myComponent);
            this.myFrame.setTitle(builder2.title == null ? "" : builder2.title);
            this.myFrame.closeOnEsc();
            Disposer.register((Disposable)this.myFrame, (Disposable)this);
        }

        public void show() {
            Disposable tb = TouchBarsManager.showDialogWrapperButtons(this.myComponent);
            if (tb != null) {
                Disposer.register((Disposable)this.myFrame, (Disposable)tb);
            }
            this.myFrame.show();
            if (this.myOnShowCallback != null) {
                this.myOnShowCallback.run();
            }
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            return this.myComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            return this.myMode;
        }

        @NotNull
        public Window getWindow() {
            return this.myFrame.getFrame();
        }

        public void setTitle(@Nullable String title) {
            title = StringUtil.notNullize((String)title);
            this.myFrame.setTitle(title);
            Window window = this.getWindow();
            if (window instanceof JFrame) {
                ((JFrame)window).setTitle(title);
            } else if (window instanceof JDialog) {
                ((JDialog)window).setTitle(title);
            }
        }

        public void setImages(@Nullable List<? extends Image> images) {
            this.myFrame.setImages(images);
        }

        public void close() {
            this.myFrame.close();
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myFrame);
        }

        private static class MyFrameWrapper
        extends FrameWrapper {
            private Computable<? extends JComponent> myPreferredFocusedComponent;

            MyFrameWrapper(Project project, @Nullable @NonNls String dimensionServiceKey) {
                super(project, dimensionServiceKey);
            }

            public void setParameters(@Nullable Computable<? extends JComponent> preferredFocusedComponent) {
                this.myPreferredFocusedComponent = preferredFocusedComponent;
            }

            @Override
            public void dispose() {
                this.myPreferredFocusedComponent = null;
                super.dispose();
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                if (this.myPreferredFocusedComponent != null) {
                    return (JComponent)this.myPreferredFocusedComponent.compute();
                }
                return super.getPreferredFocusedComponent();
            }
        }
    }

    private static class DialogWindowWrapper
    implements WindowWrapper {
        @Nullable
        private final Project myProject;
        @NotNull
        private final JComponent myComponent;
        @NotNull
        private final WindowWrapper.Mode myMode;
        @NotNull
        private final MyDialogWrapper myDialog;

        DialogWindowWrapper(@NotNull WindowWrapperBuilder builder2) {
            this.myProject = builder2.myProject;
            this.myComponent = builder2.myComponent;
            this.myMode = builder2.myMode;
            this.myDialog = builder2.myParent != null ? new MyDialogWrapper(builder2.myParent, builder2.myComponent) : new MyDialogWrapper(builder2.myProject, builder2.myComponent);
            this.myDialog.setParameters(builder2.myDimensionServiceKey, (Computable<? extends JComponent>)builder2.myPreferredFocusedComponent, builder2.myOnCloseHandler);
            WindowWrapperBuilder.installOnShowCallback(this.myDialog.getWindow(), builder2.myOnShowCallback);
            this.setTitle(builder2.title);
            switch (builder2.myMode) {
                case MODAL: {
                    this.myDialog.setModal(true);
                    break;
                }
                case NON_MODAL: {
                    this.myDialog.setModal(false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.myDialog.init();
            Disposer.register((Disposable)this.myDialog.getDisposable(), (Disposable)this);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myDialog.getDisposable());
        }

        public void show() {
            this.myDialog.show();
        }

        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @NotNull
        public JComponent getComponent() {
            return this.myComponent;
        }

        @NotNull
        public WindowWrapper.Mode getMode() {
            return this.myMode;
        }

        @NotNull
        public Window getWindow() {
            return this.myDialog.getWindow();
        }

        public void setTitle(@Nullable String title) {
            this.myDialog.setTitle(StringUtil.notNullize((String)title));
        }

        public void setImages(@Nullable List<? extends Image> images) {
        }

        public void close() {
            this.myDialog.close(1);
        }

        private static class MyDialogWrapper
        extends DialogWrapper {
            @NotNull
            private final JComponent myComponent;
            @Nullable
            private String myDimensionServiceKey;
            @Nullable
            private Computable<? extends JComponent> myPreferredFocusedComponent;
            @Nullable
            private BooleanGetter myOnCloseHandler;

            MyDialogWrapper(@Nullable Project project, @NotNull JComponent component2) {
                super(project, true);
                this.myComponent = component2;
            }

            MyDialogWrapper(@NotNull Component parent, @NotNull JComponent component2) {
                super(parent, true);
                this.myComponent = component2;
            }

            public void setParameters(@Nullable String dimensionServiceKey, @Nullable Computable<? extends JComponent> preferredFocusedComponent, @Nullable BooleanGetter onCloseHandler) {
                this.myDimensionServiceKey = dimensionServiceKey;
                this.myPreferredFocusedComponent = preferredFocusedComponent;
                this.myOnCloseHandler = onCloseHandler;
            }

            @Nullable
            protected Border createContentPaneBorder() {
                return null;
            }

            protected JComponent createCenterPanel() {
                return this.myComponent;
            }

            protected Action @NotNull [] createActions() {
                return new Action[0];
            }

            @Nullable
            protected JComponent createSouthPanel() {
                return null;
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return this.myDimensionServiceKey;
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                if (this.myPreferredFocusedComponent != null) {
                    return (JComponent)this.myPreferredFocusedComponent.compute();
                }
                return super.getPreferredFocusedComponent();
            }

            public void doCancelAction() {
                if (this.myOnCloseHandler != null && !this.myOnCloseHandler.get()) {
                    return;
                }
                super.doCancelAction();
            }
        }
    }
}

