/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;

public final class SourceRootPresentation {
    @NotNull
    public static Icon getSourceRootIcon(@NotNull SourceFolder sourceFolder) {
        return SourceRootPresentation.getSourceRootIcon(sourceFolder.getJpsElement().asTyped());
    }

    @Nullable
    public static Icon getSourceRootFileLayerIcon(@NotNull SourceFolder sourceFolder) {
        return SourceRootPresentation.getSourceRootFileLayerIcon(sourceFolder.getJpsElement().asTyped());
    }

    @NotNull
    private static <P extends JpsElement> Icon getSourceRootIcon(@NotNull JpsTypedModuleSourceRoot<P> root) {
        ModuleSourceRootEditHandler<JpsElement> handler2 = ModuleSourceRootEditHandler.getEditHandler(root.getRootType());
        return handler2 != null ? handler2.getRootIcon(root.getProperties()) : PlatformIcons.FOLDER_ICON;
    }

    @Nullable
    private static <P extends JpsElement> Icon getSourceRootFileLayerIcon(@NotNull JpsTypedModuleSourceRoot<P> root) {
        ModuleSourceRootEditHandler<JpsElement> handler2 = ModuleSourceRootEditHandler.getEditHandler(root.getRootType());
        return handler2 != null ? handler2.getRootFileLayerIcon(root.getProperties()) : null;
    }
}

