/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.ui.ComboBoxPopupState;
import com.intellij.util.Producer;
import java.util.List;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkListModel
extends AbstractListModel<SdkListItem>
implements ComboBoxPopupState<SdkListItem> {
    private final boolean myIsSearching;
    private final ImmutableList<SdkListItem> myItems;
    private final Producer<? extends Sdk> myGetProjectSdk;
    private final ImmutableMap<SdkListItem, String> mySeparators;

    @NotNull
    public static SdkListModel emptyModel() {
        return new SdkListModel(false, (List<? extends SdkListItem>)ImmutableList.of(), (Producer<? extends Sdk>)((Producer)() -> null));
    }

    SdkListModel(boolean isSearching, @NotNull List<? extends SdkListItem> items, @NotNull Producer<? extends Sdk> getProjectSdk) {
        this.myIsSearching = isSearching;
        this.myItems = ImmutableList.copyOf(items);
        this.myGetProjectSdk = getProjectSdk;
        boolean myFirstSepSet = false;
        boolean mySuggestedSep = false;
        ImmutableMap.Builder sep = ImmutableMap.builder();
        int lastSepIndex = 0;
        for (int i2 = 0; i2 < this.myItems.size(); ++i2) {
            SdkListItem it = (SdkListItem)this.myItems.get(i2);
            if (!myFirstSepSet && (it instanceof SdkListItem.GroupItem || it instanceof SdkListItem.ActionItem)) {
                myFirstSepSet = true;
                if (lastSepIndex < i2) {
                    sep.put((Object)it, (Object)"");
                    lastSepIndex = i2;
                }
            }
            if (mySuggestedSep || !(it instanceof SdkListItem.SuggestedItem)) continue;
            mySuggestedSep = true;
            if (lastSepIndex >= i2) continue;
            sep.put((Object)it, (Object)ProjectBundle.message((String)"jdk.combo.box.autodetected", (Object[])new Object[0]));
            lastSepIndex = i2;
        }
        this.mySeparators = sep.build();
    }

    @Nullable
    public SdkListItem findProjectSdkItem() {
        return this.findFirstItemOfType(SdkListItem.ProjectSdkItem.class);
    }

    @Nullable
    public SdkListItem findNoneSdkItem() {
        return this.findFirstItemOfType(SdkListItem.NoneSdkItem.class);
    }

    @Nullable
    private SdkListItem findFirstItemOfType(Class<? extends SdkListItem> itemClass) {
        return this.getItems().stream().filter(itemClass::isInstance).findFirst().orElse(null);
    }

    @Nullable
    Sdk resolveProjectSdk() {
        return (Sdk)this.myGetProjectSdk.produce();
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    @NotNull
    public SdkListItem getElementAt(int index) {
        return (SdkListItem)this.myItems.get(index);
    }

    @Nullable
    public SdkListModel onChosen(SdkListItem selectedValue) {
        if (!(selectedValue instanceof SdkListItem.GroupItem)) {
            return null;
        }
        return new SdkListModel(this.myIsSearching, ((SdkListItem.GroupItem)selectedValue).mySubItems, this.myGetProjectSdk);
    }

    public boolean hasSubstep(SdkListItem selectedValue) {
        return selectedValue instanceof SdkListItem.GroupItem;
    }

    public boolean isSearching() {
        return this.myIsSearching;
    }

    @NotNull
    public List<SdkListItem> getItems() {
        return this.myItems;
    }

    @Nullable
    public String getSeparatorTextAbove(@NotNull SdkListItem value2) {
        return (String)this.mySeparators.get((Object)value2);
    }

    @Nullable
    public SdkListItem.SdkItem findSdkItem(@Nullable Sdk value2) {
        if (value2 == null) {
            return null;
        }
        for (SdkListItem item : this.myItems) {
            SdkListItem.SdkItem sdkItem;
            if (!(item instanceof SdkListItem.SdkItem) || !(sdkItem = (SdkListItem.SdkItem)item).hasSameSdk(value2)) continue;
            return sdkItem;
        }
        return null;
    }

    @Nullable
    public SdkListItem.SdkItem findSdkItem(@Nullable String sdkName) {
        if (sdkName == null) {
            return null;
        }
        for (SdkListItem item : this.myItems) {
            SdkListItem.SdkItem sdkItem;
            Sdk sdk2;
            if (!(item instanceof SdkListItem.SdkItem) || !sdkName.equals((sdk2 = (sdkItem = (SdkListItem.SdkItem)item).getSdk()).getName())) continue;
            return sdkItem;
        }
        return null;
    }
}

