/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.SdkListModel;
import com.intellij.openapi.roots.ui.configuration.SdkListModelBuilder;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.Container;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkComboBoxBase<T>
extends ComboBox<T> {
    private final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());
    @NotNull
    protected final SdkListModelBuilder myModel;

    protected SdkComboBoxBase(@NotNull SdkListModelBuilder model) {
        this.myModel = model;
        this.myModel.addModelListener(new SdkListModelBuilder.ModelListener(){

            @Override
            public void syncModel(@NotNull SdkListModel model) {
                SdkComboBoxBase.this.onModelUpdated(model);
            }
        });
        ComponentUtil.putClientProperty((JComponent)((Object)this), (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        this.setMinimumAndPreferredWidth(JBUI.scale((int)300));
        this.setMaximumRowCount(30);
        this.setSwingPopup(false);
        this.putClientProperty("ComboBox.jbPopup.supportUpdateModel", true);
    }

    protected abstract void onModelUpdated(@NotNull SdkListModel var1);

    public void setInvalidJdk(String name) {
        this.setSelectedItem(this.myModel.showInvalidSdkItem(name));
    }

    @NotNull
    public SdkListItem showInvalidSdkItem(@NotNull String name) {
        return this.myModel.showInvalidSdkItem(name);
    }

    @NotNull
    public SdkListItem showProjectSdkItem() {
        return this.myModel.showProjectSdkItem();
    }

    @NotNull
    public SdkListItem showNoneSdkItem() {
        return this.myModel.showNoneSdkItem();
    }

    @NotNull
    public SdkListItem addSdkReferenceItem(@NotNull SdkType type, @NotNull String name, @Nullable String versionString, boolean isValid) {
        return this.myModel.addSdkReferenceItem(type, name, versionString, isValid);
    }

    public void reloadModel() {
        this.myModel.reloadSdks();
    }

    @Deprecated
    public void addItem(T item) {
        this.LOG.warn("JdkComboBox#addItem() is deprecated!" + item, (Throwable)new RuntimeException());
    }

    @Deprecated
    public void insertItemAt(T item, int index) {
        this.LOG.warn("insertItemAt() is deprecated!" + item + " at " + index, (Throwable)new RuntimeException());
    }

    @Deprecated
    public void removeItem(Object anObject) {
        this.LOG.warn("removeItem() is deprecated!", (Throwable)new RuntimeException());
    }

    @Deprecated
    public void removeItemAt(int anIndex) {
        this.LOG.warn("removeItemAt() is deprecated!", (Throwable)new RuntimeException());
    }

    @Deprecated
    public void removeAllItems() {
        this.LOG.warn("removeAllItems() is deprecated!", (Throwable)new RuntimeException());
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSDKComboboxBaseDelegate(super.getAccessibleContext());
        }
        return this.accessibleContext;
    }

    private class AccessibleSDKComboboxBaseDelegate
    extends AccessibleContextDelegate {
        AccessibleSDKComboboxBaseDelegate(AccessibleContext context) {
            super(context);
        }

        protected Container getDelegateParent() {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return SdkComboBoxBase.this.getComponentCount();
        }
    }
}

