/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.LibrarySettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSettingsService {
    public static ProjectSettingsService getInstance(Project project) {
        return (ProjectSettingsService)ServiceManager.getService((Project)project, ProjectSettingsService.class);
    }

    public void openProjectSettings() {
    }

    public void openGlobalLibraries() {
    }

    public void openLibrary(@NotNull Library library) {
    }

    public void openModuleSettings(Module module) {
    }

    public boolean canOpenModuleSettings() {
        return false;
    }

    public void openModuleLibrarySettings(Module module) {
    }

    public boolean canOpenModuleLibrarySettings() {
        return false;
    }

    public void openContentEntriesSettings(Module module) {
    }

    public boolean canOpenContentEntriesSettings() {
        return false;
    }

    public void openModuleDependenciesSettings(@NotNull Module module, @Nullable OrderEntry orderEntry) {
    }

    public boolean canOpenModuleDependenciesSettings() {
        return false;
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        Configurable additionalSettingsConfigurable = ProjectSettingsService.getLibrarySettingsConfigurable(orderEntry);
        if (additionalSettingsConfigurable != null) {
            ShowSettingsUtil.getInstance().showSettingsDialog(orderEntry.getOwnerModule().getProject(), additionalSettingsConfigurable.getDisplayName());
        }
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        return ProjectSettingsService.getLibrarySettingsConfigurable(orderEntry) != null;
    }

    @Nullable
    private static Configurable getLibrarySettingsConfigurable(OrderEntry orderEntry) {
        if (!(orderEntry instanceof LibraryOrderEntry)) {
            return null;
        }
        LibraryOrderEntry libOrderEntry = (LibraryOrderEntry)orderEntry;
        Library lib = libOrderEntry.getLibrary();
        if (lib instanceof LibraryEx) {
            Project project = libOrderEntry.getOwnerModule().getProject();
            PersistentLibraryKind libKind = ((LibraryEx)lib).getKind();
            if (libKind != null) {
                return LibrarySettingsProvider.getAdditionalSettingsConfigurable(project, (LibraryKind)libKind);
            }
        }
        return null;
    }

    public boolean processModulesMoved(Module[] modules2, @Nullable ModuleGroup targetGroup) {
        return false;
    }

    public void showModuleConfigurationDialog(@Nullable String moduleToSelect, @Nullable String editorNameToSelect) {
    }

    @Deprecated
    @Nullable
    public Sdk chooseAndSetSdk() {
        Logger.getInstance(this.getClass()).warn("Call to the deprecated ProjectSettingsService#chooseAndSetSdk method. Please use new API instead");
        return null;
    }
}

