/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.DetectedRootsChooserDialog;
import com.intellij.openapi.roots.libraries.ui.impl.SuggestedChildRootInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RootDetectionUtil {
    private static final Logger LOG = Logger.getInstance(RootDetectionUtil.class);

    private RootDetectionUtil() {
    }

    @NotNull
    public static List<OrderRoot> detectRoots(@NotNull Collection<? extends VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project, @NotNull LibraryRootsComponentDescriptor rootsComponentDescriptor) {
        return RootDetectionUtil.detectRoots(rootCandidates, parentComponent, project, rootsComponentDescriptor.getRootsDetector(), rootsComponentDescriptor.getRootTypes());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static List<OrderRoot> detectRoots(final @NotNull Collection<? extends VirtualFile> rootCandidates, @Nullable Component parentComponent, @Nullable Project project, final @NotNull LibraryRootsDetector detector, OrderRootType @NotNull [] rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
        ArrayList<OrderRoot> result2;
        block10: {
            void var11_23;
            ArrayList<String> arrayList;
            HashMap<String, Pair> types;
            block11: {
                int answer;
                result2 = new ArrayList<OrderRoot>();
                final ArrayList<SuggestedChildRootInfo> suggestedRoots = new ArrayList<SuggestedChildRootInfo>();
                new Task.Modal(project, ProjectBundle.message((String)"progress.title.scanning.for.roots", (Object[])new Object[0]), true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        try {
                            for (VirtualFile rootCandidate : rootCandidates) {
                                Collection<DetectedLibraryRoot> roots = detector.detectRoots(rootCandidate, indicator);
                                if (!roots.isEmpty() && RootDetectionUtil.allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(roots, rootCandidate)) {
                                    for (DetectedLibraryRoot root : roots) {
                                        LibraryRootType libraryRootType = root.getTypes().get(0);
                                        result2.add(new OrderRoot(root.getFile(), libraryRootType.getType(), libraryRootType.isJarDirectory()));
                                    }
                                    continue;
                                }
                                for (DetectedLibraryRoot root : roots) {
                                    HashMap<LibraryRootType, String> names2 = new HashMap<LibraryRootType, String>();
                                    for (LibraryRootType type : root.getTypes()) {
                                        String typeName = detector.getRootTypeName(type);
                                        LOG.assertTrue(typeName != null, (Object)("Unexpected root type " + type.getType().name() + (type.isJarDirectory() ? " (JAR directory)" : "") + ", detectors: " + detector));
                                        names2.put(type, typeName);
                                    }
                                    suggestedRoots.add(new SuggestedChildRootInfo(rootCandidate, root, names2));
                                }
                            }
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                    }
                }.queue();
                if (!suggestedRoots.isEmpty()) {
                    DetectedRootsChooserDialog dialog2;
                    DetectedRootsChooserDialog detectedRootsChooserDialog = dialog2 = parentComponent != null ? new DetectedRootsChooserDialog(parentComponent, suggestedRoots) : new DetectedRootsChooserDialog(project, suggestedRoots);
                    if (!dialog2.showAndGet()) {
                        return Collections.emptyList();
                    }
                    for (SuggestedChildRootInfo suggestedChildRootInfo : dialog2.getChosenRoots()) {
                        LibraryRootType selectedRootType = suggestedChildRootInfo.getSelectedRootType();
                        result2.add(new OrderRoot(suggestedChildRootInfo.getDetectedRoot().getFile(), selectedRootType.getType(), selectedRootType.isJarDirectory()));
                    }
                }
                if (!result2.isEmpty() || rootTypesAllowedToBeSelectedByUserIfNothingIsDetected.length <= 0) break block10;
                types = new HashMap<String, Pair>();
                for (OrderRootType orderRootType : rootTypesAllowedToBeSelectedByUserIfNothingIsDetected) {
                    for (Object object : (LibraryRootType)new boolean[]{false, true}) {
                        String string = detector.getRootTypeName(new LibraryRootType(orderRootType, (boolean)object));
                        if (string == null) continue;
                        types.put(StringUtil.capitalizeWords((String)string, (boolean)true), Pair.create((Object)orderRootType, (Object)((boolean)object)));
                    }
                }
                LOG.assertTrue(!types.isEmpty(), (Object)("No allowed root types found for " + detector));
                arrayList = new ArrayList<String>(types.keySet());
                if (arrayList.size() != 1) break block11;
                String title = LangBundle.message((String)"dialog.title.attach.roots", (Object[])new Object[0]);
                String typeName = (String)arrayList.get(0);
                String string = LangBundle.message((String)"dialog.message.cannot.determine", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), typeName});
                int n = answer = parentComponent != null ? Messages.showYesNoDialog((Component)parentComponent, (String)string, (String)title, null) : Messages.showYesNoDialog((Project)project, (String)string, (String)title, null);
                if (answer != 0) break block10;
                Pair pair = (Pair)types.get(typeName);
                for (VirtualFile virtualFile : rootCandidates) {
                    result2.add(new OrderRoot(virtualFile, (OrderRootType)pair.getFirst(), (Boolean)pair.getSecond()));
                }
                break block10;
            }
            String title = LangBundle.message((String)"dialog.title.choose.categories.selected.files", (Object[])new Object[0]);
            String description = XmlStringUtil.wrapInHtml((CharSequence)(ApplicationNamesInfo.getInstance().getProductName() + " cannot determine what kind of files the chosen items contain.<br>Choose the appropriate categories from the list."));
            if (parentComponent != null) {
                ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(parentComponent, arrayList, title, description);
            } else {
                ChooseRootTypeElementsDialog chooseRootTypeElementsDialog = new ChooseRootTypeElementsDialog(project, (List<String>)arrayList, title, description);
            }
            for (String rootType : var11_23.showAndGetResult()) {
                Pair pair = (Pair)types.get(rootType);
                for (VirtualFile virtualFile : rootCandidates) {
                    result2.add(new OrderRoot(virtualFile, (OrderRootType)pair.getFirst(), (Boolean)pair.getSecond()));
                }
            }
        }
        return result2;
    }

    private static boolean allRootsHaveOneTypeAndEqualToOrAreDirectParentOf(Collection<? extends DetectedLibraryRoot> roots, VirtualFile candidate) {
        for (DetectedLibraryRoot detectedLibraryRoot : roots) {
            if (detectedLibraryRoot.getTypes().size() <= 1 && (detectedLibraryRoot.getFile().equals(candidate) || detectedLibraryRoot.getFile().equals(candidate.getParent()))) continue;
            return false;
        }
        return true;
    }

    private static class ChooseRootTypeElementsDialog
    extends ChooseElementsDialog<String> {
        ChooseRootTypeElementsDialog(Project project, List<String> names2, @NlsContexts.DialogTitle String title, @NlsContexts.Label String description) {
            super(project, names2, title, description, true);
        }

        private ChooseRootTypeElementsDialog(Component parent, List<String> names2, @NlsContexts.DialogTitle String title, @NlsContexts.Label String description) {
            super(parent, names2, title, description, true);
        }

        @Override
        protected String getItemText(String item) {
            return item;
        }

        @Override
        @Nullable
        protected Icon getItemIcon(String item) {
            return null;
        }
    }
}

