/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries.ui.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryRootsDetectorImpl
extends LibraryRootsDetector {
    private final List<? extends RootDetector> myDetectors;

    public LibraryRootsDetectorImpl(List<? extends RootDetector> detectors) {
        this.myDetectors = detectors;
    }

    @Override
    public Collection<DetectedLibraryRoot> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator2) {
        ArrayList<DetectedLibraryRoot> result2 = new ArrayList<DetectedLibraryRoot>();
        for (RootDetector rootDetector : this.myDetectors) {
            Collection<VirtualFile> files2 = rootDetector.detectRoots(rootCandidate, progressIndicator2);
            for (VirtualFile file2 : files2) {
                result2.add(new DetectedLibraryRoot(file2, rootDetector.getRootType(), rootDetector.isJarDirectory()));
            }
        }
        return result2;
    }

    @Override
    public String getRootTypeName(@NotNull LibraryRootType rootType) {
        for (RootDetector rootDetector : this.myDetectors) {
            if (!rootDetector.getRootType().equals((Object)rootType.getType()) || rootDetector.isJarDirectory() != rootType.isJarDirectory()) continue;
            return rootDetector.getPresentableRootTypeName();
        }
        return null;
    }
}

