/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryTypeServiceImpl
extends LibraryTypeService {
    private static final String DEFAULT_LIBRARY_NAME = "Unnamed";

    @Override
    public NewLibraryConfiguration createLibraryFromFiles(@NotNull LibraryRootsComponentDescriptor descriptor2, @NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, LibraryType<?> type, Project project) {
        FileChooserDescriptor chooserDescriptor = descriptor2.createAttachFilesChooserDescriptor(null);
        chooserDescriptor.setTitle(ProjectBundle.message((String)"chooser.title.select.library.files", (Object[])new Object[0]));
        VirtualFile[] rootCandidates = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)parentComponent, (Project)project, (VirtualFile)contextDirectory);
        if (rootCandidates.length == 0) {
            return null;
        }
        List<OrderRoot> roots = RootDetectionUtil.detectRoots(Arrays.asList(rootCandidates), parentComponent, project, descriptor2);
        if (roots.isEmpty()) {
            return null;
        }
        String name = LibraryTypeServiceImpl.suggestLibraryName(roots);
        return LibraryTypeServiceImpl.doCreate(type, name, roots);
    }

    @NotNull
    private static <P extends LibraryProperties<?>> NewLibraryConfiguration doCreate(LibraryType<P> type, String name, final List<? extends OrderRoot> roots) {
        return new NewLibraryConfiguration(name, type, type != null ? type.getKind().createDefaultProperties() : null){

            @Override
            public void addRoots(@NotNull LibraryEditor editor) {
                editor.addRoots(roots);
            }
        };
    }

    @NotNull
    public static String suggestLibraryName(VirtualFile @NotNull [] classesRoots) {
        if (classesRoots.length >= 1) {
            return FileUtilRt.getNameWithoutExtension((String)PathUtil.getFileName((String)classesRoots[0].getPath()));
        }
        return DEFAULT_LIBRARY_NAME;
    }

    @NotNull
    public static String suggestLibraryName(@NotNull List<? extends OrderRoot> roots) {
        if (roots.size() >= 1) {
            return FileUtilRt.getNameWithoutExtension((String)PathUtil.getFileName((String)roots.get(0).getFile().getPath()));
        }
        return DEFAULT_LIBRARY_NAME;
    }
}

