/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.ApplicationLibraryTable;
import com.intellij.openapi.roots.impl.libraries.CustomLibraryTableImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.CustomLibraryTableDescription;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LibraryTablesRegistrarImpl
extends LibraryTablesRegistrar
implements Disposable {
    private static final ExtensionPointName<CustomLibraryTableDescription> CUSTOM_TABLES_EP = new ExtensionPointName("com.intellij.customLibraryTable");
    private final Map<String, LibraryTableBase> myCustomLibraryTables = new ConcurrentHashMap<String, LibraryTableBase>();
    private volatile boolean myExtensionsLoaded = false;
    private final Object myExtensionsLoadingLock = new Object();

    LibraryTablesRegistrarImpl() {
    }

    @NotNull
    public LibraryTable getLibraryTable() {
        return ApplicationLibraryTable.getApplicationTable();
    }

    @NotNull
    public LibraryTable getLibraryTable(@NotNull Project project) {
        return (LibraryTable)project.getService(ProjectLibraryTable.class);
    }

    public LibraryTable getLibraryTableByLevel(String level, @NotNull Project project) {
        switch (level) {
            case "project": {
                return this.getLibraryTable(project);
            }
            case "application": {
                return this.getLibraryTable();
            }
        }
        return this.getCustomLibraryTableByLevel(level);
    }

    @Nullable
    public LibraryTable getCustomLibraryTableByLevel(String level) {
        return this.getCustomLibrariesMap().get(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, LibraryTableBase> getCustomLibrariesMap() {
        if (this.myExtensionsLoaded) {
            return this.myCustomLibraryTables;
        }
        Object object = this.myExtensionsLoadingLock;
        synchronized (object) {
            if (!this.myExtensionsLoaded) {
                CUSTOM_TABLES_EP.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CustomLibraryTableDescription>(){

                    public void extensionAdded(@NotNull CustomLibraryTableDescription extension, @NotNull PluginDescriptor pluginDescriptor) {
                        CustomLibraryTableImpl table = new CustomLibraryTableImpl(extension.getTableLevel(), extension.getPresentation());
                        LibraryTablesRegistrarImpl.this.myCustomLibraryTables.put(extension.getTableLevel(), table);
                    }

                    public void extensionRemoved(@NotNull CustomLibraryTableDescription extension, @NotNull PluginDescriptor pluginDescriptor) {
                        LibraryTableBase table = (LibraryTableBase)LibraryTablesRegistrarImpl.this.myCustomLibraryTables.remove(extension.getTableLevel());
                        if (table != null) {
                            Disposer.dispose((Disposable)table);
                        }
                    }
                }, true, null);
                this.myExtensionsLoaded = true;
            }
        }
        return this.myCustomLibraryTables;
    }

    public void registerLibraryTable(@NotNull LibraryTable libraryTable) {
        String tableLevel = libraryTable.getTableLevel();
        LibraryTable oldTable = this.myCustomLibraryTables.put(tableLevel, (LibraryTableBase)libraryTable);
        if (oldTable != null) {
            throw new IllegalArgumentException("Library table '" + tableLevel + "' already registered.");
        }
    }

    @NotNull
    public List<LibraryTable> getCustomLibraryTables() {
        return new SmartList(this.getCustomLibrariesMap().values());
    }

    public void dispose() {
        for (LibraryTableBase value2 : this.myCustomLibraryTables.values()) {
            Disposer.dispose((Disposable)value2);
        }
        this.myCustomLibraryTables.clear();
    }
}

