/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesRetriever;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PushedFilePropertiesRetrieverImpl
implements PushedFilePropertiesRetriever {
    @NotNull
    public List<String> dumpSortedPushedProperties(@NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            throw new IllegalArgumentException("file " + file2 + " is expected to be a regular file");
        }
        if (StubUpdatingIndex.USE_SNAPSHOT_MAPPINGS) {
            List extensions2 = FilePropertyPusher.EP_NAME.getExtensionList();
            SmartList properties = new SmartList();
            for (FilePropertyPusher extension : extensions2) {
                VirtualFile vfsObject = extension.pushDirectoriesOnly() ? file2.getParent() : file2;
                Object property = vfsObject.getUserData(extension.getFileDataKey());
                if (property == null) continue;
                properties.add(property.toString());
            }
            ContainerUtil.sort((List)properties);
            return properties;
        }
        return Collections.emptyList();
    }
}

