/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.RootModelImpl;
import org.jetbrains.annotations.NotNull;

abstract class OrderEntryBaseImpl
extends RootModelComponentBase
implements OrderEntry {
    private static final Logger LOG = Logger.getInstance(OrderEntryBaseImpl.class);
    private int myIndex;
    private static int _hc;
    private final int hc = _hc++;

    protected OrderEntryBaseImpl(@NotNull RootModelImpl rootModel) {
        super(rootModel);
    }

    void setIndex(int index) {
        this.myIndex = index;
    }

    public int compareTo(@NotNull OrderEntry orderEntry) {
        LOG.assertTrue(orderEntry.getOwnerModule() == this.getOwnerModule());
        return this.myIndex - ((OrderEntryBaseImpl)orderEntry).myIndex;
    }

    boolean sameType(@NotNull OrderEntry that) {
        return this.getClass().equals(that.getClass());
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public final int hashCode() {
        return this.hc;
    }

    @NotNull
    public String toString() {
        return this.getOwnerModule().getName() + " -> " + this.getPresentableName();
    }
}

