/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NonProjectDirectoryInfo
extends DirectoryInfo {
    static final NonProjectDirectoryInfo IGNORED = new NonProjectDirectoryInfo("ignored"){

        @Override
        public boolean isIgnored() {
            return true;
        }
    };
    static final NonProjectDirectoryInfo EXCLUDED = new NonProjectDirectoryInfo("excluded from project"){

        @Override
        public boolean isExcluded() {
            return true;
        }
    };
    static final NonProjectDirectoryInfo NOT_UNDER_PROJECT_ROOTS = new NonProjectDirectoryInfo("not under project roots");
    static final NonProjectDirectoryInfo INVALID = new NonProjectDirectoryInfo("invalid");
    static final NonProjectDirectoryInfo NOT_SUPPORTED_VIRTUAL_FILE_IMPLEMENTATION = new NonProjectDirectoryInfo("not supported VirtualFile implementation");
    private final String myDebugName;

    private NonProjectDirectoryInfo(@NotNull String debugName) {
        this.myDebugName = debugName;
    }

    @Override
    public boolean isInProject(@NotNull VirtualFile file2) {
        return false;
    }

    public String toString() {
        return "DirectoryInfo: " + this.myDebugName;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    @Nullable
    public VirtualFile getSourceRoot() {
        return null;
    }

    @Override
    public VirtualFile getLibraryClassRoot() {
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getContentRoot() {
        return null;
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        return false;
    }

    public boolean isExcluded() {
        return false;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file2) {
        return this.isExcluded();
    }

    @Override
    public boolean isInModuleSource(@NotNull VirtualFile file2) {
        return false;
    }

    @Override
    public Module getModule() {
        return null;
    }

    @Override
    public String getUnloadedModuleName() {
        return null;
    }

    @Override
    @Nullable
    public SourceFolder getSourceRootFolder() {
        return null;
    }

    @Override
    public boolean processContentBeneathExcluded(@NotNull VirtualFile dir, @NotNull Processor<? super VirtualFile> processor2) {
        return true;
    }

    static class WithBeneathInfo
    extends NonProjectDirectoryInfo {
        @NotNull
        private final NonProjectDirectoryInfo myDelegate;
        final List<DirectoryInfoImpl> myContentInfosBeneath = new SmartList();

        WithBeneathInfo(@NotNull NonProjectDirectoryInfo delegate) {
            super(delegate.myDebugName);
            this.myDelegate = delegate;
        }

        @Override
        public boolean processContentBeneathExcluded(@NotNull VirtualFile dir, @NotNull Processor<? super VirtualFile> processor2) {
            return this.isExcluded(dir) && ContainerUtil.process(this.myContentInfosBeneath, child2 -> !VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)child2.myRoot, (boolean)false) || processor2.process((Object)child2.myRoot));
        }

        @Override
        public boolean isInProject(@NotNull VirtualFile file2) {
            return this.myDelegate.isInProject(file2);
        }

        @Override
        public String toString() {
            return "WithBeneathInfo: " + this.myDelegate + " with roots beneath: " + this.myContentInfosBeneath;
        }

        @Override
        public boolean isIgnored() {
            return this.myDelegate.isIgnored();
        }

        @Override
        @Nullable
        public VirtualFile getSourceRoot() {
            return this.myDelegate.getSourceRoot();
        }

        @Override
        public VirtualFile getLibraryClassRoot() {
            return this.myDelegate.getLibraryClassRoot();
        }

        @Override
        @Nullable
        public VirtualFile getContentRoot() {
            return this.myDelegate.getContentRoot();
        }

        @Override
        public boolean isInLibrarySource(@NotNull VirtualFile file2) {
            return this.myDelegate.isInLibrarySource(file2);
        }

        @Override
        public boolean isExcluded() {
            return this.myDelegate.isExcluded();
        }

        @Override
        public boolean isExcluded(@NotNull VirtualFile file2) {
            return this.myDelegate.isExcluded(file2);
        }

        @Override
        public boolean isInModuleSource(@NotNull VirtualFile file2) {
            return this.myDelegate.isInModuleSource(file2);
        }

        @Override
        public Module getModule() {
            return this.myDelegate.getModule();
        }

        @Override
        public String getUnloadedModuleName() {
            return this.myDelegate.getUnloadedModuleName();
        }

        @Override
        @Nullable
        public SourceFolder getSourceRootFolder() {
            return this.myDelegate.getSourceRootFolder();
        }

        @Override
        public boolean hasLibraryClassRoot() {
            return this.myDelegate.hasLibraryClassRoot();
        }
    }
}

