/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModuleOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ThrowableRunnable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NotImplementedError;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public class ModuleRootManagerImpl
extends ModuleRootManagerEx
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(ModuleRootManagerImpl.class);
    private final Module myModule;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final VirtualFilePointerManager myFilePointerManager;
    protected RootModelImpl myRootModel;
    private boolean myIsDisposed;
    private boolean myLoaded;
    private final OrderRootsCache myOrderRootsCache;
    private final Map<RootModelImpl, Throwable> myModelCreations = new THashMap();
    protected final SimpleModificationTracker myModificationTracker = new SimpleModificationTracker();

    public ModuleRootManagerImpl(@NotNull Module module) {
        this.myModule = module;
        this.myProjectRootManager = ProjectRootManagerImpl.getInstanceImpl(module.getProject());
        this.myFilePointerManager = VirtualFilePointerManager.getInstance();
        this.myRootModel = new RootModelImpl(this, this.myProjectRootManager, this.myFilePointerManager);
        this.myOrderRootsCache = new OrderRootsCache((Disposable)module);
        MODULE_EXTENSION_NAME.getPoint((AreaInstance)module).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ModuleExtension>(){

            public void extensionAdded(@NotNull ModuleExtension extension, @NotNull PluginDescriptor pluginDescriptor) {
                ModuleRootManagerImpl.this.myRootModel.addModuleExtension(extension);
            }

            public void extensionRemoved(@NotNull ModuleExtension extension, @NotNull PluginDescriptor pluginDescriptor) {
                ModuleRootManagerImpl.this.myRootModel.removeModuleExtension(extension);
            }
        }, false, null);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public ModuleFileIndex getFileIndex() {
        return (ModuleFileIndex)this.myModule.getService(ModuleFileIndex.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myRootModel.dispose();
        this.myIsDisposed = true;
        if (Disposer.isDebugMode()) {
            ArrayList<Map.Entry<RootModelImpl, Throwable>> entries;
            Map<RootModelImpl, Throwable> map2 = this.myModelCreations;
            synchronized (map2) {
                entries = new ArrayList<Map.Entry<RootModelImpl, Throwable>>(this.myModelCreations.entrySet());
            }
            for (Map.Entry entry : entries) {
                LOG.warn("\n***********************************************************************************************\n***                        R O O T   M O D E L   N O T   D I S P O S E D                    ***\n***********************************************************************************************\nCreated at:", (Throwable)entry.getValue());
                ((RootModelImpl)entry.getKey()).dispose();
            }
        }
    }

    @NotNull
    public ModifiableRootModel getModifiableModel() {
        return this.getModifiableModel(RootConfigurationAccessor.DEFAULT_INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ModifiableRootModel getModifiableModel(@NotNull RootConfigurationAccessor accessor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        RootModelImpl model = new RootModelImpl(this.myRootModel, this, true, accessor, this.myFilePointerManager, this.myProjectRootManager){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                super.dispose();
                if (Disposer.isDebugMode()) {
                    Map map2 = ModuleRootManagerImpl.this.myModelCreations;
                    synchronized (map2) {
                        ModuleRootManagerImpl.this.myModelCreations.remove(this);
                    }
                }
            }
        };
        if (Disposer.isDebugMode()) {
            Map<RootModelImpl, Throwable> map2 = this.myModelCreations;
            synchronized (map2) {
                this.myModelCreations.put(model, new Throwable());
            }
        }
        return model;
    }

    @Override
    public long getModificationCountForTests() {
        throw new NotImplementedError("Make sense only for persistent root manager");
    }

    void makeRootsChange(@NotNull Runnable runnable2) {
        ProjectRootManagerEx projectRootManagerEx = (ProjectRootManagerEx)ProjectRootManager.getInstance((Project)this.myModule.getProject());
        projectRootManagerEx.makeRootsChange(runnable2, false, this.myModule.isLoaded());
    }

    public RootModelImpl getRootModel() {
        return this.myRootModel;
    }

    public ContentEntry @NotNull [] getContentEntries() {
        return this.myRootModel.getContentEntries();
    }

    public OrderEntry @NotNull [] getOrderEntries() {
        return this.myRootModel.getOrderEntries();
    }

    public Sdk getSdk() {
        return this.myRootModel.getSdk();
    }

    public boolean isSdkInherited() {
        return this.myRootModel.isSdkInherited();
    }

    void commitModel(@NotNull RootModelImpl rootModel) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(rootModel.myModuleRootManager == this);
        LOG.assertTrue(!this.myIsDisposed);
        boolean changed2 = rootModel.isChanged();
        ModifiableModuleModel moduleModel = ModuleManager.getInstance((Project)this.myModule.getProject()).getModifiableModel();
        ModifiableModelCommitter.multiCommit(Collections.singletonList(rootModel), moduleModel);
        if (changed2) {
            this.stateChanged();
        }
    }

    static void doCommit(@NotNull RootModelImpl rootModel) {
        ModuleRootManagerImpl rootManager = (ModuleRootManagerImpl)ModuleRootManagerImpl.getInstance((Module)rootModel.getModule());
        LOG.assertTrue(!rootManager.myIsDisposed);
        rootModel.doCommit();
        rootModel.dispose();
        try {
            rootManager.stateChanged();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public Module @NotNull [] getDependencies() {
        return this.myRootModel.getModuleDependencies();
    }

    public Module @NotNull [] getDependencies(boolean includeTests) {
        return this.myRootModel.getModuleDependencies(includeTests);
    }

    public Module @NotNull [] getModuleDependencies() {
        return this.myRootModel.getModuleDependencies();
    }

    public Module @NotNull [] getModuleDependencies(boolean includeTests) {
        return this.myRootModel.getModuleDependencies(includeTests);
    }

    public boolean isDependsOn(@NotNull Module module) {
        return this.myRootModel.findModuleOrderEntry(module) != null;
    }

    public String @NotNull [] getDependencyModuleNames() {
        return this.myRootModel.getDependencyModuleNames();
    }

    public <T> T getModuleExtension(@NotNull Class<T> klass) {
        return this.myRootModel.getModuleExtension(klass);
    }

    public <R> R processOrder(@NotNull RootPolicy<R> policy, R initialValue) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.processOrder(policy, initialValue);
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        return new ModuleOrderEnumerator(this.myRootModel, this.myOrderRootsCache);
    }

    public static OrderRootsEnumerator getCachingEnumeratorForType(@NotNull OrderRootType type, @NotNull Module module) {
        return ModuleRootManagerImpl.getEnumeratorForType(type, module).usingCache();
    }

    @NotNull
    private static OrderRootsEnumerator getEnumeratorForType(@NotNull OrderRootType type, @NotNull Module module) {
        OrderEnumerator base = OrderEnumerator.orderEntries((Module)module);
        if (type == OrderRootType.CLASSES) {
            return base.exportedOnly().withoutModuleSourceEntries().recursively().classes();
        }
        if (type == OrderRootType.SOURCES) {
            return base.exportedOnly().recursively().sources();
        }
        return base.roots(type);
    }

    public VirtualFile @NotNull [] getContentRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getContentRoots();
    }

    public String @NotNull [] getContentRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getContentRootUrls();
    }

    public String @NotNull [] getExcludeRootUrls() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getExcludeRootUrls();
    }

    public VirtualFile @NotNull [] getExcludeRoots() {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getExcludeRoots();
    }

    public String @NotNull [] getSourceRootUrls() {
        return this.getSourceRootUrls(true);
    }

    public String @NotNull [] getSourceRootUrls(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getSourceRootUrls(includingTests);
    }

    public VirtualFile @NotNull [] getSourceRoots() {
        return this.getSourceRoots(true);
    }

    public VirtualFile @NotNull [] getSourceRoots(boolean includingTests) {
        LOG.assertTrue(!this.myIsDisposed);
        return this.myRootModel.getSourceRoots(includingTests);
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull JpsModuleSourceRootType<?> rootType) {
        return this.myRootModel.getSourceRoots(rootType);
    }

    @NotNull
    public List<VirtualFile> getSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        return this.myRootModel.getSourceRoots(rootTypes);
    }

    @Override
    public void dropCaches() {
        this.myOrderRootsCache.clearCache();
    }

    public ModuleRootManagerState getState() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("getState, module " + this.myModule.getName());
        }
        return new ModuleRootManagerState(this.myRootModel);
    }

    public void loadState(@NotNull ModuleRootManagerState object) {
        this.loadState(object, this.myLoaded || this.myModule.isLoaded());
        this.myLoaded = true;
    }

    protected void loadState(@NotNull ModuleRootManagerState object, boolean throwEvent) {
        ThrowableRunnable r = () -> {
            RootModelImpl newModel = new RootModelImpl(object.getRootModelElement(), this, this.myProjectRootManager, this.myFilePointerManager, throwEvent);
            if (throwEvent) {
                this.makeRootsChange(() -> ModuleRootManagerImpl.doCommit(newModel));
            } else {
                this.myRootModel.dispose();
                this.myRootModel = newModel;
            }
            assert (!this.myRootModel.isOrderEntryDisposed());
        };
        try {
            if (throwEvent) {
                WriteAction.run((ThrowableRunnable)r);
            } else {
                ReadAction.run((ThrowableRunnable)r);
            }
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void stateChanged() {
        if (Registry.is((String)"store.track.module.root.manager.changes", (boolean)false)) {
            LOG.error("ModelRootManager state changed");
        }
        this.myModificationTracker.incModificationCount();
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return ExternalProjectSystemRegistry.getInstance().getExternalSource(this.myModule);
    }

    public static final class ModuleRootManagerState
    implements JDOMExternalizable {
        private RootModelImpl myRootModel;
        private Element myRootModelElement;

        public ModuleRootManagerState() {
        }

        public ModuleRootManagerState(RootModelImpl rootModel) {
            this.myRootModel = rootModel;
        }

        public void readExternal(Element element2) {
            this.myRootModelElement = element2;
        }

        public void writeExternal(Element element2) {
            this.myRootModel.writeExternal(element2);
        }

        public Element getRootModelElement() {
            return this.myRootModelElement;
        }
    }
}

