/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtilRt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ModuleOrderEntryImpl
extends OrderEntryBaseImpl
implements ModuleOrderEntry,
WritableOrderEntry,
ClonableOrderEntry {
    @NonNls
    public static final String ENTRY_TYPE = "module";
    @NonNls
    public static final String MODULE_NAME_ATTR = "module-name";
    @NonNls
    private static final String EXPORTED_ATTR = "exported";
    @NonNls
    private static final String PRODUCTION_ON_TEST_ATTRIBUTE = "production-on-test";
    private final ModulePointer myModulePointer;
    private boolean myExported;
    @NotNull
    private DependencyScope myScope;
    private boolean myProductionOnTestDependency;

    ModuleOrderEntryImpl(@NotNull Module module, @NotNull RootModelImpl rootModel) {
        super(rootModel);
        this.myModulePointer = ModulePointerManager.getInstance((Project)module.getProject()).create(module);
        this.myScope = DependencyScope.COMPILE;
    }

    ModuleOrderEntryImpl(@NotNull String moduleName, @NotNull RootModelImpl rootModel) {
        super(rootModel);
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(moduleName);
        this.myScope = DependencyScope.COMPILE;
    }

    ModuleOrderEntryImpl(@NotNull Element element2, @NotNull RootModelImpl rootModel) throws InvalidDataException {
        super(rootModel);
        this.myExported = element2.getAttributeValue(EXPORTED_ATTR) != null;
        String moduleName = element2.getAttributeValue(MODULE_NAME_ATTR);
        if (moduleName == null) {
            throw new InvalidDataException();
        }
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(moduleName);
        this.myScope = DependencyScope.readExternal((Element)element2);
        this.myProductionOnTestDependency = element2.getAttributeValue(PRODUCTION_ON_TEST_ATTRIBUTE) != null;
    }

    private ModuleOrderEntryImpl(@NotNull ModuleOrderEntryImpl that, @NotNull RootModelImpl rootModel) {
        super(rootModel);
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(that.myModulePointer.getModuleName());
        this.myExported = that.myExported;
        this.myProductionOnTestDependency = that.myProductionOnTestDependency;
        this.myScope = that.myScope;
    }

    @NotNull
    public Module getOwnerModule() {
        return this.getRootModel().getModule();
    }

    public boolean isProductionOnTestDependency() {
        return this.myProductionOnTestDependency;
    }

    public void setProductionOnTestDependency(boolean productionOnTestDependency) {
        this.getRootModel().assertWritable();
        this.myProductionOnTestDependency = productionOnTestDependency;
    }

    public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType type) {
        OrderRootsEnumerator enumerator = this.getEnumerator(type);
        return enumerator != null ? enumerator.getRoots() : VirtualFile.EMPTY_ARRAY;
    }

    @Nullable
    private OrderRootsEnumerator getEnumerator(@NotNull OrderRootType type) {
        Module module = this.myModulePointer.getModule();
        if (module == null) {
            return null;
        }
        return ModuleRootManagerImpl.getCachingEnumeratorForType(type, module);
    }

    public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
        OrderRootsEnumerator enumerator = this.getEnumerator(rootType);
        return enumerator != null ? enumerator.getUrls() : ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getModule() != null;
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        return (R)policy.visitModuleOrderEntry((ModuleOrderEntry)this, initialValue);
    }

    @NotNull
    public String getPresentableName() {
        return this.getModuleName();
    }

    public boolean isSynthetic() {
        return false;
    }

    @Nullable
    public Module getModule() {
        return this.getRootModel().getConfigurationAccessor().getModule(this.myModulePointer.getModule(), this.myModulePointer.getModuleName());
    }

    @Override
    public void writeExternal(@NotNull Element rootElement) throws WriteExternalException {
        Element element2 = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        element2.setAttribute(MODULE_NAME_ATTR, this.getModuleName());
        if (this.myExported) {
            element2.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element2);
        if (this.myProductionOnTestDependency) {
            element2.setAttribute(PRODUCTION_ON_TEST_ATTRIBUTE, "");
        }
        rootElement.addContent(element2);
    }

    @NotNull
    public String getModuleName() {
        return this.myModulePointer.getModuleName();
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull ModifiableRootModel rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        return new ModuleOrderEntryImpl(this, (RootModelImpl)rootModel);
    }

    public boolean isExported() {
        return this.myExported;
    }

    public void setExported(boolean value2) {
        this.getRootModel().assertWritable();
        this.myExported = value2;
    }

    @NotNull
    public DependencyScope getScope() {
        return this.myScope;
    }

    public void setScope(@NotNull DependencyScope scope) {
        this.getRootModel().assertWritable();
        this.myScope = scope;
    }
}

