/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryTableBase;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ModuleLibraryTable
extends ModuleLibraryTableBase {
    @NotNull
    protected final RootModelImpl myRootModel;
    @NotNull
    private final ProjectRootManagerImpl myProjectRootManager;

    ModuleLibraryTable(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        this.myRootModel = rootModel;
        this.myProjectRootManager = projectRootManager;
    }

    @NotNull
    public Library createLibrary(String name, @Nullable PersistentLibraryKind<?> kind, @Nullable ProjectModelExternalSource externalSource) {
        ModuleLibraryOrderEntryImpl orderEntry = new ModuleLibraryOrderEntryImpl(name, kind, this.myRootModel, this.myProjectRootManager, externalSource);
        this.myRootModel.addOrderEntry(orderEntry);
        return orderEntry.getLibrary();
    }

    public void removeLibrary(@NotNull Library library) {
        Iterator<OrderEntry> orderIterator = this.myRootModel.getOrderIterator();
        while (orderIterator.hasNext()) {
            LibraryOrderEntry libraryOrderEntry;
            OrderEntry orderEntry = orderIterator.next();
            if (!(orderEntry instanceof LibraryOrderEntry) || !(libraryOrderEntry = (LibraryOrderEntry)orderEntry).isModuleLevel() || !library.equals(libraryOrderEntry.getLibrary())) continue;
            this.myRootModel.removeOrderEntry(orderEntry);
            return;
        }
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        FilteringIterator filteringIterator = new FilteringIterator(this.myRootModel.getOrderIterator(), entry -> entry instanceof LibraryOrderEntry && ((LibraryOrderEntry)entry).isModuleLevel() && ((LibraryOrderEntry)entry).getLibrary() != null);
        return ContainerUtil.mapIterator((Iterator)filteringIterator, LibraryOrderEntry::getLibrary);
    }

    @NotNull
    public Module getModule() {
        return this.myRootModel.getModule();
    }

    public boolean isChanged() {
        return this.myRootModel.isChanged();
    }
}

