/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.module.impl.scopes.LibraryRuntimeClasspathScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsScope;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class LibraryScopeCache {
    private final LibrariesOnlyScope myLibrariesOnlyScope;
    private final Project myProject;
    private final ConcurrentMap<Module[], GlobalSearchScope> myLibraryScopes = ConcurrentCollectionFactory.createMap(new TObjectHashingStrategy<Module[]>(){

        public int computeHashCode(Module[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(Module[] o1, Module[] o2) {
            return Arrays.equals(o1, o2);
        }
    });
    private final ConcurrentMap<String, GlobalSearchScope> mySdkScopes = new ConcurrentHashMap<String, GlobalSearchScope>();
    private final Map<List<? extends OrderEntry>, GlobalSearchScope> myLibraryResolveScopeCache = ConcurrentFactoryMap.createMap(key -> this.calcLibraryScope((List<? extends OrderEntry>)key));
    private final Map<List<? extends OrderEntry>, GlobalSearchScope> myLibraryUseScopeCache = ConcurrentFactoryMap.createMap(key -> this.calcLibraryUseScope((List<? extends OrderEntry>)key));

    public static LibraryScopeCache getInstance(Project project) {
        return (LibraryScopeCache)ServiceManager.getService((Project)project, LibraryScopeCache.class);
    }

    public LibraryScopeCache(@NotNull Project project) {
        this.myProject = project;
        this.myLibrariesOnlyScope = new LibrariesOnlyScope(GlobalSearchScope.allScope((Project)this.myProject), this.myProject);
    }

    void clear() {
        this.myLibraryScopes.clear();
        this.mySdkScopes.clear();
        this.myLibraryResolveScopeCache.clear();
        this.myLibraryUseScopeCache.clear();
    }

    @NotNull
    public GlobalSearchScope getLibrariesOnlyScope() {
        return this.myLibrariesOnlyScope;
    }

    @NotNull
    private GlobalSearchScope getScopeForLibraryUsedIn(@NotNull List<? extends Module> modulesLibraryIsUsedIn) {
        Module[] array2 = modulesLibraryIsUsedIn.toArray(Module.EMPTY_ARRAY);
        GlobalSearchScope scope = (GlobalSearchScope)this.myLibraryScopes.get(array2);
        return scope != null ? scope : (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.myLibraryScopes, (Object)array2, (Object)((Object)new LibraryRuntimeClasspathScope(this.myProject, modulesLibraryIsUsedIn)));
    }

    @NotNull
    public GlobalSearchScope getLibraryScope(@NotNull List<? extends OrderEntry> orderEntries) {
        return this.myLibraryResolveScopeCache.get(orderEntries);
    }

    @NotNull
    public GlobalSearchScope getLibraryUseScope(@NotNull List<? extends OrderEntry> orderEntries) {
        return this.myLibraryUseScopeCache.get(orderEntries);
    }

    @NotNull
    private GlobalSearchScope calcLibraryScope(@NotNull List<? extends OrderEntry> orderEntries) {
        LibrariesOnlyScope allCandidates;
        ArrayList<Module> modulesLibraryUsedIn = new ArrayList<Module>();
        LibraryOrderEntry lib = null;
        for (OrderEntry orderEntry : orderEntries) {
            if (orderEntry instanceof JdkOrderEntry) {
                return this.getScopeForSdk((JdkOrderEntry)orderEntry);
            }
            if (orderEntry instanceof LibraryOrderEntry) {
                lib = (LibraryOrderEntry)orderEntry;
                modulesLibraryUsedIn.add(orderEntry.getOwnerModule());
                continue;
            }
            if (!(orderEntry instanceof ModuleOrderEntry)) continue;
            modulesLibraryUsedIn.add(orderEntry.getOwnerModule());
        }
        Comparator<Module> comparator2 = Comparator.comparing(Module::getName);
        modulesLibraryUsedIn.sort(comparator2);
        List list2 = ContainerUtil.removeDuplicatesFromSorted(modulesLibraryUsedIn, comparator2);
        LibrariesOnlyScope librariesOnlyScope = allCandidates = list2.isEmpty() ? this.myLibrariesOnlyScope : this.getScopeForLibraryUsedIn(list2);
        if (lib != null) {
            final LibraryRuntimeClasspathScope preferred = new LibraryRuntimeClasspathScope(this.myProject, lib);
            return new DelegatingGlobalSearchScope((GlobalSearchScope)allCandidates, new Object[]{preferred}){

                public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                    boolean c1 = preferred.contains(file1);
                    boolean c2 = preferred.contains(file2);
                    if (c1 && !c2) {
                        return 1;
                    }
                    if (c2 && !c1) {
                        return -1;
                    }
                    return super.compare(file1, file2);
                }
            };
        }
        return allCandidates;
    }

    @NotNull
    public GlobalSearchScope getScopeForSdk(@NotNull JdkOrderEntry jdkOrderEntry) {
        String jdkName = jdkOrderEntry.getJdkName();
        if (jdkName == null) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        GlobalSearchScope scope = (GlobalSearchScope)this.mySdkScopes.get(jdkName);
        if (scope == null) {
            scope = new JdkScope(this.myProject, jdkOrderEntry);
            return (GlobalSearchScope)ConcurrencyUtil.cacheOrGet(this.mySdkScopes, (Object)jdkName, (Object)scope);
        }
        return scope;
    }

    @NotNull
    private GlobalSearchScope calcLibraryUseScope(@NotNull List<? extends OrderEntry> entries) {
        THashSet modulesWithLibrary = new THashSet(entries.size());
        THashSet modulesWithSdk = new THashSet(entries.size());
        for (OrderEntry orderEntry : entries) {
            (orderEntry instanceof JdkOrderEntry ? modulesWithSdk : modulesWithLibrary).add(orderEntry.getOwnerModule());
        }
        modulesWithSdk.removeAll((Collection<?>)modulesWithLibrary);
        if (modulesWithSdk.size() + modulesWithLibrary.size() == ModuleManager.getInstance((Project)this.myProject).getModules().length) {
            return GlobalSearchScope.allScope((Project)this.myProject);
        }
        ArrayList<Object> united = new ArrayList<Object>();
        if (!modulesWithSdk.isEmpty()) {
            united.add((Object)new ModulesScope((Set<? extends Module>)modulesWithSdk, this.myProject));
            united.add(this.myLibrariesOnlyScope.intersectWith(new LibraryRuntimeClasspathScope(this.myProject, (Collection<? extends Module>)modulesWithSdk)));
        } else {
            united.add((Object)this.myLibrariesOnlyScope);
        }
        if (!modulesWithLibrary.isEmpty()) {
            united.add((Object)new ModuleWithDependentsScope(this.myProject, (Collection<? extends Module>)modulesWithLibrary));
        }
        return GlobalSearchScope.union((GlobalSearchScope[])united.toArray(GlobalSearchScope.EMPTY_ARRAY));
    }

    private static class LibrariesOnlyScope
    extends DelegatingGlobalSearchScope {
        private final ProjectFileIndex myIndex;

        private LibrariesOnlyScope(@NotNull GlobalSearchScope original, @NotNull Project project) {
            super(original);
            this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return super.contains(file2) && this.myIndex.isInLibrary(file2);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

