/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotationOrderRootType
extends PersistentOrderRootType {
    public static OrderRootType getInstance() {
        return (OrderRootType)AnnotationOrderRootType.getOrderRootType(AnnotationOrderRootType.class);
    }

    public AnnotationOrderRootType() {
        super("ANNOTATIONS", "annotationsPath", "annotation-paths", null);
    }

    public boolean skipWriteIfEmpty() {
        return true;
    }

    public static VirtualFile @NotNull [] getFiles(@NotNull OrderEntry entry) {
        ArrayList result2 = new ArrayList();
        RootPolicy<List<VirtualFile>> policy = new RootPolicy<List<VirtualFile>>(){

            public List<VirtualFile> visitLibraryOrderEntry(@NotNull LibraryOrderEntry orderEntry, List<VirtualFile> value2) {
                Collections.addAll(value2, orderEntry.getRootFiles(AnnotationOrderRootType.getInstance()));
                return value2;
            }

            public List<VirtualFile> visitJdkOrderEntry(@NotNull JdkOrderEntry orderEntry, List<VirtualFile> value2) {
                Collections.addAll(value2, orderEntry.getRootFiles(AnnotationOrderRootType.getInstance()));
                return value2;
            }

            public List<VirtualFile> visitModuleSourceOrderEntry(@NotNull ModuleSourceOrderEntry orderEntry, List<VirtualFile> value2) {
                Collections.addAll(value2, ((JavaModuleExternalPaths)orderEntry.getRootModel().getModuleExtension(JavaModuleExternalPaths.class)).getExternalAnnotationsRoots());
                return value2;
            }
        };
        entry.accept((RootPolicy)policy, result2);
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    public static String @NotNull [] getUrls(@NotNull OrderEntry entry) {
        ArrayList result2 = new ArrayList();
        RootPolicy<List<String>> policy = new RootPolicy<List<String>>(){

            public List<String> visitLibraryOrderEntry(@NotNull LibraryOrderEntry orderEntry, List<String> value2) {
                Collections.addAll(value2, orderEntry.getRootUrls(AnnotationOrderRootType.getInstance()));
                return value2;
            }

            public List<String> visitJdkOrderEntry(@NotNull JdkOrderEntry orderEntry, List<String> value2) {
                Collections.addAll(value2, orderEntry.getRootUrls(AnnotationOrderRootType.getInstance()));
                return value2;
            }

            public List<String> visitModuleSourceOrderEntry(@NotNull ModuleSourceOrderEntry orderEntry, List<String> value2) {
                Collections.addAll(value2, ((JavaModuleExternalPaths)orderEntry.getRootModel().getModuleExtension(JavaModuleExternalPaths.class)).getExternalAnnotationsUrls());
                return value2;
            }
        };
        entry.accept((RootPolicy)policy, result2);
        return ArrayUtilRt.toStringArray(result2);
    }
}

