/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerKt;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerListener;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListParser;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0007J#\u0010\u001b\u001a\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u000b\u0012\t\u0018\u00010\r\u00a2\u0006\u0002\b\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\rJ\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001d\u0010 \u001a\n !*\u0004\u0018\u00010\u00070\u0007*\u00020\u00072\u0006\u0010\"\u001a\u00020\rH\u0082\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "defaultInstallDir", "Ljava/io/File;", "newVersion", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "findJdkItem", "jdkHome", "findJdkItemForInstalledJdk", "", "installJdk", "", "request", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "markerFile", "installDir", "prepareJdkInstallation", "jdkItem", "targetPath", "validateInstallDir", "Lkotlin/Pair;", "Lorg/jetbrains/annotations/Nls;", "selectedPath", "writeMarkerFile", "div", "kotlin.jvm.PlatformType", "path", "Companion", "intellij.platform.lang.impl"})
public final class JdkInstaller {
    private final Logger LOG;
    public static final Companion Companion = new Companion(null);

    private final File div(File $this$div, String path) {
        return new File($this$div, path).getAbsoluteFile();
    }

    @NotNull
    public final File defaultInstallDir() {
        File file2;
        String string = System.getProperty("user.home");
        if (string == null) {
            string = ".";
        }
        File home = new File(FileUtil.toCanonicalPath((String)string));
        if (SystemInfo.isLinux) {
            file2 = this.div(home, ".jdks");
        } else if (SystemInfo.isMac) {
            file2 = this.div(this.div(this.div(home, "Library"), "Java"), "JavaVirtualMachines");
        } else if (SystemInfo.isWindows) {
            file2 = this.div(home, ".jdks");
        } else {
            String string2 = "Unsupported OS: " + SystemInfo.getOsNameAndVersion();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return file2;
    }

    @NotNull
    public final File defaultInstallDir(@NotNull JdkItem newVersion) {
        File targetDir = this.div(this.defaultInstallDir(), newVersion.getInstallFolderName());
        int count = 1;
        File uniqueDir = targetDir;
        while (uniqueDir.exists()) {
            uniqueDir = new File(targetDir.getPath() + "-" + count++);
        }
        return uniqueDir.getAbsoluteFile();
    }

    @NotNull
    public final Pair<File, String> validateInstallDir(@NotNull String selectedPath) {
        Object object;
        if (StringsKt.isBlank((CharSequence)selectedPath)) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.empty", (Object[])new Object[0]));
        }
        File[] fileArray = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = fileArray;
            boolean bl2 = false;
            $this$runCatching = new File(FileUtil.expandUserHome((String)selectedPath));
            bl2 = false;
            object = Result.constructor-impl((Object)$this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
        }
        fileArray = object;
        bl = false;
        boolean bl4 = false;
        File[] fileArray2 = Result.exceptionOrNull-impl((Object)fileArray);
        if (fileArray2 != null) {
            File[] t = fileArray2;
            boolean bl5 = false;
            this.LOG.warn("Failed to resolve user path: " + selectedPath + ". " + t.getMessage(), (Throwable)t);
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.resolving.path", (Object[])new Object[0]));
        }
        File targetDir = (File)fileArray;
        if (targetDir.isFile()) {
            return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.file", (Object[])new Object[0]));
        }
        if (targetDir.isDirectory()) {
            File[] fileArray3 = targetDir.listFiles();
            if (fileArray3 != null) {
                fileArray = fileArray3;
                bl = false;
                fileArray2 = fileArray;
                boolean bl6 = false;
                if (!(fileArray2.length == 0)) {
                    return TuplesKt.to(null, (Object)ProjectBundle.message((String)"dialog.message.error.target.path.exists.nonEmpty.dir", (Object[])new Object[0]));
                }
            }
        }
        return TuplesKt.to((Object)targetDir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void installJdk(@NotNull JdkInstallRequest request2, @Nullable ProgressIndicator indicator, @Nullable Project project) {
        Object object;
        JdkInstaller sizeDiff23332;
        JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe((java.util.function.Consumer)new java.util.function.Consumer<JdkInstallerListener>(request2, project){
            final /* synthetic */ JdkInstallRequest $request;
            final /* synthetic */ Project $project;

            public final void accept(JdkInstallerListener it) {
                it.onJdkDownloadStarted(this.$request, this.$project);
            }
            {
                this.$request = jdkInstallRequest;
                this.$project = project;
            }
        });
        JdkItem item = request2.getItem();
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(ProjectBundle.message((String)"progress.text.installing.jdk.1", (Object[])new Object[]{item.getFullPresentationText()}));
        }
        File targetDir = request2.getInstallDir();
        Url url = Urls.parse((String)item.getUrl(), (boolean)false);
        if (url == null) {
            String string = "Cannot parse download URL: " + item.getUrl();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Url url2 = url;
        if (!StringsKt.equals((String)url2.getScheme(), (String)"https", (boolean)true)) {
            String string = "URL must use https:// protocol, but was: " + url2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ProgressIndicator progressIndicator3 = indicator;
        if (progressIndicator3 != null) {
            progressIndicator3.setText2(ProjectBundle.message((String)"progress.text2.downloading.jdk", (Object[])new Object[0]));
        }
        File downloadFile = new File(PathManager.getTempPath(), "jdk-" + item.getArchiveFileName());
        try {
            try {
                HttpRequests.request((String)item.getUrl()).productNameAsUserAgent().saveToFile(downloadFile, indicator);
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw (Throwable)new RuntimeException("Failed to download " + item.getFullPresentationText() + " from " + url2 + ". " + t.getMessage(), t);
                throw t;
            }
            long sizeDiff23332 = downloadFile.length() - item.getArchiveSize();
            if (sizeDiff23332 != 0L) {
                long l = sizeDiff23332;
                boolean bl = false;
                throw (Throwable)new RuntimeException("The downloaded " + item.getFullPresentationText() + " has incorrect file size,\n" + "the difference is " + Math.abs(l) + " bytes.\n" + "Check your internet connection and try again later");
            }
            String actualHashCode = Files.asByteSource((File)downloadFile).hash(Hashing.sha256()).toString();
            if (!StringsKt.equals((String)actualHashCode, (String)item.getSha256(), (boolean)true)) {
                throw (Throwable)new RuntimeException("Failed to verify SHA-256 checksum for " + item.getFullPresentationText() + "\n\n" + "The actual value is " + actualHashCode + ",\n" + "but expected " + item.getSha256() + " was expected\n" + "Check your internet connection and try again later");
            }
            ProgressIndicator progressIndicator4 = indicator;
            if (progressIndicator4 != null) {
                progressIndicator4.setIndeterminate(true);
            }
            ProgressIndicator progressIndicator5 = indicator;
            if (progressIndicator5 != null) {
                progressIndicator5.setText2(ProjectBundle.message((String)"progress.text2.unpacking.jdk", (Object[])new Object[0]));
            }
            try {
                Decompressor decompressor = item.getPackageType().openDecompressor(downloadFile);
                decompressor.postprocessor((Consumer)new Consumer<File>(indicator){
                    final /* synthetic */ ProgressIndicator $indicator;

                    public final void consume(File it) {
                        block0: {
                            ProgressIndicator progressIndicator2 = this.$indicator;
                            if (progressIndicator2 == null) break block0;
                            progressIndicator2.checkCanceled();
                        }
                    }
                    {
                        this.$indicator = progressIndicator2;
                    }
                });
                String fullMatchPath = StringsKt.trim((String)item.getPackageRootPrefix(), (char[])new char[]{'/'});
                if (!StringsKt.isBlank((CharSequence)fullMatchPath)) {
                    decompressor.removePrefixPath(fullMatchPath);
                }
                decompressor.extract(targetDir);
                this.writeMarkerFile(request2);
            }
            catch (Throwable t) {
                if (!(t instanceof ControlFlowException)) throw (Throwable)new RuntimeException("Failed to extract " + item.getFullPresentationText() + ". " + t.getMessage(), t);
                throw t;
            }
            sizeDiff23332 = this;
            boolean bl = false;
        }
        catch (Throwable t) {
            try {
                FileUtil.delete((File)targetDir);
                FileUtil.delete((File)this.markerFile(targetDir));
                throw t;
            }
            catch (Throwable throwable) {
                JdkInstaller jdkInstaller = this;
                boolean bl5 = false;
                try {
                    Object object2 = Result.Companion;
                    JdkInstaller $this$runCatching = jdkInstaller;
                    boolean bl6 = false;
                    Boolean bl7 = FileUtil.delete((File)downloadFile);
                    boolean bl8 = false;
                    object2 = Result.constructor-impl((Object)bl7);
                }
                catch (Throwable throwable2) {
                    Result.Companion companion = Result.Companion;
                    boolean bl9 = false;
                    Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe((java.util.function.Consumer)new java.util.function.Consumer<JdkInstallerListener>(request2, project){
                    final /* synthetic */ JdkInstallRequest $request;
                    final /* synthetic */ Project $project;

                    public final void accept(JdkInstallerListener it) {
                        it.onJdkDownloadFinished(this.$request, this.$project);
                    }
                    {
                        this.$request = jdkInstallRequest;
                        this.$project = project;
                    }
                });
                throw throwable;
            }
        }
        try {
            object = Result.Companion;
            JdkInstaller $this$runCatching = sizeDiff23332;
            boolean bl2 = false;
            Boolean bl3 = FileUtil.delete((File)downloadFile);
            bl2 = false;
            object = Result.constructor-impl((Object)bl3);
        }
        catch (Throwable throwable) {
            Result.Companion bl2 = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        JdkInstallerKt.access$getJDK_INSTALL_LISTENER_EP_NAME$p().forEachExtensionSafe((java.util.function.Consumer)new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JdkInstallRequest prepareJdkInstallation(@NotNull JdkItem jdkItem, @NotNull File targetPath) {
        void home;
        Pair<File, String> pair = this.validateInstallDir(targetPath.getPath());
        File file2 = (File)pair.component1();
        String error = (String)pair.component2();
        if (home == null || error != null) {
            String string = error;
            if (string == null) {
                string = "Invalid Target Directory";
            }
            throw (Throwable)new RuntimeException(string);
        }
        FileUtil.createDirectory((File)home);
        if (!home.isDirectory()) {
            throw (Throwable)new IOException("Failed to create home directory: " + home);
        }
        File javaHome = StringsKt.isBlank((CharSequence)jdkItem.getPackageToBinJavaPrefix()) ? targetPath : new File(targetPath, jdkItem.getPackageToBinJavaPrefix()).getAbsoluteFile();
        FileUtil.createDirectory((File)javaHome);
        if (!javaHome.isDirectory()) {
            throw (Throwable)new IOException("Failed to create home directory: " + javaHome);
        }
        JdkInstallRequest request2 = new JdkInstallRequest(jdkItem, targetPath, javaHome){
            @NotNull
            private final JdkItem item;
            @NotNull
            private final File installDir;
            private final File javaHome;
            final /* synthetic */ JdkItem $jdkItem;
            final /* synthetic */ File $targetPath;
            final /* synthetic */ File $javaHome;

            @NotNull
            public JdkItem getItem() {
                return this.item;
            }

            @NotNull
            public File getInstallDir() {
                return this.installDir;
            }

            public File getJavaHome() {
                return this.javaHome;
            }
            {
                this.$jdkItem = $captured_local_variable$0;
                this.$targetPath = $captured_local_variable$1;
                this.$javaHome = $captured_local_variable$2;
                this.item = $captured_local_variable$0;
                this.installDir = $captured_local_variable$1;
                this.javaHome = $captured_local_variable$2;
            }
        };
        this.writeMarkerFile(request2);
        return request2;
    }

    private final File markerFile(File installDir) {
        return new File(installDir.getParent(), '.' + installDir.getName() + ".intellij");
    }

    private final void writeMarkerFile(JdkInstallRequest request2) {
        File installDir = request2.getInstallDir();
        File markerFile2 = this.markerFile(installDir);
        try {
            request2.getItem().writeMarkerFile(markerFile2);
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            this.LOG.warn("Failed to write marker file to " + markerFile2 + ". " + t.getMessage(), t);
        }
    }

    @Nullable
    public final JdkItem findJdkItemForInstalledJdk(@NotNull String jdkHome) {
        return this.findJdkItem(new File(jdkHome));
    }

    private final JdkItem findJdkItem(File jdkHome) {
        Object v0;
        block4: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)jdkHome, (Function1)findJdkItem.markerFile.1.INSTANCE), (Function1)findJdkItem.markerFile.2.INSTANCE), (int)5), (Function1)((Function1)new Function1<File, File>(this){
                final /* synthetic */ JdkInstaller this$0;

                @NotNull
                public final File invoke(@NotNull File it) {
                    return JdkInstaller.access$markerFile(this.this$0, it);
                }
                {
                    this.this$0 = jdkInstaller;
                    super(1);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!it.isFile()) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        File file2 = v0;
        if (file2 == null) {
            return null;
        }
        File markerFile2 = file2;
        try {
            ObjectNode json = JdkListParser.INSTANCE.readTree(FilesKt.readBytes((File)markerFile2));
            return JdkListParser.INSTANCE.parseJdkItem(json, JdkPredicate.Companion.createInstance());
        }
        catch (Throwable e) {
            return null;
        }
    }

    public JdkInstaller() {
        boolean $i$f$logger = false;
        this.LOG = Logger.getInstance(JdkInstaller.class);
    }

    public static final /* synthetic */ File access$markerFile(JdkInstaller $this, File installDir) {
        return $this.markerFile(installDir);
    }

    @JvmStatic
    @NotNull
    public static final JdkInstaller getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstaller;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JdkInstaller getInstance() {
            boolean $i$f$service = false;
            return (JdkInstaller)ApplicationManager.getApplication().getService(JdkInstaller.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

