/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl.jdkDownloader;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloadDialog;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkDownloaderBase;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownload;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTask;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003JG\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\r\b\u0001\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0014\b\u0004\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\b0\u0010H\u0082\b\u00a2\u0006\u0002\u0010\u0012J8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloader;", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownload;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkDownloaderBase;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "computeInBackground", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "showDownloadUI", "", "sdkTypeId", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "sdkModel", "Lcom/intellij/openapi/projectRoots/SdkModel;", "parentComponent", "Ljavax/swing/JComponent;", "selectedSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdkCreatedCallback", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/SdkDownloadTask;", "supportsDownload", "", "intellij.platform.lang.impl"})
public final class JdkDownloader
implements SdkDownload,
JdkDownloaderBase {
    private final Logger LOG;

    @Override
    public boolean supportsDownload(@NotNull SdkTypeId sdkTypeId) {
        if (!Registry.is((String)"jdk.downloader")) {
            return false;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        return SimpleJavaSdkType.notSimpleJavaSdkTypeIfAlternativeExistsAndNotDependentSdkType().value((Object)sdkTypeId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void showDownloadUI(@NotNull SdkTypeId sdkTypeId, @NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<SdkDownloadTask> sdkCreatedCallback) {
        Object object;
        Object this_$iv;
        boolean $i$f$computeInBackground22;
        Project project;
        Project project2 = project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        if (project2 != null) {
            if (project2.isDisposed()) {
                return;
            }
        }
        try {
            JdkDownloader jdkDownloader = this;
            String title$iv = ProjectBundle.message((String)"progress.title.downloading.jdk.list", (Object[])new Object[0]);
            $i$f$computeInBackground22 = false;
            this_$iv = (List)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<List<? extends JdkItem>, Exception>(project, title$iv, project, title$iv, true){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                }

                @NotNull
                protected List<? extends JdkItem> compute(@NotNull ProgressIndicator indicator) {
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    return JdkListDownloader.downloadForUI$default(JdkListDownloader.Companion.getInstance(), it, null, 2, null);
                }
            });
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this.LOG.warn("Failed to download the list of installable JDKs. " + e.getMessage(), e);
            this_$iv = null;
        }
        List items = this_$iv;
        Project project3 = project;
        if (project3 != null) {
            if (project3.isDisposed()) {
                return;
            }
        }
        this_$iv = items;
        boolean e = false;
        $i$f$computeInBackground22 = false;
        if (this_$iv == null || this_$iv.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)ProjectBundle.message((String)"error.message.no.jdk.for.download", (Object[])new Object[0]), (String)ProjectBundle.message((String)"error.message.title.download.jdk", (Object[])new Object[0]));
            return;
        }
        Pair<JdkItem, File> pair = new JdkDownloadDialog(project, parentComponent, sdkTypeId, items).selectJdkAndPath();
        if (pair == null) {
            return;
        }
        Pair<JdkItem, File> $i$f$computeInBackground22 = pair;
        this_$iv = (JdkItem)$i$f$computeInBackground22.component1();
        File jdkHome = (File)$i$f$computeInBackground22.component2();
        try {
            void jdkItem;
            object = this;
            String title$iv = ProjectBundle.message((String)"progress.title.preparing.jdk", (Object[])new Object[0]);
            boolean $i$f$computeInBackground = false;
            object = (JdkInstallRequest)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<JdkInstallRequest, Exception>(project, title$iv, project, title$iv, true, (JdkItem)jdkItem, jdkHome){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ JdkItem $jdkItem$inlined;
                final /* synthetic */ File $jdkHome$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$jdkItem$inlined = jdkItem;
                    this.$jdkHome$inlined = file2;
                    super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                }

                @NotNull
                protected JdkInstallRequest compute(@NotNull ProgressIndicator indicator) {
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    return JdkInstaller.Companion.getInstance().prepareJdkInstallation(this.$jdkItem$inlined, this.$jdkHome$inlined);
                }
            });
        }
        catch (Throwable e2) {
            if (e2 instanceof ControlFlowException) {
                throw e2;
            }
            this.LOG.warn("Failed to prepare JDK installation to " + jdkHome + ". " + e2.getMessage(), e2);
            Messages.showErrorDialog((Project)project, (String)ProjectBundle.message((String)"error.message.text.jdk.install.failed", (Object[])new Object[]{jdkHome}), (String)ProjectBundle.message((String)"error.message.title.download.jdk", (Object[])new Object[0]));
            return;
        }
        Object request2 = object;
        sdkCreatedCallback.accept(this.newDownloadTask((JdkInstallRequest)request2, project));
    }

    private final <T> T computeInBackground(Project project, @Nls String title, Function1<? super ProgressIndicator, ? extends T> action2) {
        int $i$f$computeInBackground = 0;
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, Exception>(action2, project, title, project, title, true){
            final /* synthetic */ Function1 $action;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;

            @NotNull
            protected T compute(@NotNull ProgressIndicator indicator) {
                return (T)this.$action.invoke((Object)indicator);
            }
            {
                this.$action = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    public JdkDownloader() {
        boolean $i$f$logger = false;
        this.LOG = Logger.getInstance(JdkDownloader.class);
    }

    @Override
    @NotNull
    public SdkDownloadTask newDownloadTask(@NotNull JdkInstallRequest request2, @Nullable Project project) {
        return JdkDownloaderBase.DefaultImpls.newDownloadTask(this, request2, project);
    }
}

