/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class UnknownSdkBalloonNotification {
    private static final NotificationGroup SDK_CONFIGURED_GROUP = new NotificationGroup("Missing SDKs", NotificationDisplayType.BALLOON, true);
    private final Project myProject;

    @NotNull
    public static UnknownSdkBalloonNotification getInstance(@NotNull Project project) {
        return (UnknownSdkBalloonNotification)project.getService(UnknownSdkBalloonNotification.class);
    }

    public UnknownSdkBalloonNotification(@NotNull Project project) {
        this.myProject = project;
    }

    public void notifyFixedSdks(@NotNull Map<? extends UnknownSdk, UnknownSdkLocalSdkFix> localFixes) {
        String change;
        String title;
        if (localFixes.isEmpty()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        TreeSet<String> usages = new TreeSet<String>();
        for (Map.Entry<? extends UnknownSdk, UnknownSdkLocalSdkFix> entry : localFixes.entrySet()) {
            UnknownSdkLocalSdkFix fix = entry.getValue();
            String usageText = ProjectBundle.message((String)"notification.text.sdk.usage.is.set.to", (Object[])new Object[]{entry.getKey().getSdkName(), fix.getVersionString()});
            String usage = usageText + "<br/>" + SdkListPresenter.presentDetectedSdkPath(fix.getExistingSdkHome());
            usages.add(usage);
        }
        message.append(StringUtil.join(usages, (String)"<br/><br/>"));
        if (localFixes.size() == 1) {
            Map.Entry<? extends UnknownSdk, UnknownSdkLocalSdkFix> entry = localFixes.entrySet().iterator().next();
            UnknownSdk info = entry.getKey();
            String sdkTypeName = info.getSdkType().getPresentableName();
            title = ProjectBundle.message((String)"notification.title.sdk.configured", (Object[])new Object[]{sdkTypeName});
            change = ProjectBundle.message((String)"notification.link.change.sdk", (Object[])new Object[]{sdkTypeName});
        } else {
            title = ProjectBundle.message((String)"notification.title.sdks.configured", (Object[])new Object[0]);
            change = ProjectBundle.message((String)"notification.link.change.sdks", (Object[])new Object[0]);
        }
        SDK_CONFIGURED_GROUP.createNotification(title, message.toString(), NotificationType.INFORMATION, null).setImportant(true).addAction((AnAction)NotificationAction.createSimple((String)change, () -> ProjectSettingsService.getInstance(this.myProject).openProjectSettings())).notify(this.myProject);
    }
}

