/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.MockSdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkDownloader;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.roots.ui.configuration.UnknownSdk;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkDownloadableSdkFix;
import com.intellij.openapi.roots.ui.configuration.UnknownSdkLocalSdkFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownInvalidSdk
implements UnknownSdk {
    private static final Logger LOG = Logger.getInstance(UnknownInvalidSdk.class);
    @NotNull
    final Sdk mySdk;
    @NotNull
    final SdkType mySdkType;
    @Nullable
    UnknownSdkLocalSdkFix myLocalSdkFix = null;
    @Nullable
    UnknownSdkDownloadableSdkFix myDownloadableSdkFix = null;

    UnknownInvalidSdk(@NotNull Sdk sdk2, @NotNull SdkType sdkType) {
        this.mySdk = sdk2;
        this.mySdkType = sdkType;
    }

    @Override
    @NotNull
    public SdkType getSdkType() {
        return this.mySdkType;
    }

    @Override
    @NotNull
    public String getSdkName() {
        return this.mySdk.getName();
    }

    @Override
    @Nullable
    public String getExpectedVersionString() {
        return this.mySdk.getVersionString();
    }

    void applyLocalFix(@NotNull Project project) {
        if (this.myLocalSdkFix == null) {
            return;
        }
        String sdkFixVersionString = this.myLocalSdkFix.getVersionString();
        String sdkHome = this.myLocalSdkFix.getExistingSdkHome();
        this.copySdk(project, sdkFixVersionString, sdkHome);
    }

    private void copySdk(@NotNull Project project, @NotNull String sdkFixVersionString, @NotNull String sdkHome) {
        WriteAction.run(() -> {
            SdkModificator mod = this.mySdk.getSdkModificator();
            mod.setVersionString(sdkFixVersionString);
            mod.setHomePath(sdkHome);
            mod.commitChanges();
            this.mySdkType.setupSdkPaths(this.mySdk);
        });
        UnknownSdkTracker.getInstance(project).updateUnknownSdksNow();
    }

    void applyDownloadFix(@NotNull Project project) {
        if (this.myDownloadableSdkFix == null) {
            return;
        }
        UnknownSdkDownloader.downloadFix(project, this, this.myDownloadableSdkFix, __ -> this.mySdk, (Consumer<? super Sdk>)((Consumer)__ -> {}), (Consumer<? super Sdk>)((Consumer)sdk2 -> UnknownSdkTracker.getInstance(project).updateUnknownSdksNow()));
    }

    @NotNull
    public EditorNotificationPanel.ActionHandler createSdkSelectionPopup(@NotNull Project project) {
        String sdkName = this.mySdk.getName();
        return SdkPopupFactory.newBuilder().withProject(project).withSdkFilter((Condition<Sdk>)((Condition)sdk2 -> !Objects.equals(sdk2.getName(), sdkName))).withSdkTypeFilter((Condition<SdkTypeId>)((Condition)type -> Objects.equals(type, this.mySdkType))).onSdkSelected(sdk2 -> {
            String homePath = sdk2.getHomePath();
            String versionString = sdk2.getVersionString();
            if (homePath != null && versionString != null) {
                this.copySdk(project, versionString, homePath);
            } else {
                LOG.warn("Newly added SDK has invalid home or version: " + sdk2 + ", home=" + homePath + " version=" + versionString);
            }
        }).buildEditorNotificationPanelHandler();
    }

    static void removeAndUpdate(@NotNull List<UnknownInvalidSdk> invalidSdks, @NotNull List<UnknownSdk> fixable, @NotNull Map<UnknownSdk, UnknownSdkLocalSdkFix> localFixes, @NotNull Map<UnknownSdk, UnknownSdkDownloadableSdkFix> downloadFixes) {
        fixable.removeAll(invalidSdks);
        for (UnknownInvalidSdk invalidSdk : invalidSdks) {
            invalidSdk.myLocalSdkFix = localFixes.remove(invalidSdk);
            invalidSdk.myDownloadableSdkFix = downloadFixes.remove(invalidSdk);
        }
    }

    @NotNull
    static List<UnknownInvalidSdk> resolveInvalidSdks(@NotNull List<Sdk> usedSdks) {
        ArrayList<UnknownInvalidSdk> result2 = new ArrayList<UnknownInvalidSdk>();
        for (Sdk sdk2 : usedSdks) {
            UnknownInvalidSdk invalidSdk;
            if (SdkDownloadTracker.getInstance().isDownloading(sdk2) || (invalidSdk = UnknownInvalidSdk.resolveInvalidSdk(sdk2)) == null) continue;
            result2.add(invalidSdk);
        }
        return result2;
    }

    @Nullable
    private static UnknownInvalidSdk resolveInvalidSdk(@NotNull Sdk sdk2) {
        SdkTypeId type = sdk2.getSdkType();
        if (!(type instanceof SdkType)) {
            return null;
        }
        SdkType sdkType = (SdkType)type;
        if (ApplicationManager.getApplication().isUnitTestMode() && sdk2 instanceof MockSdk) {
            return null;
        }
        try {
            String homePath = sdk2.getHomePath();
            if (homePath != null && sdkType.isValidSdkHome(homePath)) {
                return null;
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("Failed to validate SDK " + sdk2 + ". " + e.getMessage(), (Throwable)e);
            return null;
        }
        return new UnknownInvalidSdk(sdk2, sdkType);
    }
}

