/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkConfigurationUtil {
    private static final Logger LOG = Logger.getInstance(SdkConfigurationUtil.class);

    private SdkConfigurationUtil() {
    }

    public static void createSdk(@Nullable Project project, Sdk @NotNull [] existingSdks, @NotNull NullableConsumer<? super Sdk> onSdkCreatedCallBack, boolean createIfExists, SdkType ... sdkTypes) {
        SdkConfigurationUtil.createSdk(project, existingSdks, onSdkCreatedCallBack, createIfExists, true, sdkTypes);
    }

    public static void createSdk(@Nullable Project project, final Sdk @NotNull [] existingSdks, final @NotNull NullableConsumer<? super Sdk> onSdkCreatedCallBack, final boolean createIfExists, boolean followSymLinks, final SdkType ... sdkTypes) {
        if (sdkTypes.length == 0) {
            onSdkCreatedCallBack.consume(null);
            return;
        }
        FileChooserDescriptor descriptor2 = SdkConfigurationUtil.createCompositeDescriptor(sdkTypes);
        if (!followSymLinks) {
            descriptor2.setForcedToUseIdeaFileChooser(true);
        }
        VirtualFile suggestedDir = SdkConfigurationUtil.getSuggestedSdkRoot(sdkTypes[0]);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, (VirtualFile)suggestedDir, (Consumer)new FileChooser.FileChooserConsumer(){

            public void consume(List<VirtualFile> selectedFiles) {
                for (SdkType sdkType : sdkTypes) {
                    String path = selectedFiles.get(0).getPath();
                    if (!sdkType.isValidSdkHome(path)) continue;
                    Sdk newSdk = null;
                    if (!createIfExists) {
                        for (Sdk sdk2 : existingSdks) {
                            if (!path.equals(sdk2.getHomePath())) continue;
                            newSdk = sdk2;
                            break;
                        }
                    }
                    if (newSdk == null) {
                        newSdk = SdkConfigurationUtil.setupSdk(existingSdks, selectedFiles.get(0), sdkType, false, null, null);
                    }
                    onSdkCreatedCallBack.consume(newSdk);
                    return;
                }
                onSdkCreatedCallBack.consume(null);
            }

            public void cancelled() {
                onSdkCreatedCallBack.consume(null);
            }
        });
    }

    public static void createSdk(@Nullable Project project, Sdk @NotNull [] existingSdks, @NotNull NullableConsumer<? super Sdk> onSdkCreatedCallBack, SdkType ... sdkTypes) {
        SdkConfigurationUtil.createSdk(project, existingSdks, onSdkCreatedCallBack, true, sdkTypes);
    }

    @NotNull
    private static FileChooserDescriptor createCompositeDescriptor(final SdkType ... sdkTypes) {
        return new FileChooserDescriptor(sdkTypes[0].getHomeChooserDescriptor()){

            public void validateSelectedFiles(VirtualFile @NotNull [] files2) throws Exception {
                if (files2.length > 0) {
                    for (SdkType type : sdkTypes) {
                        if (!type.isValidSdkHome(files2[0].getPath())) continue;
                        return;
                    }
                }
                String key = files2.length > 0 && files2[0].isDirectory() ? "sdk.configure.home.invalid.error" : "sdk.configure.home.file.invalid.error";
                throw new Exception(ProjectBundle.message((String)key, (Object[])new Object[]{sdkTypes[0].getPresentableName()}));
            }
        };
    }

    public static void addSdk(@NotNull Sdk sdk2) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk2));
    }

    public static void removeSdk(@NotNull Sdk sdk2) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(sdk2));
    }

    @Nullable
    public static Sdk setupSdk(Sdk @NotNull [] allSdks, @NotNull VirtualFile homeDir, @NotNull SdkType sdkType, boolean silent, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        ProjectJdkImpl sdk2 = null;
        try {
            sdk2 = SdkConfigurationUtil.createSdk(Arrays.asList(allSdks), homeDir, sdkType, additionalData, customSdkSuggestedName);
            sdkType.setupSdkPaths((Sdk)sdk2);
        }
        catch (Throwable e) {
            LOG.warn("Error creating or configuring sdk: homeDir=[" + homeDir + "]; sdkType=[" + sdkType + "]; additionalData=[" + additionalData + "]; customSdkSuggestedName=[" + customSdkSuggestedName + "]; sdk=[" + (Object)((Object)sdk2) + "]", e);
            if (!silent) {
                Messages.showErrorDialog((String)ProjectBundle.message((String)"dialog.message.error.configuring.sdk.0.please.make.sure.that.1.is.a.valid.home.path.for.this.sdk.type", (Object[])new Object[]{e.getMessage(), FileUtil.toSystemDependentName((String)homeDir.getPath())}), (String)ProjectBundle.message((String)"dialog.title.error.configuring.sdk", (Object[])new Object[0]));
            }
            return null;
        }
        return sdk2;
    }

    @NotNull
    public static ProjectJdkImpl createSdk(@NotNull Collection<? extends Sdk> allSdks, @NotNull VirtualFile homeDir, @NotNull SdkType sdkType, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        return SdkConfigurationUtil.createSdk(allSdks, sdkType.sdkPath(homeDir), sdkType, additionalData, customSdkSuggestedName);
    }

    @NotNull
    public static ProjectJdkImpl createSdk(@NotNull Collection<? extends Sdk> allSdks, @NotNull String homePath, @NotNull SdkType sdkType, @Nullable SdkAdditionalData additionalData, @Nullable String customSdkSuggestedName) {
        String sdkName = customSdkSuggestedName == null ? SdkConfigurationUtil.createUniqueSdkName(sdkType, homePath, allSdks) : SdkConfigurationUtil.createUniqueSdkName(customSdkSuggestedName, allSdks);
        ProjectJdkImpl sdk2 = new ProjectJdkImpl(sdkName, (SdkTypeId)sdkType);
        if (additionalData != null) {
            sdk2.setSdkAdditionalData(additionalData);
        }
        sdk2.setHomePath(homePath);
        return sdk2;
    }

    public static void setDirectoryProjectSdk(@NotNull Project project, @Nullable Sdk sdk2) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ProjectRootManager.getInstance((Project)project).setProjectSdk(sdk2);
            Module[] modules2 = ModuleManager.getInstance((Project)project).getModules();
            if (modules2.length > 0) {
                ModuleRootModificationUtil.setSdkInherited((Module)modules2[0]);
            }
        });
    }

    public static void configureDirectoryProjectSdk(@NotNull Project project, @Nullable Comparator<? super Sdk> preferredSdkComparator, SdkType ... sdkTypes) {
        Sdk existingSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (existingSdk != null && ArrayUtil.contains((Object)existingSdk.getSdkType(), (Object[])sdkTypes)) {
            return;
        }
        Sdk sdk2 = SdkConfigurationUtil.findOrCreateSdk(preferredSdkComparator, sdkTypes);
        if (sdk2 != null) {
            SdkConfigurationUtil.setDirectoryProjectSdk(project, sdk2);
        }
    }

    @Nullable
    public static Sdk findOrCreateSdk(@Nullable Comparator<? super Sdk> comparator2, SdkType ... sdkTypes) {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        Sdk sdk2 = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
        if (sdk2 != null) {
            for (SdkType type : sdkTypes) {
                if (sdk2.getSdkType() != type) continue;
                return sdk2;
            }
        }
        for (SdkType type : sdkTypes) {
            List sdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)type);
            if (sdks.isEmpty()) continue;
            if (comparator2 != null) {
                sdks.sort(comparator2);
            }
            return (Sdk)sdks.get(0);
        }
        for (SdkType sdkType : sdkTypes) {
            for (String suggestedHomePath : sdkType.suggestHomePaths()) {
                Sdk an_sdk;
                if (!sdkType.isValidSdkHome(suggestedHomePath) || (an_sdk = SdkConfigurationUtil.createAndAddSDK(suggestedHomePath, sdkType)) == null) continue;
                return an_sdk;
            }
        }
        return null;
    }

    @Nullable
    public static Sdk createAndAddSDK(@NotNull String path, @NotNull SdkType sdkType) {
        VirtualFile sdkHome = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(path));
        if (sdkHome != null) {
            Sdk newSdk = SdkConfigurationUtil.setupSdk(ProjectJdkTable.getInstance().getAllJdks(), sdkHome, sdkType, true, null, null);
            if (newSdk != null) {
                SdkConfigurationUtil.addSdk(newSdk);
            }
            return newSdk;
        }
        return null;
    }

    @NotNull
    public static String createUniqueSdkName(@NotNull SdkType type, String home, Collection<? extends Sdk> sdks) {
        return SdkConfigurationUtil.createUniqueSdkName(type.suggestSdkName(null, home), sdks);
    }

    @NotNull
    public static String createUniqueSdkName(@NotNull String suggestedName, @NotNull Collection<? extends Sdk> sdks) {
        Set nameList = sdks.stream().map(jdk -> jdk.getName()).collect(Collectors.toSet());
        return UniqueNameGenerator.generateUniqueName((String)suggestedName, (String)"", (String)"", (String)" (", (String)")", o -> !nameList.contains(o));
    }

    public static void selectSdkHome(@NotNull SdkType sdkType, @NotNull Consumer<? super String> consumer) {
        SdkConfigurationUtil.selectSdkHome(sdkType, null, consumer);
    }

    public static void selectSdkHome(@NotNull SdkType sdkType, @Nullable Component component2, @NotNull Consumer<? super String> consumer) {
        FileChooserDescriptor descriptor2 = sdkType.getHomeChooserDescriptor();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Sdk sdk2 = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)sdkType);
            if (sdk2 == null) {
                throw new RuntimeException("No SDK of type " + sdkType + " found");
            }
            consumer.consume((Object)sdk2.getHomePath());
            return;
        }
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, (Component)component2, (VirtualFile)SdkConfigurationUtil.getSuggestedSdkRoot(sdkType), chosen -> {
            String path = ((VirtualFile)chosen.get(0)).getPath();
            if (sdkType.isValidSdkHome(path)) {
                consumer.consume((Object)path);
                return;
            }
            String adjustedPath = sdkType.adjustSelectedSdkHome(path);
            if (sdkType.isValidSdkHome(adjustedPath)) {
                consumer.consume((Object)adjustedPath);
            }
        });
    }

    @Nullable
    public static VirtualFile getSuggestedSdkRoot(@NotNull SdkType sdkType) {
        String homePath = sdkType.suggestHomePath();
        return homePath == null ? null : LocalFileSystem.getInstance().findFileByPath(homePath);
    }

    @NotNull
    public static List<String> filterExistingPaths(@NotNull SdkType sdkType, Collection<String> sdkHomes, Sdk[] sdks) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (String sdkHome : sdkHomes) {
            if (SdkConfigurationUtil.findByPath(sdkType, sdks, sdkHome) != null) continue;
            result2.add(sdkHome);
        }
        return result2;
    }

    @Nullable
    private static Sdk findByPath(@NotNull SdkType sdkType, Sdk @NotNull [] sdks, @NotNull String sdkHome) {
        for (Sdk sdk2 : sdks) {
            String path = sdk2.getHomePath();
            if (sdk2.getSdkType() != sdkType || path == null || !FileUtil.pathsEqual((String)FileUtil.toSystemIndependentName((String)path), (String)FileUtil.toSystemIndependentName((String)sdkHome))) continue;
            return sdk2;
        }
        return null;
    }
}

