/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ex;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathUtilEx {
    @Nullable
    public static Sdk getAnyJdk(@NotNull Project project) {
        return PathUtilEx.chooseJdk(project, Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
    }

    @Nullable
    public static Sdk chooseJdk(@NotNull Project project, @NotNull Collection<? extends Module> modules2) {
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (projectJdk != null) {
            return projectJdk;
        }
        return PathUtilEx.chooseJdk(modules2);
    }

    @Nullable
    public static Sdk chooseJdk(@NotNull Collection<? extends Module> modules2) {
        List jdks = ContainerUtil.mapNotNull(modules2, module -> module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk());
        if (jdks.isEmpty()) {
            return null;
        }
        jdks.sort(ComparatorUtil.compareBy(jdk -> StringUtil.notNullize((String)jdk.getVersionString()), (Comparator)String.CASE_INSENSITIVE_ORDER));
        return (Sdk)jdks.get(jdks.size() - 1);
    }
}

