/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.conversion.CannotConvertException;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectCloseHandler;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ExcludeRootsCache;
import com.intellij.openapi.project.impl.ProjectExImpl;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectLoadHelper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectManagerImpl
extends ProjectManagerEx
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(ProjectManagerImpl.class);
    private static final Key<List<ProjectManagerListener>> LISTENERS_IN_PROJECT_KEY = Key.create((String)"LISTENERS_IN_PROJECT_KEY");
    private static final ExtensionPointName<ProjectCloseHandler> CLOSE_HANDLER_EP = new ExtensionPointName("com.intellij.projectCloseHandler");
    private Project @NotNull [] myOpenProjects = new Project[0];
    private final Map<String, Project> myOpenProjectByHash = new ConcurrentHashMap<String, Project>();
    private final Object lock = new Object();
    private final List<ProjectManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final DefaultProject myDefaultProject = new DefaultProject();
    private final ExcludeRootsCache myExcludeRootsCache;

    @NotNull
    private static List<ProjectManagerListener> getListeners(@NotNull Project project) {
        List array2 = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (array2 == null) {
            return Collections.emptyList();
        }
        return array2;
    }

    public ProjectManagerImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectOpened(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosed(@NotNull Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosed(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosing(@NotNull Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosing(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }

            public void projectClosingBeforeSave(@NotNull Project project) {
                for (ProjectManagerListener listener2 : ProjectManagerImpl.this.getAllListeners(project)) {
                    try {
                        listener2.projectClosingBeforeSave(project);
                    }
                    catch (Exception e) {
                        ProjectManagerImpl.handleListenerError(e, listener2);
                    }
                }
            }
        });
        this.myExcludeRootsCache = new ExcludeRootsCache(connection);
    }

    @NotNull
    private static ProjectManagerListener getPublisher() {
        return (ProjectManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
    }

    private static void handleListenerError(@NotNull Throwable e, @NotNull ProjectManagerListener listener2) {
        if (e instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)e;
        }
        LOG.error("From the listener " + listener2 + " (" + listener2.getClass() + ")", e);
    }

    public void dispose() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Disposer.dispose((Disposable)this.myDefaultProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initProject(@NotNull Path file2, @NotNull ProjectImpl project, boolean isRefreshVfsNeeded, @Nullable Project template, @Nullable ProgressIndicator indicator) {
        LOG.assertTrue(!project.isDefault());
        boolean succeed = false;
        try {
            if (indicator != null) {
                indicator.setIndeterminate(false);
                indicator.setText(ProjectBundle.message((String)"project.loading.components", (Object[])new Object[0]));
            }
            Activity activity = StartUpMeasurer.startMainActivity((String)"project before loaded callbacks");
            ((ProjectLifecycleListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).beforeProjectLoaded((Project)project);
            activity.end();
            ProjectLoadHelper.registerComponents(project);
            project.getStateStore().setPath(file2, isRefreshVfsNeeded, template);
            project.init(indicator);
            succeed = true;
        }
        finally {
            if (!succeed) {
                WriteAction.runAndWait(() -> Disposer.dispose((Disposable)project));
            }
        }
    }

    @Override
    @NotNull
    public Project loadProject(@NotNull Path file2) {
        ProjectExImpl project = new ProjectExImpl(file2, null);
        ProjectManagerImpl.initProject(file2, project, true, null, ProgressManager.getInstance().getProgressIndicator());
        return project;
    }

    @Override
    public boolean isDefaultProjectInitialized() {
        return this.myDefaultProject.isCached();
    }

    @NotNull
    public Project getDefaultProject() {
        LOG.assertTrue(!ApplicationManager.getApplication().isDisposed(), (Object)"Default project has been already disposed!");
        LOG.assertTrue(!this.myDefaultProject.getMessageBus().isDisposed());
        LOG.assertTrue(this.myDefaultProject.isCached());
        return this.myDefaultProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project @NotNull [] getOpenProjects() {
        Object object = this.lock;
        synchronized (object) {
            return this.myOpenProjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProjectOpened(@NotNull Project project) {
        Object object = this.lock;
        synchronized (object) {
            return ArrayUtil.contains((Object)project, (Object[])this.myOpenProjects);
        }
    }

    @Override
    public boolean openProject(@NotNull Project project) {
        IProjectStore store;
        IProjectStore iProjectStore = store = project instanceof ProjectStoreOwner ? ((ProjectStoreOwner)project).getComponentStore() : null;
        if (store != null) {
            Path projectFilePath = store.getStorageScheme() == StorageScheme.DIRECTORY_BASED ? store.getDirectoryStorePath() : Paths.get(store.getProjectFilePath(), new String[0]);
            for (Project p : this.getOpenProjects()) {
                if (!ProjectUtil.isSameProject(projectFilePath, p)) continue;
                GuiUtils.invokeLaterIfNeeded(() -> ProjectUtil.focusProjectWindow(p, false), (ModalityState)ModalityState.NON_MODAL);
                return false;
            }
        }
        return this.doOpenProject(project);
    }

    abstract boolean doOpenProject(@NotNull Project var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean addToOpened(@NotNull Project project) {
        assert (!project.isDisposed()) : "Must not open already disposed project";
        Object object = this.lock;
        synchronized (object) {
            if (this.isProjectOpened(project)) {
                return false;
            }
            this.myOpenProjects = (Project[])ArrayUtil.append((Object[])this.myOpenProjects, (Object)project);
        }
        this.updateTheOnlyProjectField();
        this.myOpenProjectByHash.put(project.getLocationHash(), project);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTheOnlyProjectField() {
        boolean isDefaultInitialized = this.isDefaultProjectInitialized();
        Object object = this.lock;
        synchronized (object) {
            ProjectCoreUtil.theProject = this.myOpenProjects.length == 1 && !isDefaultInitialized ? this.myOpenProjects[0] : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromOpened(@NotNull Project project) {
        Object object = this.lock;
        synchronized (object) {
            this.myOpenProjects = (Project[])ArrayUtil.remove((Object[])this.myOpenProjects, (Object)project);
            this.myOpenProjectByHash.values().remove(project);
        }
    }

    @Override
    @Nullable
    public Project findOpenProjectByHash(@Nullable String locationHash) {
        return this.myOpenProjectByHash.get(locationHash);
    }

    public static void showCannotConvertMessage(@NotNull CannotConvertException e, @Nullable Component component2) {
        AppUIUtil.invokeOnEdt(() -> Messages.showErrorDialog((Component)component2, (String)IdeBundle.message((String)"error.cannot.convert.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.convert.project", (Object[])new Object[0])));
    }

    public void reloadProject(@NotNull Project project) {
        StoreReloadManager.getInstance().reloadProject(project);
    }

    public final boolean closeProject(@NotNull Project project) {
        return this.closeProject(project, true, false, true);
    }

    @Override
    public boolean forceCloseProject(@NotNull Project project) {
        return this.closeProject(project, false, true, false);
    }

    @Override
    public boolean closeAndDisposeAllProjects(boolean checkCanClose) {
        for (Project project : this.getOpenProjects()) {
            if (this.closeProject(project, true, true, checkCanClose)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean closeProject(@NotNull Project project, boolean saveProject, boolean dispose2, boolean checkCanClose) {
        Application app = ApplicationManager.getApplication();
        if (app.isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeProject() from under write action because fireProjectClosing() listeners must have a chance to do something useful");
        }
        app.assertIsWriteThread();
        if (ProjectManagerImpl.isLight(project)) {
            ProjectExImpl projectImpl = (ProjectExImpl)project;
            if (!projectImpl.isTemporarilyDisposed()) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    projectImpl.disposeEarlyDisposable();
                    projectImpl.setTemporarilyDisposed(true);
                    this.removeFromOpened(project);
                });
                this.updateTheOnlyProjectField();
                return true;
            }
            projectImpl.setTemporarilyDisposed(false);
        } else if (!this.isProjectOpened(project)) {
            if (dispose2) {
                if (project instanceof ComponentManagerImpl) {
                    ((ComponentManagerImpl)project).stopServicePreloading();
                }
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project instanceof ProjectExImpl) {
                        ProjectExImpl projectImpl = (ProjectExImpl)project;
                        projectImpl.disposeEarlyDisposable();
                        projectImpl.startDispose();
                    }
                    Disposer.dispose((Disposable)project);
                });
            }
            return true;
        }
        if (checkCanClose && !this.canClose(project)) {
            return false;
        }
        ShutDownTracker shutDownTracker = ShutDownTracker.getInstance();
        shutDownTracker.registerStopperThread(Thread.currentThread());
        try {
            if (project instanceof ComponentManagerImpl) {
                ((ComponentManagerImpl)project).stopServicePreloading();
            }
            ProjectManagerImpl.getPublisher().projectClosingBeforeSave(project);
            if (saveProject) {
                FileDocumentManager.getInstance().saveAllDocuments();
                SaveAndSyncHandler.getInstance().saveSettingsUnderModalProgress((ComponentManager)project);
            }
            if (checkCanClose && !ProjectManagerImpl.ensureCouldCloseIfUnableToSave(project)) {
                boolean bl = false;
                return bl;
            }
            ProjectManagerImpl.fireProjectClosing(project);
            app.runWriteAction(() -> {
                if (project instanceof ProjectExImpl) {
                    ((ProjectExImpl)project).disposeEarlyDisposable();
                    if (dispose2) {
                        ((ProjectExImpl)project).startDispose();
                    }
                }
                this.removeFromOpened(project);
                ProjectManagerImpl.fireProjectClosed(project);
                ZipHandler.clearFileAccessorCache();
                LaterInvocator.purgeExpiredItems();
                if (dispose2) {
                    Disposer.dispose((Disposable)project);
                }
            });
        }
        finally {
            shutDownTracker.unregisterStopperThread(Thread.currentThread());
        }
        return true;
    }

    public static boolean isLight(@NotNull Project project) {
        return project instanceof ProjectEx && ((ProjectEx)project).isLight();
    }

    public boolean closeAndDispose(@NotNull Project project) {
        return this.closeProject(project, true, true, true);
    }

    private static void fireProjectClosing(@NotNull Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: fireProjectClosing()");
        }
        ProjectManagerImpl.getPublisher().projectClosing(project);
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        this.myListeners.add(listener2);
    }

    public void addProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        this.myListeners.add((ProjectManagerListener)listener2);
    }

    public void addProjectManagerListener(@NotNull ProjectManagerListener listener2, @NotNull Disposable parentDisposable) {
        this.addProjectManagerListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeProjectManagerListener(listener2));
    }

    public void removeProjectManagerListener(@NotNull ProjectManagerListener listener2) {
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void removeProjectManagerListener(@NotNull VetoableProjectManagerListener listener2) {
        boolean removed = this.myListeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    public void addProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener2) {
        if (project.isDefault()) {
            return;
        }
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        if (listeners == null) {
            listeners = (List)((UserDataHolderEx)project).putUserDataIfAbsent(LISTENERS_IN_PROJECT_KEY, (Object)ContainerUtil.createLockFreeCopyOnWriteList());
        }
        listeners.add(listener2);
    }

    public void removeProjectManagerListener(@NotNull Project project, @NotNull ProjectManagerListener listener2) {
        if (project.isDefault()) {
            return;
        }
        List listeners = (List)project.getUserData(LISTENERS_IN_PROJECT_KEY);
        LOG.assertTrue(listeners != null);
        boolean removed = listeners.remove(listener2);
        LOG.assertTrue(removed);
    }

    private static void fireProjectClosed(@NotNull Project project) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("projectClosed");
        }
        LifecycleUsageTriggerCollector.onProjectClosed(project);
        ProjectManagerImpl.getPublisher().projectClosed(project);
        List components = project.getComponentInstancesOfType(ProjectComponent.class, false);
        for (int i2 = components.size() - 1; i2 >= 0; --i2) {
            ProjectComponent component2 = (ProjectComponent)components.get(i2);
            try {
                component2.projectClosed();
                continue;
            }
            catch (Throwable e) {
                LOG.error(component2.toString(), e);
            }
        }
    }

    @Override
    public boolean canClose(@NotNull Project project) {
        ProjectCloseHandler handler2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: canClose()");
        }
        Iterator<Object> iterator2 = CLOSE_HANDLER_EP.getIterable().iterator();
        while (iterator2.hasNext() && (handler2 = (ProjectCloseHandler)iterator2.next()) != null) {
            try {
                if (handler2.canClose(project)) continue;
                LOG.debug("close canceled by " + handler2);
                return false;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        for (ProjectManagerListener listener2 : this.getAllListeners(project)) {
            try {
                boolean canClose = listener2 instanceof VetoableProjectManagerListener ? ((VetoableProjectManagerListener)listener2).canClose(project) : listener2.canCloseProject(project);
                if (canClose) continue;
                LOG.debug("close canceled by " + listener2);
                return false;
            }
            catch (Throwable e) {
                ProjectManagerImpl.handleListenerError(e, listener2);
            }
        }
        return true;
    }

    @NotNull
    private List<ProjectManagerListener> getAllListeners(@NotNull Project project) {
        List<ProjectManagerListener> projectLevelListeners = ProjectManagerImpl.getListeners(project);
        if (projectLevelListeners.isEmpty()) {
            return this.myListeners;
        }
        if (this.myListeners.isEmpty()) {
            return projectLevelListeners;
        }
        ArrayList<ProjectManagerListener> result2 = new ArrayList<ProjectManagerListener>(projectLevelListeners.size() + this.myListeners.size());
        result2.addAll(projectLevelListeners);
        result2.addAll(this.myListeners);
        return result2;
    }

    private static boolean ensureCouldCloseIfUnableToSave(@NotNull Project project) {
        NotificationsManager notificationManager2 = (NotificationsManager)ApplicationManager.getApplication().getServiceIfCreated(NotificationsManager.class);
        if (notificationManager2 == null) {
            return true;
        }
        UnableToSaveProjectNotification[] notifications = (UnableToSaveProjectNotification[])notificationManager2.getNotificationsOfType(UnableToSaveProjectNotification.class, project);
        if (notifications.length == 0) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("%s was unable to save some project files,\nare you sure you want to close this project anyway?", ApplicationNamesInfo.getInstance().getProductName()));
        message.append("\n\nRead-only files:\n");
        int count = 0;
        List files2 = notifications[0].myFiles;
        for (VirtualFile file2 : files2) {
            if (count == 10) {
                message.append('\n').append("and ").append(files2.size() - count).append(" more").append('\n');
                continue;
            }
            message.append(file2.getPath()).append('\n');
            ++count;
        }
        return Messages.showYesNoDialog((Project)project, (String)message.toString(), (String)IdeUICustomization.getInstance().projectMessage("dialog.title.unsaved.project", new Object[0]), (Icon)Messages.getWarningIcon()) == 0;
    }

    @Override
    @NotNull
    public List<String> getAllExcludedUrls() {
        return this.myExcludeRootsCache.getExcludedUrls();
    }

    public static class UnableToSaveProjectNotification
    extends Notification {
        private Project myProject;
        private List<VirtualFile> myFiles;

        public void setFiles(@NotNull List<VirtualFile> files2) {
            this.myFiles = files2;
        }

        public UnableToSaveProjectNotification(@NotNull Project project, @NotNull List<VirtualFile> readOnlyFiles) {
            super(NotificationGroup.createIdWithTitle((String)"Project Settings", (String)IdeBundle.message((String)"notification.group.project.settings", (Object[])new Object[0])), IdeUICustomization.getInstance().projectMessage("notification.title.cannot.save.project", new Object[0]), IdeBundle.message((String)"notification.content.unable.to.save.project.files", (Object[])new Object[0]), NotificationType.ERROR, (notification, event) -> {
                UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification;
                Project _project = unableToSaveProjectNotification.myProject;
                notification.expire();
                if (_project != null && !_project.isDisposed()) {
                    _project.save();
                }
            });
            this.myProject = project;
            this.myFiles = readOnlyFiles;
        }

        public void expire() {
            this.myProject = null;
            super.expire();
        }
    }
}

