/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerExImpl;
import com.intellij.openapi.project.impl.ProjectManagerExImplKt;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.serviceContainer.ContainerUtilKt;
import com.intellij.util.io.PathKt;
import java.awt.AWTEvent;
import java.awt.event.InvocationEvent;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a8\u0006\u001a"}, d2={"checkExistingProjectOnOpen", "", "projectToClose", "Lcom/intellij/openapi/project/Project;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "projectDir", "Ljava/nio/file/Path;", "projectManager", "Lcom/intellij/openapi/project/impl/ProjectManagerExImpl;", "message", "", "e", "", "openProject", "", "project", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "removeProjectDirContentOrFile", "projectFile", "toCanonicalName", "filePath", "waitAndProcessInvocationEventsInIdeEventQueue", "startupManager", "Lcom/intellij/ide/startup/impl/StartupManagerImpl;", "intellij.platform.ide.impl"})
public final class ProjectManagerExImplKt {
    private static final String message(Throwable e) {
        String message;
        String string = e.getMessage();
        if (string == null) {
            string = message = e.getLocalizedMessage();
        }
        if (message != null) {
            return message;
        }
        message = e.toString();
        Throwable throwable = e.getCause();
        if (throwable == null) {
            return message;
        }
        String causeMessage = ProjectManagerExImplKt.message(throwable);
        return message + " (cause: " + causeMessage + ')';
    }

    private static final boolean checkExistingProjectOnOpen(Project projectToClose, ProjectOpenedCallback callback2, Path projectDir, ProjectManagerExImpl projectManager) {
        boolean isValidProject;
        GeneralSettings settings = GeneralSettings.getInstance();
        boolean bl = isValidProject = projectDir != null && ProjectUtil.isValidProjectPath(projectDir);
        if (projectDir != null && ProjectAttachProcessor.canAttachToProject() && (!isValidProject || settings.getConfirmOpenNewProject() == -1)) {
            int exitCode = ProjectUtil.confirmOpenOrAttachProject();
            if (exitCode == -1) {
                return true;
            }
            if (exitCode == 1 ? !projectManager.closeAndDispose(projectToClose) : exitCode == 2 && PlatformProjectOpenProcessor.Companion.attachToProject(projectToClose, projectDir, callback2)) {
                return true;
            }
            IdeEventQueue.getInstance().flushQueue();
        } else {
            int exitCode = ProjectUtil.confirmOpenNewProject(false);
            if (exitCode == 1 ? !projectManager.closeAndDispose(projectToClose) : exitCode != 0) {
                return true;
            }
        }
        return false;
    }

    private static final void openProject(Project project, ProgressIndicator indicator) {
        Activity waitEdtActivity = StartUpMeasurer.startMainActivity((String)"placing calling projectOpened on event queue");
        if (indicator != null) {
            indicator.setText(ApplicationManager.getApplication().isInternal() ? "Waiting on event queue..." : ProjectBundle.message((String)"project.preparing.workspace", (Object[])new Object[0]));
            indicator.setIndeterminate(true);
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(waitEdtActivity, indicator, project){
            final /* synthetic */ Activity $waitEdtActivity;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Project $project;

            public final void run() {
                this.$waitEdtActivity.end();
                if (this.$indicator != null && ApplicationManager.getApplication().isInternal()) {
                    this.$indicator.setText("Running project opened tasks...");
                }
                ProjectManagerImpl.LOG.debug("projectOpened");
                LifecycleUsageTriggerCollector.onProjectOpened(this.$project);
                Activity activity = StartUpMeasurer.startMainActivity((String)"project opened callbacks");
                ((ProjectManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectManager.TOPIC)).projectOpened(this.$project);
                ContainerUtilKt.processProjectComponents((PicoContainer)this.$project.getPicoContainer(), (Function2)openProject.1.INSTANCE);
                activity.end();
                ProjectImpl.ourClassesAreLoaded = true;
            }
            {
                this.$waitEdtActivity = activity;
                this.$indicator = progressIndicator2;
                this.$project = project;
            }
        });
        Boolean runStartUpActivitiesFlag = (Boolean)project.getUserData(ProjectManagerExImpl.Companion.getRUN_START_UP_ACTIVITIES());
        if (runStartUpActivitiesFlag == null || runStartUpActivitiesFlag.booleanValue()) {
            StartupManager startupManager = StartupManager.getInstance((Project)project);
            if (startupManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.startup.impl.StartupManagerImpl");
            }
            ((StartupManagerImpl)startupManager).projectOpened(indicator);
        }
    }

    public static final void waitAndProcessInvocationEventsInIdeEventQueue(@NotNull StartupManagerImpl startupManager) {
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while (true) {
            if (eventQueue.peekEvent() == null) {
                if (!startupManager.postStartupActivityPassed()) continue;
                break;
            }
            AWTEvent event = eventQueue.getNextEvent();
            if (!(event instanceof InvocationEvent)) continue;
            eventQueue.dispatchEvent(event);
        }
    }

    private static final Path toCanonicalName(String filePath) {
        Path file2 = Paths.get(filePath, new String[0]);
        try {
            if (SystemInfoRt.isWindows && FileUtil.containsWindowsShortName((String)filePath)) {
                return file2.toRealPath(LinkOption.NOFOLLOW_LINKS);
            }
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void removeProjectDirContentOrFile(Path projectFile) {
        if (Files.isRegularFile(projectFile, new LinkOption[0])) {
            try {
                Files.deleteIfExists(projectFile);
            }
            catch (IOException iOException) {}
        } else {
            try {
                Closeable closeable = Files.newDirectoryStream(projectFile.resolve(".idea"));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    DirectoryStream directoryStream = (DirectoryStream)closeable;
                    boolean bl3 = false;
                    Iterator iterator2 = directoryStream.iterator();
                    while (iterator2.hasNext()) {
                        Path file2;
                        Path path = file2 = (Path)iterator2.next();
                        if (path == null) {
                            Intrinsics.throwNpe();
                        }
                        PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final /* synthetic */ Path access$toCanonicalName(String filePath) {
        return ProjectManagerExImplKt.toCanonicalName(filePath);
    }

    public static final /* synthetic */ boolean access$checkExistingProjectOnOpen(Project projectToClose, ProjectOpenedCallback callback2, Path projectDir, ProjectManagerExImpl projectManager) {
        return ProjectManagerExImplKt.checkExistingProjectOnOpen(projectToClose, callback2, projectDir, projectManager);
    }

    public static final /* synthetic */ void access$openProject(Project project, ProgressIndicator indicator) {
        ProjectManagerExImplKt.openProject(project, indicator);
    }

    public static final /* synthetic */ void access$removeProjectDirContentOrFile(Path projectFile) {
        ProjectManagerExImplKt.removeProjectDirContentOrFile(projectFile);
    }

    public static final /* synthetic */ String access$message(Throwable e) {
        return ProjectManagerExImplKt.message(e);
    }
}

