/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.idea.ApplicationLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectLoadHelper;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.ExceptionUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectImpl
extends ComponentManagerImpl
implements ProjectEx {
    protected static final Logger LOG = Logger.getInstance(ProjectImpl.class);
    public static final Key<Long> CREATION_TIME = Key.create((String)"ProjectImpl.CREATION_TIME");
    public static final String LIGHT_PROJECT_NAME = "light_temp";
    protected String myName;
    static boolean ourClassesAreLoaded;
    private final String creationTrace = ApplicationManager.getApplication().isUnitTestMode() ? ExceptionUtil.currentStackTrace() : null;

    protected ProjectImpl(@NotNull ComponentManagerImpl parent) {
        super(parent);
    }

    @Override
    public void setProjectName(@NotNull String projectName) {
        if (projectName.equals(this.myName)) {
            return;
        }
        this.myName = projectName;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance((Project)this).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
                JFrame frame = WindowManager.getInstance().getFrame((Project)this);
                String title = FrameTitleBuilder.getInstance().getProjectTitle(this);
                if (frame != null && title != null) {
                    frame.setTitle(title);
                }
            }, ModalityState.NON_MODAL, this.getDisposed()));
        }
    }

    public boolean isOpen() {
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceExIfCreated();
        return projectManager != null && projectManager.isProjectOpened(this);
    }

    public boolean isInitialized() {
        return this.getComponentCreated() && !this.isDisposed() && this.isOpen() && StartupManagerEx.getInstanceEx(this).startupActivityPassed();
    }

    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        return pluginDescriptor.getProject();
    }

    @NotNull
    public String getName() {
        if (this.myName == null) {
            return this.getStateStore().getProjectName();
        }
        return this.myName;
    }

    protected abstract IProjectStore getStateStore();

    public void init(@Nullable ProgressIndicator indicator) {
        Application application = ApplicationManager.getApplication();
        List<? extends IdeaPluginDescriptor> plugins = PluginManagerCore.getLoadedPlugins();
        CompletableFuture<Void> servicePreloadingFuture = ApplicationLoader.preloadServices(plugins, this, "project ", this.isLight());
        this.createComponents(indicator);
        servicePreloadingFuture.join();
        if (indicator != null && !application.isHeadlessEnvironment()) {
            this.distributeProgress(indicator);
        }
        if (this.myName == null) {
            this.myName = this.getStateStore().getProjectName();
        }
        ProjectLoadHelper.notifyThatComponentCreated(this);
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
        indicator.setFraction(this.getPercentageOfComponentsLoaded() / (double)(ourClassesAreLoaded ? 10 : 2));
    }

    private void distributeProgress(@NotNull ProgressIndicator indicator) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this);
        if (!(moduleManager instanceof ModuleManagerImpl)) {
            return;
        }
        double toDistribute = 1.0 - indicator.getFraction();
        int modulesCount = ((ModuleManagerImpl)moduleManager).getModulePathsCount();
        if (modulesCount != 0) {
            ((ModuleManagerImpl)moduleManager).setProgressStep(toDistribute / (double)modulesCount);
        }
    }

    public void save() {
        if (!ApplicationManagerEx.getApplicationEx().isSaveAllowed()) {
            return;
        }
        if (!this.isInitialized()) {
            LOG.debug("Skip save for " + this.getName() + ": not initialized");
            return;
        }
        StoreUtil.saveSettings((ComponentManager)this, false);
    }

    @Override
    public String getCreationTrace() {
        return this.creationTrace;
    }
}

