/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.ui.GuiUtils;
import com.intellij.util.TimedReference;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultProjectTimed
extends TimedReference<Project> {
    @NotNull
    private final DefaultProject myParentDisposable;

    DefaultProjectTimed(@NotNull DefaultProject disposable2) {
        super((Disposable)disposable2);
        this.myParentDisposable = disposable2;
    }

    @NotNull
    abstract Project compute();

    abstract void init(@NotNull Project var1);

    @NotNull
    public synchronized Project get() {
        Project value2 = (Project)super.get();
        if (value2 == null) {
            value2 = this.compute();
            this.set(value2);
            this.init(value2);
            ((ProjectManagerImpl)ProjectManager.getInstance()).updateTheOnlyProjectField();
        }
        return value2;
    }

    public void dispose() {
        Runnable doDispose = () -> {
            if (!ApplicationManager.getApplication().isDisposed() && this.isCached()) {
                WriteCommandAction.runWriteCommandAction(null, () -> super.dispose());
            }
        };
        GuiUtils.invokeLaterIfNeeded((Runnable)doDispose, (ModalityState)ModalityState.NON_MODAL, this.myParentDisposable.getDisposed());
    }
}

