/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.ComponentManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

final class DefaultProjectImpl
extends ComponentManagerImpl
implements Project {
    private static final Logger LOG = Logger.getInstance(DefaultProjectImpl.class);
    static final String TEMPLATE_PROJECT_NAME = "Default (Template) Project";
    static final int DEFAULT_HASH_CODE = 4;
    private final Project actualContainerInstance;

    DefaultProjectImpl(@NotNull Project actualContainerInstance) {
        super((ComponentManagerImpl)ApplicationManager.getApplication());
        this.actualContainerInstance = actualContainerInstance;
    }

    public boolean isParentLazyListenersIgnored() {
        return true;
    }

    protected void setProgressDuringInit(@NotNull ProgressIndicator indicator) {
    }

    public boolean isDefault() {
        return true;
    }

    public boolean isInitialized() {
        return true;
    }

    @NotNull
    protected ComponentManager getActualContainerInstance() {
        return this.actualContainerInstance;
    }

    @Nullable
    public String activityNamePrefix() {
        return null;
    }

    protected boolean isComponentSuitable(@NotNull ComponentConfig componentConfig) {
        return super.isComponentSuitable(componentConfig) && componentConfig.isLoadForDefaultProject();
    }

    public void init() {
        this.registerServiceInstance(Project.class, this.actualContainerInstance, (PluginDescriptor)ComponentManagerImpl.getFakeCorePluginDescriptor());
        this.registerComponents(PluginManagerCore.getLoadedPlugins());
        this.createComponents(null);
        Disposer.register((Disposable)this.actualContainerInstance, (Disposable)this);
    }

    public String toString() {
        return "Project" + (this.isDisposed() ? " (Disposed)" : "") + TEMPLATE_PROJECT_NAME;
    }

    public boolean equals(Object o) {
        return o instanceof Project && ((Project)o).isDefault();
    }

    public int hashCode() {
        return 4;
    }

    @NotNull
    protected ContainerDescriptor getContainerDescriptor(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        return pluginDescriptor.getProject();
    }

    @NotNull
    public String getName() {
        return TEMPLATE_PROJECT_NAME;
    }

    public VirtualFile getBaseDir() {
        return null;
    }

    @Nullable
    public @SystemIndependent String getBasePath() {
        return null;
    }

    @Nullable
    public VirtualFile getProjectFile() {
        return null;
    }

    @Nullable
    public @SystemIndependent String getProjectFilePath() {
        return null;
    }

    @Nullable
    public VirtualFile getWorkspaceFile() {
        return null;
    }

    @NotNull
    public String getLocationHash() {
        return Integer.toHexString(TEMPLATE_PROJECT_NAME.hashCode());
    }

    public void save() {
        LOG.error("Do not call save for default project");
        if (ApplicationManagerEx.getApplicationEx().isSaveAllowed()) {
            StoreUtil.saveSettings((ComponentManager)this, false);
        }
    }

    public boolean isOpen() {
        return false;
    }

    public void dispose() {
        this.beforeTreeDispose();
        super.dispose();
    }
}

