/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.DefaultProjectImpl;
import com.intellij.openapi.project.impl.DefaultProjectTimed;
import com.intellij.openapi.project.impl.ProjectStoreFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.util.messages.MessageBus;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;
import org.picocontainer.PicoContainer;

final class DefaultProject
extends UserDataHolderBase
implements Project {
    private static final Logger LOG = Logger.getInstance(DefaultProject.class);
    private final DefaultProjectTimed myDelegate = new DefaultProjectTimed(this){

        @Override
        @NotNull
        Project compute() {
            LOG.assertTrue(!ApplicationManager.getApplication().isDisposed(), (Object)"Application is being disposed!");
            DefaultProjectImpl project = new DefaultProjectImpl(DefaultProject.this);
            ProjectStoreFactory componentStoreFactory = (ProjectStoreFactory)ApplicationManager.getApplication().getService(ProjectStoreFactory.class);
            project.registerServiceInstance(IComponentStore.class, componentStoreFactory.createDefaultProjectStore(project), (PluginDescriptor)ComponentManagerImpl.getFakeCorePluginDescriptor());
            return project;
        }

        @Override
        void init(@NotNull Project project) {
            ((DefaultProjectImpl)project).init();
        }
    };

    DefaultProject() {
    }

    @NotNull
    public <T> T instantiateExtensionWithPicoContainerOnlyIfNeeded(@Nullable String name, @Nullable PluginDescriptor pluginDescriptor) {
        return (T)this.getDelegate().instantiateExtensionWithPicoContainerOnlyIfNeeded(name, pluginDescriptor);
    }

    public <T> T instantiateClass(@NotNull Class<T> aClass, @Nullable PluginId pluginId) {
        return (T)this.getDelegate().instantiateClass(aClass, pluginId);
    }

    public <T> T instantiateClassWithConstructorInjection(@NotNull Class<T> aClass, @NotNull Object key, @NotNull PluginId pluginId) {
        return (T)this.getDelegate().instantiateClassWithConstructorInjection(aClass, key, pluginId);
    }

    @NotNull
    public RuntimeException createError(@NotNull String message, @NotNull PluginId pluginId) {
        return this.getDelegate().createError(message, pluginId);
    }

    public void logError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        this.getDelegate().logError(error, pluginId);
    }

    @NotNull
    public RuntimeException createError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        return this.getDelegate().createError(error, pluginId);
    }

    public boolean hasComponent(@NotNull Class<?> interfaceClass) {
        return this.getDelegate().hasComponent(interfaceClass);
    }

    public boolean equals(Object o) {
        return o instanceof Project && ((Project)o).isDefault();
    }

    public int hashCode() {
        return 4;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDelegate);
    }

    @NotNull
    private Project getDelegate() {
        return this.myDelegate.get();
    }

    public boolean isCached() {
        return this.myDelegate.isCached();
    }

    @NotNull
    public String getName() {
        return "Default (Template) Project";
    }

    @Deprecated
    public VirtualFile getBaseDir() {
        return null;
    }

    @Nullable
    public @SystemIndependent String getBasePath() {
        return null;
    }

    @Nullable
    public VirtualFile getProjectFile() {
        return null;
    }

    @Nullable
    public @SystemIndependent String getProjectFilePath() {
        return null;
    }

    @Nullable
    public VirtualFile getWorkspaceFile() {
        return null;
    }

    @NotNull
    public String getLocationHash() {
        return this.getName();
    }

    public void save() {
        this.getDelegate().save();
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean isDefault() {
        return true;
    }

    @Deprecated
    public BaseComponent getComponent(@NotNull String name) {
        return this.getDelegate().getComponent(name);
    }

    @NotNull
    public <T> List<T> getComponentInstancesOfType(@NotNull Class<T> baseClass, boolean createIfNotYet) {
        return this.getDelegate().getComponentInstancesOfType(baseClass, createIfNotYet);
    }

    public <T> T getService(@NotNull Class<T> serviceClass) {
        return (T)this.getDelegate().getService(serviceClass);
    }

    @Nullable
    public <T> T getServiceIfCreated(@NotNull Class<T> serviceClass) {
        return (T)this.getDelegate().getServiceIfCreated(serviceClass);
    }

    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        return (T)this.getDelegate().getComponent(interfaceClass);
    }

    @NotNull
    public PicoContainer getPicoContainer() {
        return this.getDelegate().getPicoContainer();
    }

    @NotNull
    public ExtensionsArea getExtensionArea() {
        return this.getDelegate().getExtensionArea();
    }

    @NotNull
    public MessageBus getMessageBus() {
        return this.getDelegate().getMessageBus();
    }

    public boolean isDisposed() {
        return ApplicationManager.getApplication().isDisposed();
    }

    @NotNull
    public Condition<?> getDisposed() {
        return ApplicationManager.getApplication().getDisposed();
    }
}

