/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Producer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promises;

final class TrackedEdtActivityService {
    private final Project myProject;
    private volatile ModalityState myDumbStartModality;
    private final BlockingQueue<TrackedEdtActivity> myTrackedEdtActivities = new LinkedBlockingQueue<TrackedEdtActivity>();

    TrackedEdtActivityService(@NotNull Project project) {
        this.myProject = project;
    }

    void executeAllQueuedActivities() {
        while (!this.myTrackedEdtActivities.isEmpty()) {
            ((TrackedEdtActivity)this.myTrackedEdtActivities.poll()).run();
        }
    }

    private void invokeLater(@NotNull Runnable action2) {
        new TrackedEdtActivity(action2).invokeLater();
    }

    void invokeLaterIfProjectNotDisposed(@NotNull Runnable action2) {
        new TrackedEdtActivity(action2).invokeLaterIfProjectNotDisposed();
    }

    void invokeLaterAfterProjectInitialized(@NotNull Runnable action2) {
        new TrackedEdtActivity(action2).invokeLaterAfterProjectInitialized();
    }

    public void setDumbStartModality(@NotNull ModalityState modality) {
        this.myDumbStartModality = modality;
    }

    public <T> T computeInEdt(@NotNull Producer<T> task2) {
        AsyncPromise promise = new AsyncPromise();
        this.invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                promise.setError((Throwable)new ProcessCanceledException());
                return;
            }
            Promises.compute((AsyncPromise)promise, () -> ((Producer)task2).produce());
        });
        try {
            return (T)promise.get();
        }
        catch (Throwable e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof ProcessCanceledException)) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)cause);
            }
            return null;
        }
    }

    private class TrackedEdtActivity
    implements Runnable {
        @NotNull
        private final Runnable myRunnable;

        TrackedEdtActivity(Runnable runnable2) {
            this.myRunnable = runnable2;
            TrackedEdtActivityService.this.myTrackedEdtActivities.add(this);
        }

        void invokeLater() {
            ApplicationManager.getApplication().invokeLater((Runnable)this, this.getActivityExpirationCondition());
        }

        void invokeLaterIfProjectNotDisposed() {
            ApplicationManager.getApplication().invokeLater((Runnable)this, this.getProjectActivityExpirationCondition());
        }

        void invokeLaterAfterProjectInitialized() {
            StartupManager.getInstance((Project)TrackedEdtActivityService.this.myProject).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater((Runnable)this, TrackedEdtActivityService.this.myDumbStartModality, this.getProjectActivityExpirationCondition()));
        }

        @Override
        public void run() {
            TrackedEdtActivityService.this.myTrackedEdtActivities.remove(this);
            this.myRunnable.run();
        }

        @NotNull
        private Condition getProjectActivityExpirationCondition() {
            return Conditions.or((Condition)TrackedEdtActivityService.this.myProject.getDisposed(), this.getActivityExpirationCondition());
        }

        @NotNull
        Condition<?> getActivityExpirationCondition() {
            return __ -> !TrackedEdtActivityService.this.myTrackedEdtActivities.contains(this);
        }
    }
}

