/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectLocatorImpl
extends ProjectLocator {
    ProjectLocatorImpl() {
    }

    @Nullable
    public Project guessProjectForFile(@Nullable VirtualFile file2) {
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null && !project.isDisposed()) {
            return project;
        }
        if (file2 != null && (project = ProjectLocatorImpl.getPreferredProject((VirtualFile)file2)) != null) {
            return project;
        }
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return null;
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 1) {
            return openProjects[0];
        }
        if (file2 == null) {
            return null;
        }
        return (Project)ReadAction.compute(() -> {
            for (Project openProject2 : projectManager.getOpenProjects()) {
                if (!ProjectLocatorImpl.isUnder(openProject2, file2)) continue;
                return openProject2;
            }
            return null;
        });
    }

    private static boolean isUnder(@NotNull Project project, @NotNull VirtualFile file2) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return fileIndex.isInContent(file2) || fileIndex.isExcluded(file2);
    }

    @NotNull
    public Collection<Project> getProjectsForFile(@NotNull VirtualFile file2) {
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        ReadAction.run(() -> ProjectLocatorImpl.lambda$getProjectsForFile$1(projectManager, file2, (List)result2));
        return result2;
    }

    private static /* synthetic */ void lambda$getProjectsForFile$1(ProjectManager projectManager, VirtualFile file2, List result2) throws RuntimeException {
        for (Project project : projectManager.getOpenProjects()) {
            if (!ProjectLocatorImpl.isUnder(project, file2)) continue;
            result2.add(project);
        }
    }
}

